/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.http;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.http.HttpClient;
import io.vertx.reactivex.core.http.HttpClientRequest;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.concurrent.TimeUnit;

class HttpClientImpl
implements HttpClient {
    private final io.vertx.core.http.HttpClient delegate;
    private static final TypeArg<HttpClientRequest> TYPE_ARG_0 = new TypeArg(o1 -> HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)o1), o1 -> o1.getDelegate());
    private static final TypeArg<HttpClientRequest> TYPE_ARG_1 = new TypeArg(o1 -> HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)o1), o1 -> o1.getDelegate());
    private static final TypeArg<HttpClientRequest> TYPE_ARG_2 = new TypeArg(o1 -> HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)o1), o1 -> o1.getDelegate());
    private static final TypeArg<HttpClientRequest> TYPE_ARG_3 = new TypeArg(o1 -> HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)o1), o1 -> o1.getDelegate());
    private static final TypeArg<HttpClientRequest> TYPE_ARG_4 = new TypeArg(o1 -> HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)o1), o1 -> o1.getDelegate());

    public HttpClientImpl(io.vertx.core.http.HttpClient delegate) {
        this.delegate = delegate;
    }

    public HttpClientImpl(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpClient)delegate;
    }

    @Override
    public io.vertx.core.http.HttpClient getDelegate() {
        return this.delegate;
    }

    @Override
    public Future<HttpClientRequest> request() {
        Future ret = this.delegate.request().map(val -> HttpClientRequest.newInstance(val));
        return ret;
    }

    @Override
    public Single<HttpClientRequest> rxRequest() {
        return AsyncResultSingle.toSingle($handler -> this.request().onComplete($handler));
    }

    @Override
    public Future<HttpClientRequest> request(RequestOptions options) {
        Future ret = this.delegate.request(options).map(val -> HttpClientRequest.newInstance(val));
        return ret;
    }

    @Override
    public Single<HttpClientRequest> rxRequest(RequestOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.request(options).onComplete($handler));
    }

    @Override
    public Future<HttpClientRequest> request(HttpMethod method, int port, String host, String requestURI) {
        Future ret = this.delegate.request(method, port, host, requestURI).map(val -> HttpClientRequest.newInstance(val));
        return ret;
    }

    @Override
    public Single<HttpClientRequest> rxRequest(HttpMethod method, int port, String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.request(method, port, host, requestURI).onComplete($handler));
    }

    @Override
    public Future<HttpClientRequest> request(HttpMethod method, String host, String requestURI) {
        Future ret = this.delegate.request(method, host, requestURI).map(val -> HttpClientRequest.newInstance(val));
        return ret;
    }

    @Override
    public Single<HttpClientRequest> rxRequest(HttpMethod method, String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.request(method, host, requestURI).onComplete($handler));
    }

    @Override
    public Future<HttpClientRequest> request(HttpMethod method, String requestURI) {
        Future ret = this.delegate.request(method, requestURI).map(val -> HttpClientRequest.newInstance(val));
        return ret;
    }

    @Override
    public Single<HttpClientRequest> rxRequest(HttpMethod method, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.request(method, requestURI).onComplete($handler));
    }

    @Override
    public Future<Void> shutdown() {
        Future ret = this.delegate.shutdown().map(val -> val);
        return ret;
    }

    @Override
    public Completable rxShutdown() {
        return AsyncResultCompletable.toCompletable($handler -> this.shutdown().onComplete($handler));
    }

    @Override
    public Future<Void> close() {
        Future ret = this.delegate.close().map(val -> val);
        return ret;
    }

    @Override
    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close().onComplete($handler));
    }

    @Override
    public Future<Void> shutdown(long timeout, TimeUnit unit) {
        Future ret = this.delegate.shutdown(timeout, unit).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxShutdown(long timeout, TimeUnit unit) {
        return AsyncResultCompletable.toCompletable($handler -> this.shutdown(timeout, unit).onComplete($handler));
    }
}

