/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.grpc.common;

import io.reactivex.Completable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.streams.WriteStream;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.WireFormat;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import java.util.function.Function;

@RxGen(value=io.vertx.grpc.common.GrpcWriteStream.class)
public class GrpcWriteStream<T>
implements RxDelegate,
io.vertx.reactivex.core.streams.WriteStream<T> {
    public static final TypeArg<GrpcWriteStream> __TYPE_ARG = new TypeArg(obj -> new GrpcWriteStream((io.vertx.grpc.common.GrpcWriteStream)obj), GrpcWriteStream::getDelegate);
    private final io.vertx.grpc.common.GrpcWriteStream<T> delegate;
    public final TypeArg<T> __typeArg_0;
    private WriteStreamObserver<T> observer;
    private WriteStreamSubscriber<T> subscriber;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrpcWriteStream that = (GrpcWriteStream)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public GrpcWriteStream(io.vertx.grpc.common.GrpcWriteStream delegate) {
        this.delegate = delegate;
        this.__typeArg_0 = TypeArg.unknown();
    }

    public GrpcWriteStream(Object delegate, TypeArg<T> typeArg_0) {
        this.delegate = (io.vertx.grpc.common.GrpcWriteStream)delegate;
        this.__typeArg_0 = typeArg_0;
    }

    public io.vertx.grpc.common.GrpcWriteStream getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized WriteStreamObserver<T> toObserver() {
        if (this.observer == null) {
            Function conv = this.__typeArg_0.unwrap;
            this.observer = RxHelper.toObserver((WriteStream)this.getDelegate(), (Function)conv);
        }
        return this.observer;
    }

    @Override
    public synchronized WriteStreamSubscriber<T> toSubscriber() {
        if (this.subscriber == null) {
            Function conv = this.__typeArg_0.unwrap;
            this.subscriber = RxHelper.toSubscriber((WriteStream)this.getDelegate(), (Function)conv);
        }
        return this.subscriber;
    }

    @Override
    public Future<Void> write(T data) {
        Future ret = this.delegate.write(this.__typeArg_0.unwrap(data)).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxWrite(T data) {
        return AsyncResultCompletable.toCompletable($handler -> this.write(data).onComplete($handler));
    }

    @Override
    public Future<Void> end() {
        Future ret = this.delegate.end().map(val -> val);
        return ret;
    }

    @Override
    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable($handler -> this.end().onComplete($handler));
    }

    @Override
    public Future<Void> end(T data) {
        Future ret = this.delegate.end(this.__typeArg_0.unwrap(data)).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxEnd(T data) {
        return AsyncResultCompletable.toCompletable($handler -> this.end(data).onComplete($handler));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret = this.delegate.headers();
        return ret;
    }

    public GrpcWriteStream<T> encoding(String encoding) {
        this.delegate.encoding(encoding);
        return this;
    }

    public GrpcWriteStream<T> format(WireFormat format) {
        this.delegate.format(format);
        return this;
    }

    @Override
    public GrpcWriteStream<T> exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public GrpcWriteStream<T> setWriteQueueMaxSize(int i) {
        this.delegate.setWriteQueueMaxSize(i);
        return this;
    }

    @Override
    public GrpcWriteStream<T> drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public Future<Void> writeMessage(GrpcMessage message) {
        Future ret = this.delegate.writeMessage(message).map(val -> val);
        return ret;
    }

    public Completable rxWriteMessage(GrpcMessage message) {
        return AsyncResultCompletable.toCompletable($handler -> this.writeMessage(message).onComplete($handler));
    }

    public Future<Void> endMessage(GrpcMessage message) {
        Future ret = this.delegate.endMessage(message).map(val -> val);
        return ret;
    }

    public Completable rxEndMessage(GrpcMessage message) {
        return AsyncResultCompletable.toCompletable($handler -> this.endMessage(message).onComplete($handler));
    }

    public void cancel() {
        this.delegate.cancel();
    }

    public static <T> GrpcWriteStream<T> newInstance(io.vertx.grpc.common.GrpcWriteStream arg) {
        return arg != null ? new GrpcWriteStream<T>(arg) : null;
    }

    public static <T> GrpcWriteStream<T> newInstance(io.vertx.grpc.common.GrpcWriteStream arg, TypeArg<T> __typeArg_T) {
        return arg != null ? new GrpcWriteStream<T>(arg, __typeArg_T) : null;
    }
}

