/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core;

import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.vertx.core.Deployable;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.VertxOptions;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.dns.DnsClientOptions;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.PoolOptions;
import io.vertx.core.http.WebSocketClientOptions;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.Context;
import io.vertx.reactivex.core.Timer;
import io.vertx.reactivex.core.VertxBuilder;
import io.vertx.reactivex.core.WorkerExecutor;
import io.vertx.reactivex.core.datagram.DatagramSocket;
import io.vertx.reactivex.core.dns.DnsClient;
import io.vertx.reactivex.core.eventbus.EventBus;
import io.vertx.reactivex.core.file.FileSystem;
import io.vertx.reactivex.core.http.HttpClientAgent;
import io.vertx.reactivex.core.http.HttpClientBuilder;
import io.vertx.reactivex.core.http.HttpServer;
import io.vertx.reactivex.core.http.WebSocketClient;
import io.vertx.reactivex.core.metrics.Measured;
import io.vertx.reactivex.core.net.NetClient;
import io.vertx.reactivex.core.net.NetServer;
import io.vertx.reactivex.core.shareddata.SharedData;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

@RxGen(value=io.vertx.core.Vertx.class)
public class Vertx
implements RxDelegate,
Measured {
    public static final TypeArg<Vertx> __TYPE_ARG = new TypeArg(obj -> new Vertx((io.vertx.core.Vertx)obj), Vertx::getDelegate);
    private final io.vertx.core.Vertx delegate;
    private static final TypeArg<Vertx> TYPE_ARG_0 = new TypeArg(o1 -> Vertx.newInstance((io.vertx.core.Vertx)o1), o1 -> o1.getDelegate());
    private FileSystem cached_0;
    private EventBus cached_1;
    private SharedData cached_2;
    private Boolean cached_3;
    private Throwable cached_4;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vertx that = (Vertx)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Vertx(io.vertx.core.Vertx delegate) {
        this.delegate = delegate;
    }

    public Vertx(Object delegate) {
        this.delegate = (io.vertx.core.Vertx)delegate;
    }

    public io.vertx.core.Vertx getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public static VertxBuilder builder() {
        VertxBuilder ret = VertxBuilder.newInstance(io.vertx.core.Vertx.builder());
        return ret;
    }

    public static Vertx vertx() {
        Vertx ret = Vertx.newInstance(io.vertx.core.Vertx.vertx());
        return ret;
    }

    public static Vertx vertx(VertxOptions options) {
        Vertx ret = Vertx.newInstance(io.vertx.core.Vertx.vertx((VertxOptions)options));
        return ret;
    }

    public static Future<Vertx> clusteredVertx(VertxOptions options) {
        Future ret = io.vertx.core.Vertx.clusteredVertx((VertxOptions)options).map(val -> Vertx.newInstance(val));
        return ret;
    }

    public static Single<Vertx> rxClusteredVertx(VertxOptions options) {
        return AsyncResultSingle.toSingle($handler -> Vertx.clusteredVertx(options).onComplete($handler));
    }

    public static Context currentContext() {
        Context ret = Context.newInstance(io.vertx.core.Vertx.currentContext());
        return ret;
    }

    public Context getOrCreateContext() {
        Context ret = Context.newInstance(this.delegate.getOrCreateContext());
        return ret;
    }

    public NetServer createNetServer(NetServerOptions options) {
        NetServer ret = NetServer.newInstance(this.delegate.createNetServer(options));
        return ret;
    }

    public NetServer createNetServer() {
        NetServer ret = NetServer.newInstance(this.delegate.createNetServer());
        return ret;
    }

    public NetClient createNetClient(NetClientOptions options) {
        NetClient ret = NetClient.newInstance(this.delegate.createNetClient(options));
        return ret;
    }

    public NetClient createNetClient() {
        NetClient ret = NetClient.newInstance(this.delegate.createNetClient());
        return ret;
    }

    public HttpServer createHttpServer(HttpServerOptions options) {
        HttpServer ret = HttpServer.newInstance(this.delegate.createHttpServer(options));
        return ret;
    }

    public HttpServer createHttpServer() {
        HttpServer ret = HttpServer.newInstance(this.delegate.createHttpServer());
        return ret;
    }

    public WebSocketClient createWebSocketClient() {
        WebSocketClient ret = WebSocketClient.newInstance(this.delegate.createWebSocketClient());
        return ret;
    }

    public WebSocketClient createWebSocketClient(WebSocketClientOptions options) {
        WebSocketClient ret = WebSocketClient.newInstance(this.delegate.createWebSocketClient(options));
        return ret;
    }

    public HttpClientBuilder httpClientBuilder() {
        HttpClientBuilder ret = HttpClientBuilder.newInstance(this.delegate.httpClientBuilder());
        return ret;
    }

    public HttpClientAgent createHttpClient(HttpClientOptions clientOptions, PoolOptions poolOptions) {
        HttpClientAgent ret = HttpClientAgent.newInstance(this.delegate.createHttpClient(clientOptions, poolOptions));
        return ret;
    }

    public HttpClientAgent createHttpClient(HttpClientOptions clientOptions) {
        HttpClientAgent ret = HttpClientAgent.newInstance(this.delegate.createHttpClient(clientOptions));
        return ret;
    }

    public HttpClientAgent createHttpClient(PoolOptions poolOptions) {
        HttpClientAgent ret = HttpClientAgent.newInstance(this.delegate.createHttpClient(poolOptions));
        return ret;
    }

    public HttpClientAgent createHttpClient() {
        HttpClientAgent ret = HttpClientAgent.newInstance(this.delegate.createHttpClient());
        return ret;
    }

    public DatagramSocket createDatagramSocket(DatagramSocketOptions options) {
        DatagramSocket ret = DatagramSocket.newInstance(this.delegate.createDatagramSocket(options));
        return ret;
    }

    public DatagramSocket createDatagramSocket() {
        DatagramSocket ret = DatagramSocket.newInstance(this.delegate.createDatagramSocket());
        return ret;
    }

    public FileSystem fileSystem() {
        FileSystem ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = FileSystem.newInstance(this.delegate.fileSystem());
        return ret;
    }

    public EventBus eventBus() {
        EventBus ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = EventBus.newInstance(this.delegate.eventBus());
        return ret;
    }

    public DnsClient createDnsClient(int port, String host) {
        DnsClient ret = DnsClient.newInstance(this.delegate.createDnsClient(port, host));
        return ret;
    }

    public DnsClient createDnsClient() {
        DnsClient ret = DnsClient.newInstance(this.delegate.createDnsClient());
        return ret;
    }

    public DnsClient createDnsClient(DnsClientOptions options) {
        DnsClient ret = DnsClient.newInstance(this.delegate.createDnsClient(options));
        return ret;
    }

    public SharedData sharedData() {
        SharedData ret;
        if (this.cached_2 != null) {
            return this.cached_2;
        }
        this.cached_2 = ret = SharedData.newInstance(this.delegate.sharedData());
        return ret;
    }

    public Timer timer(long delay) {
        Timer ret = Timer.newInstance(this.delegate.timer(delay));
        return ret;
    }

    public Timer timer(long delay, TimeUnit unit) {
        Timer ret = Timer.newInstance(this.delegate.timer(delay, unit));
        return ret;
    }

    public long setTimer(long delay, Handler<Long> handler) {
        long ret = this.delegate.setTimer(delay, handler);
        return ret;
    }

    public long setPeriodic(long delay, Handler<Long> handler) {
        long ret = this.delegate.setPeriodic(delay, handler);
        return ret;
    }

    public long setPeriodic(long initialDelay, long delay, Handler<Long> handler) {
        long ret = this.delegate.setPeriodic(initialDelay, delay, handler);
        return ret;
    }

    public boolean cancelTimer(long id) {
        boolean ret = this.delegate.cancelTimer(id);
        return ret;
    }

    public void runOnContext(Handler<Void> action) {
        this.delegate.runOnContext(action);
    }

    public Future<Void> close() {
        Future ret = this.delegate.close().map(val -> val);
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close().onComplete($handler));
    }

    public Future<String> deployVerticle(String name) {
        Future ret = this.delegate.deployVerticle(name).map(val -> val);
        return ret;
    }

    public Single<String> rxDeployVerticle(String name) {
        return AsyncResultSingle.toSingle($handler -> this.deployVerticle(name).onComplete($handler));
    }

    public Future<String> deployVerticle(String name, DeploymentOptions options) {
        Future ret = this.delegate.deployVerticle(name, options).map(val -> val);
        return ret;
    }

    public Single<String> rxDeployVerticle(String name, DeploymentOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.deployVerticle(name, options).onComplete($handler));
    }

    public Future<Void> undeploy(String deploymentID) {
        Future ret = this.delegate.undeploy(deploymentID).map(val -> val);
        return ret;
    }

    public Completable rxUndeploy(String deploymentID) {
        return AsyncResultCompletable.toCompletable($handler -> this.undeploy(deploymentID).onComplete($handler));
    }

    public Set<String> deploymentIDs() {
        Set ret = this.delegate.deploymentIDs();
        return ret;
    }

    public boolean isClustered() {
        boolean ret = this.delegate.isClustered();
        return ret;
    }

    public WorkerExecutor createSharedWorkerExecutor(String name) {
        WorkerExecutor ret = WorkerExecutor.newInstance(this.delegate.createSharedWorkerExecutor(name));
        return ret;
    }

    public WorkerExecutor createSharedWorkerExecutor(String name, int poolSize) {
        WorkerExecutor ret = WorkerExecutor.newInstance(this.delegate.createSharedWorkerExecutor(name, poolSize));
        return ret;
    }

    public WorkerExecutor createSharedWorkerExecutor(String name, int poolSize, long maxExecuteTime) {
        WorkerExecutor ret = WorkerExecutor.newInstance(this.delegate.createSharedWorkerExecutor(name, poolSize, maxExecuteTime));
        return ret;
    }

    public WorkerExecutor createSharedWorkerExecutor(String name, int poolSize, long maxExecuteTime, TimeUnit maxExecuteTimeUnit) {
        WorkerExecutor ret = WorkerExecutor.newInstance(this.delegate.createSharedWorkerExecutor(name, poolSize, maxExecuteTime, maxExecuteTimeUnit));
        return ret;
    }

    public boolean isNativeTransportEnabled() {
        if (this.cached_3 != null) {
            return this.cached_3;
        }
        boolean ret = this.delegate.isNativeTransportEnabled();
        this.cached_3 = ret;
        return ret;
    }

    public Throwable unavailableNativeTransportCause() {
        Throwable ret;
        if (this.cached_4 != null) {
            return this.cached_4;
        }
        this.cached_4 = ret = this.delegate.unavailableNativeTransportCause();
        return ret;
    }

    public Vertx exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public Future<String> deployVerticle(Deployable verticle) {
        Future ret = this.delegate.deployVerticle(verticle).map(val -> val);
        return ret;
    }

    public Single<String> rxDeployVerticle(Deployable verticle) {
        return AsyncResultSingle.toSingle($handler -> this.deployVerticle(verticle).onComplete($handler));
    }

    public Future<String> deployVerticle(Deployable verticle, DeploymentOptions options) {
        Future ret = this.delegate.deployVerticle(verticle, options).map(val -> val);
        return ret;
    }

    public Single<String> rxDeployVerticle(Deployable verticle, DeploymentOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.deployVerticle(verticle, options).onComplete($handler));
    }

    public void registerVerticleFactory(VerticleFactory factory) {
        this.delegate.registerVerticleFactory(factory);
    }

    public void unregisterVerticleFactory(VerticleFactory factory) {
        this.delegate.unregisterVerticleFactory(factory);
    }

    public Set<VerticleFactory> verticleFactories() {
        Set ret = this.delegate.verticleFactories();
        return ret;
    }

    public <T> Future<T> executeBlocking(Callable<T> blockingCodeHandler, boolean ordered) {
        Future ret = this.delegate.executeBlocking(blockingCodeHandler, ordered).map(val -> val);
        return ret;
    }

    public <T> Maybe<T> rxExecuteBlocking(Callable<T> blockingCodeHandler, boolean ordered) {
        return AsyncResultMaybe.toMaybe($handler -> this.executeBlocking(blockingCodeHandler, ordered).onComplete($handler));
    }

    public <T> Future<T> executeBlocking(Callable<T> blockingCodeHandler) {
        Future ret = this.delegate.executeBlocking(blockingCodeHandler).map(val -> val);
        return ret;
    }

    public <T> Maybe<T> rxExecuteBlocking(Callable<T> blockingCodeHandler) {
        return AsyncResultMaybe.toMaybe($handler -> this.executeBlocking(blockingCodeHandler).onComplete($handler));
    }

    public static Vertx newInstance(io.vertx.core.Vertx arg) {
        return arg != null ? new Vertx(arg) : null;
    }
}

