/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.mqtt;

import io.netty.handler.codec.mqtt.MqttQoS;
import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.mqtt.MqttClientOptions;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.mqtt.messages.MqttAuthenticationExchangeMessage;
import io.vertx.reactivex.mqtt.messages.MqttConnAckMessage;
import io.vertx.reactivex.mqtt.messages.MqttPublishMessage;
import io.vertx.reactivex.mqtt.messages.MqttSubAckMessage;
import java.util.List;
import java.util.Map;

@RxGen(value=io.vertx.mqtt.MqttClient.class)
public class MqttClient {
    public static final TypeArg<MqttClient> __TYPE_ARG = new TypeArg(obj -> new MqttClient((io.vertx.mqtt.MqttClient)obj), MqttClient::getDelegate);
    private final io.vertx.mqtt.MqttClient delegate;
    private static final TypeArg<MqttConnAckMessage> TYPE_ARG_0 = new TypeArg(o1 -> MqttConnAckMessage.newInstance((io.vertx.mqtt.messages.MqttConnAckMessage)o1), o1 -> o1.getDelegate());
    private static final TypeArg<MqttConnAckMessage> TYPE_ARG_1 = new TypeArg(o1 -> MqttConnAckMessage.newInstance((io.vertx.mqtt.messages.MqttConnAckMessage)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MqttClient that = (MqttClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MqttClient(io.vertx.mqtt.MqttClient delegate) {
        this.delegate = delegate;
    }

    public MqttClient(Object delegate) {
        this.delegate = (io.vertx.mqtt.MqttClient)delegate;
    }

    public io.vertx.mqtt.MqttClient getDelegate() {
        return this.delegate;
    }

    public static MqttClient create(io.vertx.reactivex.core.Vertx vertx, MqttClientOptions options) {
        MqttClient ret = MqttClient.newInstance(io.vertx.mqtt.MqttClient.create((Vertx)vertx.getDelegate(), (MqttClientOptions)options));
        return ret;
    }

    public static MqttClient create(io.vertx.reactivex.core.Vertx vertx) {
        MqttClient ret = MqttClient.newInstance(io.vertx.mqtt.MqttClient.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public Future<MqttConnAckMessage> connect(int port, String host) {
        Future ret = this.delegate.connect(port, host).map(val -> MqttConnAckMessage.newInstance(val));
        return ret;
    }

    public Single<MqttConnAckMessage> rxConnect(int port, String host) {
        return AsyncResultSingle.toSingle($handler -> this.connect(port, host).onComplete($handler));
    }

    public Future<MqttConnAckMessage> connect(int port, String host, String serverName) {
        Future ret = this.delegate.connect(port, host, serverName).map(val -> MqttConnAckMessage.newInstance(val));
        return ret;
    }

    public Single<MqttConnAckMessage> rxConnect(int port, String host, String serverName) {
        return AsyncResultSingle.toSingle($handler -> this.connect(port, host, serverName).onComplete($handler));
    }

    public Future<Void> disconnect() {
        Future ret = this.delegate.disconnect().map(val -> val);
        return ret;
    }

    public Completable rxDisconnect() {
        return AsyncResultCompletable.toCompletable($handler -> this.disconnect().onComplete($handler));
    }

    public Future<Integer> publish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) {
        Future ret = this.delegate.publish(topic, payload, qosLevel, isDup, isRetain).map(val -> val);
        return ret;
    }

    public Single<Integer> rxPublish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) {
        return AsyncResultSingle.toSingle($handler -> this.publish(topic, payload, qosLevel, isDup, isRetain).onComplete($handler));
    }

    public MqttClient publishCompletionHandler(Handler<Integer> publishCompletionHandler) {
        this.delegate.publishCompletionHandler(publishCompletionHandler);
        return this;
    }

    public MqttClient publishCompletionExpirationHandler(Handler<Integer> publishCompletionExpirationHandler) {
        this.delegate.publishCompletionExpirationHandler(publishCompletionExpirationHandler);
        return this;
    }

    public MqttClient publishCompletionUnknownPacketIdHandler(Handler<Integer> publishCompletionPhantomHandler) {
        this.delegate.publishCompletionUnknownPacketIdHandler(publishCompletionPhantomHandler);
        return this;
    }

    public MqttClient publishHandler(Handler<MqttPublishMessage> publishHandler) {
        this.delegate.publishHandler((Handler)new DelegatingHandler(publishHandler, event -> MqttPublishMessage.newInstance(event)));
        return this;
    }

    public MqttClient subscribeCompletionHandler(Handler<MqttSubAckMessage> subscribeCompletionHandler) {
        this.delegate.subscribeCompletionHandler((Handler)new DelegatingHandler(subscribeCompletionHandler, event -> MqttSubAckMessage.newInstance(event)));
        return this;
    }

    public Future<Integer> subscribe(String topic, int qos) {
        Future ret = this.delegate.subscribe(topic, qos).map(val -> val);
        return ret;
    }

    public Single<Integer> rxSubscribe(String topic, int qos) {
        return AsyncResultSingle.toSingle($handler -> this.subscribe(topic, qos).onComplete($handler));
    }

    public Future<Integer> subscribe(Map<String, Integer> topics) {
        Future ret = this.delegate.subscribe(topics).map(val -> val);
        return ret;
    }

    public Single<Integer> rxSubscribe(Map<String, Integer> topics) {
        return AsyncResultSingle.toSingle($handler -> this.subscribe(topics).onComplete($handler));
    }

    public MqttClient unsubscribeCompletionHandler(Handler<Integer> unsubscribeCompletionHandler) {
        this.delegate.unsubscribeCompletionHandler(unsubscribeCompletionHandler);
        return this;
    }

    public Future<Integer> unsubscribe(String topic) {
        Future ret = this.delegate.unsubscribe(topic).map(val -> val);
        return ret;
    }

    public Single<Integer> rxUnsubscribe(String topic) {
        return AsyncResultSingle.toSingle($handler -> this.unsubscribe(topic).onComplete($handler));
    }

    public Future<Integer> unsubscribe(List<String> topics) {
        Future ret = this.delegate.unsubscribe(topics).map(val -> val);
        return ret;
    }

    public Single<Integer> rxUnsubscribe(List<String> topics) {
        return AsyncResultSingle.toSingle($handler -> this.unsubscribe(topics).onComplete($handler));
    }

    public MqttClient authenticationExchangeHandler(Handler<MqttAuthenticationExchangeMessage> authenticationExchangeHandler) {
        this.delegate.authenticationExchangeHandler((Handler)new DelegatingHandler(authenticationExchangeHandler, event -> MqttAuthenticationExchangeMessage.newInstance(event)));
        return this;
    }

    public Future<Void> authenticationExchange(MqttAuthenticationExchangeMessage message) {
        Future ret = this.delegate.authenticationExchange(message.getDelegate()).map(val -> val);
        return ret;
    }

    public Completable rxAuthenticationExchange(MqttAuthenticationExchangeMessage message) {
        return AsyncResultCompletable.toCompletable($handler -> this.authenticationExchange(message).onComplete($handler));
    }

    public MqttClient pingResponseHandler(Handler<Void> pingResponseHandler) {
        this.delegate.pingResponseHandler(pingResponseHandler);
        return this;
    }

    public MqttClient exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public MqttClient closeHandler(Handler<Void> closeHandler) {
        this.delegate.closeHandler(closeHandler);
        return this;
    }

    public MqttClient ping() {
        this.delegate.ping();
        return this;
    }

    public String clientId() {
        String ret = this.delegate.clientId();
        return ret;
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    public static MqttClient newInstance(io.vertx.mqtt.MqttClient arg) {
        return arg != null ? new MqttClient(arg) : null;
    }
}

