/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.shareddata;

import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@RxGen(value=io.vertx.core.shareddata.AsyncMap.class)
public class AsyncMap<K, V> {
    public static final TypeArg<AsyncMap> __TYPE_ARG = new TypeArg(obj -> new AsyncMap((io.vertx.core.shareddata.AsyncMap)obj), AsyncMap::getDelegate);
    private final io.vertx.core.shareddata.AsyncMap<K, V> delegate;
    public final TypeArg<K> __typeArg_0;
    public final TypeArg<V> __typeArg_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsyncMap that = (AsyncMap)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AsyncMap(io.vertx.core.shareddata.AsyncMap delegate) {
        this.delegate = delegate;
        this.__typeArg_0 = TypeArg.unknown();
        this.__typeArg_1 = TypeArg.unknown();
    }

    public AsyncMap(Object delegate, TypeArg<K> typeArg_0, TypeArg<V> typeArg_1) {
        this.delegate = (io.vertx.core.shareddata.AsyncMap)delegate;
        this.__typeArg_0 = typeArg_0;
        this.__typeArg_1 = typeArg_1;
    }

    public io.vertx.core.shareddata.AsyncMap getDelegate() {
        return this.delegate;
    }

    public Future<V> get(K k) {
        Future ret = this.delegate.get(this.__typeArg_0.unwrap(k)).map(val -> this.__typeArg_1.wrap(val));
        return ret;
    }

    public Maybe<V> rxGet(K k) {
        return AsyncResultMaybe.toMaybe($handler -> this.get(k).onComplete($handler));
    }

    public Future<Void> put(K k, V v) {
        Future ret = this.delegate.put(this.__typeArg_0.unwrap(k), this.__typeArg_1.unwrap(v)).map(val -> val);
        return ret;
    }

    public Completable rxPut(K k, V v) {
        return AsyncResultCompletable.toCompletable($handler -> this.put(k, v).onComplete($handler));
    }

    public Future<Void> put(K k, V v, long ttl) {
        Future ret = this.delegate.put(this.__typeArg_0.unwrap(k), this.__typeArg_1.unwrap(v), ttl).map(val -> val);
        return ret;
    }

    public Completable rxPut(K k, V v, long ttl) {
        return AsyncResultCompletable.toCompletable($handler -> this.put(k, v, ttl).onComplete($handler));
    }

    public Future<V> putIfAbsent(K k, V v) {
        Future ret = this.delegate.putIfAbsent(this.__typeArg_0.unwrap(k), this.__typeArg_1.unwrap(v)).map(val -> this.__typeArg_1.wrap(val));
        return ret;
    }

    public Maybe<V> rxPutIfAbsent(K k, V v) {
        return AsyncResultMaybe.toMaybe($handler -> this.putIfAbsent(k, v).onComplete($handler));
    }

    public Future<V> putIfAbsent(K k, V v, long ttl) {
        Future ret = this.delegate.putIfAbsent(this.__typeArg_0.unwrap(k), this.__typeArg_1.unwrap(v), ttl).map(val -> this.__typeArg_1.wrap(val));
        return ret;
    }

    public Maybe<V> rxPutIfAbsent(K k, V v, long ttl) {
        return AsyncResultMaybe.toMaybe($handler -> this.putIfAbsent(k, v, ttl).onComplete($handler));
    }

    public Future<V> remove(K k) {
        Future ret = this.delegate.remove(this.__typeArg_0.unwrap(k)).map(val -> this.__typeArg_1.wrap(val));
        return ret;
    }

    public Maybe<V> rxRemove(K k) {
        return AsyncResultMaybe.toMaybe($handler -> this.remove(k).onComplete($handler));
    }

    public Future<Boolean> removeIfPresent(K k, V v) {
        Future ret = this.delegate.removeIfPresent(this.__typeArg_0.unwrap(k), this.__typeArg_1.unwrap(v)).map(val -> val);
        return ret;
    }

    public Single<Boolean> rxRemoveIfPresent(K k, V v) {
        return AsyncResultSingle.toSingle($handler -> this.removeIfPresent(k, v).onComplete($handler));
    }

    public Future<V> replace(K k, V v) {
        Future ret = this.delegate.replace(this.__typeArg_0.unwrap(k), this.__typeArg_1.unwrap(v)).map(val -> this.__typeArg_1.wrap(val));
        return ret;
    }

    public Maybe<V> rxReplace(K k, V v) {
        return AsyncResultMaybe.toMaybe($handler -> this.replace(k, v).onComplete($handler));
    }

    public Future<V> replace(K k, V v, long ttl) {
        Future ret = this.delegate.replace(this.__typeArg_0.unwrap(k), this.__typeArg_1.unwrap(v), ttl).map(val -> this.__typeArg_1.wrap(val));
        return ret;
    }

    public Maybe<V> rxReplace(K k, V v, long ttl) {
        return AsyncResultMaybe.toMaybe($handler -> this.replace(k, v, ttl).onComplete($handler));
    }

    public Future<Boolean> replaceIfPresent(K k, V oldValue, V newValue) {
        Future ret = this.delegate.replaceIfPresent(this.__typeArg_0.unwrap(k), this.__typeArg_1.unwrap(oldValue), this.__typeArg_1.unwrap(newValue)).map(val -> val);
        return ret;
    }

    public Single<Boolean> rxReplaceIfPresent(K k, V oldValue, V newValue) {
        return AsyncResultSingle.toSingle($handler -> this.replaceIfPresent(k, oldValue, newValue).onComplete($handler));
    }

    public Future<Boolean> replaceIfPresent(K k, V oldValue, V newValue, long ttl) {
        Future ret = this.delegate.replaceIfPresent(this.__typeArg_0.unwrap(k), this.__typeArg_1.unwrap(oldValue), this.__typeArg_1.unwrap(newValue), ttl).map(val -> val);
        return ret;
    }

    public Single<Boolean> rxReplaceIfPresent(K k, V oldValue, V newValue, long ttl) {
        return AsyncResultSingle.toSingle($handler -> this.replaceIfPresent(k, oldValue, newValue, ttl).onComplete($handler));
    }

    public Future<Void> clear() {
        Future ret = this.delegate.clear().map(val -> val);
        return ret;
    }

    public Completable rxClear() {
        return AsyncResultCompletable.toCompletable($handler -> this.clear().onComplete($handler));
    }

    public Future<Integer> size() {
        Future ret = this.delegate.size().map(val -> val);
        return ret;
    }

    public Single<Integer> rxSize() {
        return AsyncResultSingle.toSingle($handler -> this.size().onComplete($handler));
    }

    public Future<Set<K>> keys() {
        Future ret = this.delegate.keys().map(val -> val.stream().map(elt -> this.__typeArg_0.wrap(elt)).collect(Collectors.toSet()));
        return ret;
    }

    public Single<Set<K>> rxKeys() {
        return AsyncResultSingle.toSingle($handler -> this.keys().onComplete($handler));
    }

    public Future<List<V>> values() {
        Future ret = this.delegate.values().map(val -> val.stream().map(elt -> this.__typeArg_1.wrap(elt)).collect(Collectors.toList()));
        return ret;
    }

    public Single<List<V>> rxValues() {
        return AsyncResultSingle.toSingle($handler -> this.values().onComplete($handler));
    }

    public static <K, V> AsyncMap<K, V> newInstance(io.vertx.core.shareddata.AsyncMap arg) {
        return arg != null ? new AsyncMap<K, V>(arg) : null;
    }

    public static <K, V> AsyncMap<K, V> newInstance(io.vertx.core.shareddata.AsyncMap arg, TypeArg<K> __typeArg_K, TypeArg<V> __typeArg_V) {
        return arg != null ? new AsyncMap<K, V>(arg, __typeArg_K, __typeArg_V) : null;
    }
}

