/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.cassandra;

import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.cassandra.CassandraClientOptions;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.cassandra.CassandraRowStream;
import io.vertx.reactivex.cassandra.ResultSet;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.List;

@RxGen(value=io.vertx.cassandra.CassandraClient.class)
public class CassandraClient {
    public static final TypeArg<CassandraClient> __TYPE_ARG = new TypeArg(obj -> new CassandraClient((io.vertx.cassandra.CassandraClient)obj), CassandraClient::getDelegate);
    private final io.vertx.cassandra.CassandraClient delegate;
    private static final TypeArg<ResultSet> TYPE_ARG_0 = new TypeArg(o1 -> ResultSet.newInstance((io.vertx.cassandra.ResultSet)o1), o1 -> o1.getDelegate());
    private static final TypeArg<CassandraRowStream> TYPE_ARG_1 = new TypeArg(o1 -> CassandraRowStream.newInstance((io.vertx.cassandra.CassandraRowStream)o1), o1 -> o1.getDelegate());
    private static final TypeArg<ResultSet> TYPE_ARG_2 = new TypeArg(o1 -> ResultSet.newInstance((io.vertx.cassandra.ResultSet)o1), o1 -> o1.getDelegate());
    private static final TypeArg<CassandraRowStream> TYPE_ARG_3 = new TypeArg(o1 -> CassandraRowStream.newInstance((io.vertx.cassandra.CassandraRowStream)o1), o1 -> o1.getDelegate());
    public static final String DEFAULT_SHARED_CLIENT_NAME = "DEFAULT";

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CassandraClient that = (CassandraClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public CassandraClient(io.vertx.cassandra.CassandraClient delegate) {
        this.delegate = delegate;
    }

    public CassandraClient(Object delegate) {
        this.delegate = (io.vertx.cassandra.CassandraClient)delegate;
    }

    public io.vertx.cassandra.CassandraClient getDelegate() {
        return this.delegate;
    }

    public static CassandraClient create(io.vertx.reactivex.core.Vertx vertx) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static CassandraClient create(io.vertx.reactivex.core.Vertx vertx, CassandraClientOptions options) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.create((Vertx)vertx.getDelegate(), (CassandraClientOptions)options));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.reactivex.core.Vertx vertx) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.reactivex.core.Vertx vertx, String clientName) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate(), (String)clientName));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.reactivex.core.Vertx vertx, CassandraClientOptions options) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate(), (CassandraClientOptions)options));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.reactivex.core.Vertx vertx, String clientName, CassandraClientOptions options) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate(), (String)clientName, (CassandraClientOptions)options));
        return ret;
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    public Future<ResultSet> execute(String query) {
        Future ret = this.delegate.execute(query).map(val -> ResultSet.newInstance(val));
        return ret;
    }

    public Single<ResultSet> rxExecute(String query) {
        return AsyncResultSingle.toSingle($handler -> this.execute(query).onComplete($handler));
    }

    public Future<CassandraRowStream> queryStream(String sql) {
        Future ret = this.delegate.queryStream(sql).map(val -> CassandraRowStream.newInstance(val));
        return ret;
    }

    public Single<CassandraRowStream> rxQueryStream(String sql) {
        return AsyncResultSingle.toSingle($handler -> this.queryStream(sql).onComplete($handler));
    }

    public Future<Void> close() {
        Future ret = this.delegate.close().map(val -> val);
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close().onComplete($handler));
    }

    public Future<List<Row>> executeWithFullFetch(String query) {
        Future ret = this.delegate.executeWithFullFetch(query).map(val -> val);
        return ret;
    }

    public Single<List<Row>> rxExecuteWithFullFetch(String query) {
        return AsyncResultSingle.toSingle($handler -> this.executeWithFullFetch(query).onComplete($handler));
    }

    public Future<List<Row>> executeWithFullFetch(Statement statement) {
        Future ret = this.delegate.executeWithFullFetch(statement).map(val -> val);
        return ret;
    }

    public Single<List<Row>> rxExecuteWithFullFetch(Statement statement) {
        return AsyncResultSingle.toSingle($handler -> this.executeWithFullFetch(statement).onComplete($handler));
    }

    public Future<ResultSet> execute(Statement statement) {
        Future ret = this.delegate.execute(statement).map(val -> ResultSet.newInstance(val));
        return ret;
    }

    public Single<ResultSet> rxExecute(Statement statement) {
        return AsyncResultSingle.toSingle($handler -> this.execute(statement).onComplete($handler));
    }

    public Future<PreparedStatement> prepare(String query) {
        Future ret = this.delegate.prepare(query).map(val -> val);
        return ret;
    }

    public Single<PreparedStatement> rxPrepare(String query) {
        return AsyncResultSingle.toSingle($handler -> this.prepare(query).onComplete($handler));
    }

    public Future<PreparedStatement> prepare(SimpleStatement statement) {
        Future ret = this.delegate.prepare(statement).map(val -> val);
        return ret;
    }

    public Single<PreparedStatement> rxPrepare(SimpleStatement statement) {
        return AsyncResultSingle.toSingle($handler -> this.prepare(statement).onComplete($handler));
    }

    public Future<CassandraRowStream> queryStream(Statement statement) {
        Future ret = this.delegate.queryStream(statement).map(val -> CassandraRowStream.newInstance(val));
        return ret;
    }

    public Single<CassandraRowStream> rxQueryStream(Statement statement) {
        return AsyncResultSingle.toSingle($handler -> this.queryStream(statement).onComplete($handler));
    }

    public Future<Metadata> metadata() {
        Future ret = this.delegate.metadata().map(val -> val);
        return ret;
    }

    public Single<Metadata> rxMetadata() {
        return AsyncResultSingle.toSingle($handler -> this.metadata().onComplete($handler));
    }

    public static CassandraClient newInstance(io.vertx.cassandra.CassandraClient arg) {
        return arg != null ? new CassandraClient(arg) : null;
    }
}

