/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.redis.client;

import io.reactivex.Maybe;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.lang.reactivex.Helper;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.redis.client.RedisConnection;
import io.vertx.reactivex.redis.client.Request;
import io.vertx.reactivex.redis.client.Response;
import io.vertx.redis.client.RedisOptions;
import java.util.List;
import java.util.stream.Collectors;

@RxGen(value=io.vertx.redis.client.Redis.class)
public class Redis
implements RxDelegate {
    public static final TypeArg<Redis> __TYPE_ARG = new TypeArg(obj -> new Redis((io.vertx.redis.client.Redis)obj), Redis::getDelegate);
    private final io.vertx.redis.client.Redis delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Redis that = (Redis)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Redis(io.vertx.redis.client.Redis delegate) {
        this.delegate = delegate;
    }

    public Redis(Object delegate) {
        this.delegate = (io.vertx.redis.client.Redis)delegate;
    }

    public io.vertx.redis.client.Redis getDelegate() {
        return this.delegate;
    }

    public static Redis createClient(io.vertx.reactivex.core.Vertx vertx) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClient((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static Redis createClient(io.vertx.reactivex.core.Vertx vertx, String connectionString) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClient((Vertx)vertx.getDelegate(), (String)connectionString));
        return ret;
    }

    public static Redis createClient(io.vertx.reactivex.core.Vertx vertx, RedisOptions options) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClient((Vertx)vertx.getDelegate(), (RedisOptions)options));
        return ret;
    }

    public Redis connect(Handler<AsyncResult<RedisConnection>> handler) {
        this.delegate.connect(Helper.convertHandler(handler, ar -> ar.map(event -> RedisConnection.newInstance(event))));
        return this;
    }

    public Redis connect() {
        return this.connect((Handler<AsyncResult<RedisConnection>>)((Handler)ar -> {}));
    }

    public Single<RedisConnection> rxConnect() {
        return AsyncResultSingle.toSingle($handler -> this.connect((Handler<AsyncResult<RedisConnection>>)$handler));
    }

    public void close() {
        this.delegate.close();
    }

    public Redis send(Request command, Handler<AsyncResult<Response>> onSend) {
        this.delegate.send(command.getDelegate(), Helper.convertHandler(onSend, ar -> ar.map(event -> Response.newInstance(event))));
        return this;
    }

    public Redis send(Request command) {
        return this.send(command, (Handler<AsyncResult<Response>>)((Handler)ar -> {}));
    }

    public Maybe<Response> rxSend(Request command) {
        return AsyncResultMaybe.toMaybe($handler -> this.send(command, (Handler<AsyncResult<Response>>)$handler));
    }

    public Redis batch(List<Request> commands, Handler<AsyncResult<List<Response>>> onSend) {
        this.delegate.batch(commands.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), Helper.convertHandler(onSend, ar -> ar.map(event -> event.stream().map(elt -> Response.newInstance(elt)).collect(Collectors.toList()))));
        return this;
    }

    public Redis batch(List<Request> commands) {
        return this.batch(commands, (Handler<AsyncResult<List<Response>>>)((Handler)ar -> {}));
    }

    public Single<List<Response>> rxBatch(List<Request> commands) {
        return AsyncResultSingle.toSingle($handler -> this.batch(commands, (Handler<AsyncResult<List<Response>>>)$handler));
    }

    public static Redis newInstance(io.vertx.redis.client.Redis arg) {
        return arg != null ? new Redis(arg) : null;
    }
}

