/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.shell.term;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.term.SockJSTermHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.shell.term.SockJSTermHandler.class)
public class SockJSTermHandler implements RxDelegate, Handler<io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SockJSTermHandler that = (SockJSTermHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SockJSTermHandler> __TYPE_ARG = new TypeArg<>(    obj -> new SockJSTermHandler((io.vertx.ext.shell.term.SockJSTermHandler) obj),
    SockJSTermHandler::getDelegate
  );

  private final io.vertx.ext.shell.term.SockJSTermHandler delegate;
  
  public SockJSTermHandler(io.vertx.ext.shell.term.SockJSTermHandler delegate) {
    this.delegate = delegate;
  }

  public SockJSTermHandler(Object delegate) {
    this.delegate = (io.vertx.ext.shell.term.SockJSTermHandler)delegate;
  }

  @Override 
  public io.vertx.ext.shell.term.SockJSTermHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket event) { 
    delegate.handle(event.getDelegate());
  }

  public static io.vertx.reactivex.ext.shell.term.SockJSTermHandler create(io.vertx.reactivex.core.Vertx vertx, java.lang.String charset) { 
    io.vertx.reactivex.ext.shell.term.SockJSTermHandler ret = io.vertx.reactivex.ext.shell.term.SockJSTermHandler.newInstance((io.vertx.ext.shell.term.SockJSTermHandler)io.vertx.ext.shell.term.SockJSTermHandler.create(vertx.getDelegate(), charset));
    return ret;
  }

  public io.vertx.reactivex.ext.shell.term.SockJSTermHandler termHandler(io.vertx.core.Handler<io.vertx.reactivex.ext.shell.term.Term> handler) { 
    delegate.termHandler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.ext.shell.term.Term.newInstance((io.vertx.ext.shell.term.Term)event)));
    return this;
  }

  public static SockJSTermHandler newInstance(io.vertx.ext.shell.term.SockJSTermHandler arg) {
    return arg != null ? new SockJSTermHandler(arg) : null;
  }

}
