/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A user customizable authentication handler.
 * <p>
 * An auth handler allows your application to provide authentication support. The handler is not fully functional
 * without a authentication function. This function takes the  as input and returns a .
 *
 * The future should return a non <code>null</code> user object. In the {@link io.vertx.reactivex.ext.web.handler.SimpleAuthenticationHandler#authenticate} you have full control
 * on the request, so all operations like redirect, next, fail are allowed. There are some rules that need to be followed
 * in order to allow this handler to properly interop with {@link io.vertx.reactivex.ext.web.handler.ChainAuthHandler}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.SimpleAuthenticationHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.SimpleAuthenticationHandler.class)
public class SimpleAuthenticationHandler implements RxDelegate, io.vertx.reactivex.ext.web.handler.AuthenticationHandler, Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SimpleAuthenticationHandler that = (SimpleAuthenticationHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SimpleAuthenticationHandler> __TYPE_ARG = new TypeArg<>(    obj -> new SimpleAuthenticationHandler((io.vertx.ext.web.handler.SimpleAuthenticationHandler) obj),
    SimpleAuthenticationHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.SimpleAuthenticationHandler delegate;
  
  public SimpleAuthenticationHandler(io.vertx.ext.web.handler.SimpleAuthenticationHandler delegate) {
    this.delegate = delegate;
  }

  public SimpleAuthenticationHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.SimpleAuthenticationHandler)delegate;
  }

  @Override 
  public io.vertx.ext.web.handler.SimpleAuthenticationHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Creates a new instance of the simple authentication handler.
   * @return a new instance.
   */
  public static io.vertx.reactivex.ext.web.handler.SimpleAuthenticationHandler create() { 
    io.vertx.reactivex.ext.web.handler.SimpleAuthenticationHandler ret = io.vertx.reactivex.ext.web.handler.SimpleAuthenticationHandler.newInstance((io.vertx.ext.web.handler.SimpleAuthenticationHandler)io.vertx.ext.web.handler.SimpleAuthenticationHandler.create());
    return ret;
  }

  /**
   * This function will allow you to perform authentication the way you intended to. The process should be self
   * explanatory, for example if the request contains a given property completing the function with a non <code>null</code>
   *  object is enough to allow the handler to continue.
   *
   * In order to signal errors, you should not call  or .
   *
   * Errors should be signaled using the {@link io.vertx.ext.web.handler.HttpException} type. Any other kind of errors will be wrapped as a 401
   * error. For example forbidden access should be signaled with: <code>new HttpException(403)</code>. This is required when
   * working with {@link io.vertx.reactivex.ext.web.handler.ChainAuthHandler}. By using exceptions to signal failures instead of immediately terminating
   * the request, it allows the chain to proceed to the next handler if needed.
   * @param authenticationFunction the authentication function.
   * @return self
   */
  public io.vertx.reactivex.ext.web.handler.SimpleAuthenticationHandler authenticate(java.util.function.Function<io.vertx.reactivex.ext.web.RoutingContext,io.vertx.core.Future<io.vertx.reactivex.ext.auth.User>> authenticationFunction) { 
    delegate.authenticate(new Function<io.vertx.ext.web.RoutingContext,io.vertx.core.Future<io.vertx.ext.auth.User>>() {
      public io.vertx.core.Future<io.vertx.ext.auth.User> apply(io.vertx.ext.web.RoutingContext arg) {
        io.vertx.core.Future<io.vertx.reactivex.ext.auth.User> ret = authenticationFunction.apply(io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)arg));
        return ret.map(val -> val.getDelegate());
      }
    });
    return this;
  }

  /**
   * This function will allow you to perform authentication the way you intended to. The process should be self
   * explanatory, for example if the request contains a given property completing the function with a non <code>null</code>
   *  object is enough to allow the handler to continue.
   *
   * In order to signal errors, you should not call  or .
   *
   * Errors should be signaled using the {@link io.vertx.ext.web.handler.HttpException} type. Any other kind of errors will be wrapped as a 401
   * error. For example forbidden access should be signaled with: <code>new HttpException(403)</code>. This is required when
   * working with {@link io.vertx.reactivex.ext.web.handler.ChainAuthHandler}. By using exceptions to signal failures instead of immediately terminating
   * the request, it allows the chain to proceed to the next handler if needed.
   * @param authenticationFunction the authentication function.
   * @return self
   */
  public io.vertx.reactivex.ext.web.handler.SimpleAuthenticationHandler authenticate(io.reactivex.functions.Function<io.vertx.reactivex.ext.web.RoutingContext,io.reactivex.Single<io.vertx.reactivex.ext.auth.User>> authenticationFunction) { 
    delegate.authenticate(new Function<io.vertx.ext.web.RoutingContext,io.vertx.core.Future<io.vertx.ext.auth.User>>() {
      public io.vertx.core.Future<io.vertx.ext.auth.User> apply(io.vertx.ext.web.RoutingContext arg) {
        io.reactivex.Single<io.vertx.reactivex.ext.auth.User> ret;
        try {
          ret = authenticationFunction.apply(io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)arg));
        } catch (Exception e) {
          return io.vertx.core.Future.failedFuture(e);
        }
        return io.vertx.reactivex.SingleHelper.toFuture(ret, obj -> obj.getDelegate());
      }
    });
    return this;
  }

  public static SimpleAuthenticationHandler newInstance(io.vertx.ext.web.handler.SimpleAuthenticationHandler arg) {
    return arg != null ? new SimpleAuthenticationHandler(arg) : null;
  }

}
