/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.file;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents properties of a file on the file system.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.file.FileProps original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.file.FileProps.class)
public class FileProps implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FileProps that = (FileProps) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<FileProps> __TYPE_ARG = new TypeArg<>(    obj -> new FileProps((io.vertx.core.file.FileProps) obj),
    FileProps::getDelegate
  );

  private final io.vertx.core.file.FileProps delegate;
  
  public FileProps(io.vertx.core.file.FileProps delegate) {
    this.delegate = delegate;
  }

  public FileProps(Object delegate) {
    this.delegate = (io.vertx.core.file.FileProps)delegate;
  }

  @Override 
  public io.vertx.core.file.FileProps getDelegate() {
    return delegate;
  }

  /**
   * The date the file was created
   * @return 
   */
  public long creationTime() { 
    long ret = delegate.creationTime();
    return ret;
  }

  /**
   * The date the file was last accessed
   * @return 
   */
  public long lastAccessTime() { 
    long ret = delegate.lastAccessTime();
    return ret;
  }

  /**
   * The date the file was last modified
   * @return 
   */
  public long lastModifiedTime() { 
    long ret = delegate.lastModifiedTime();
    return ret;
  }

  /**
   * Is the file a directory?
   * @return 
   */
  public boolean isDirectory() { 
    boolean ret = delegate.isDirectory();
    return ret;
  }

  /**
   * Is the file some other type? (I.e. not a directory, regular file or symbolic link)
   * @return 
   */
  public boolean isOther() { 
    boolean ret = delegate.isOther();
    return ret;
  }

  /**
   * Is the file a regular file?
   * @return 
   */
  public boolean isRegularFile() { 
    boolean ret = delegate.isRegularFile();
    return ret;
  }

  /**
   * Is the file a symbolic link?
   * @return 
   */
  public boolean isSymbolicLink() { 
    boolean ret = delegate.isSymbolicLink();
    return ret;
  }

  /**
   * The size of the file, in bytes
   * @return 
   */
  public long size() { 
    long ret = delegate.size();
    return ret;
  }

  public static FileProps newInstance(io.vertx.core.file.FileProps arg) {
    return arg != null ? new FileProps(arg) : null;
  }

}
