/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Content Security Policy (CSP) is an added layer of security that helps to detect and mitigate certain types of
 * attacks, including Cross Site Scripting (XSS) and data injection attacks. These attacks are used for everything from
 * data theft to site defacement to distribution of malware.
 *
 * CSP is designed to be fully backward compatible. Browsers that don't support it still work with servers that
 * implement it, and vice-versa: browsers that don't support CSP simply ignore it, functioning as usual, defaulting to
 * the standard same-origin policy for web content. If the site doesn't offer the CSP header, browsers likewise use the
 * standard same-origin policy.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.CSPHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.CSPHandler.class)
public class CSPHandler implements RxDelegate, io.vertx.reactivex.ext.web.handler.SecurityPolicyHandler, Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CSPHandler that = (CSPHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<CSPHandler> __TYPE_ARG = new TypeArg<>(    obj -> new CSPHandler((io.vertx.ext.web.handler.CSPHandler) obj),
    CSPHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.CSPHandler delegate;
  
  public CSPHandler(io.vertx.ext.web.handler.CSPHandler delegate) {
    this.delegate = delegate;
  }

  public CSPHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.CSPHandler)delegate;
  }

  @Override 
  public io.vertx.ext.web.handler.CSPHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Creates a new instance of the handler.
   * @return a new CSP handler.
   */
  public static io.vertx.reactivex.ext.web.handler.CSPHandler create() { 
    io.vertx.reactivex.ext.web.handler.CSPHandler ret = io.vertx.reactivex.ext.web.handler.CSPHandler.newInstance((io.vertx.ext.web.handler.CSPHandler)io.vertx.ext.web.handler.CSPHandler.create());
    return ret;
  }

  /**
   * Sets a single directive entry to the handler. All previously set or added directives will be replaced.
   * For more information on directives see: <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy">Content-Security-Policy</a>.
   * @param name the directive name
   * @param value the directive value.
   * @return fluent self
   */
  public io.vertx.reactivex.ext.web.handler.CSPHandler setDirective(java.lang.String name, java.lang.String value) { 
    delegate.setDirective(name, value);
    return this;
  }

  /**
   * Adds a single directive entry to the handler. All previously set or added directives will be preserved.
   * For more information on directives see: <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy">Content-Security-Policy</a>.
   * @param name the directive name
   * @param value the directive value.
   * @return fluent self
   */
  public io.vertx.reactivex.ext.web.handler.CSPHandler addDirective(java.lang.String name, java.lang.String value) { 
    delegate.addDirective(name, value);
    return this;
  }

  /**
   * To ease deployment, CSP can be deployed in report-only mode. The policy is not enforced, but any violations are
   * reported to a provided URI. Additionally, a report-only header can be used to test a future revision to a policy
   * without actually deploying it.
   * @param reportOnly enable report only
   * @return fluent self.
   */
  public io.vertx.reactivex.ext.web.handler.CSPHandler setReportOnly(boolean reportOnly) { 
    delegate.setReportOnly(reportOnly);
    return this;
  }

  public static CSPHandler newInstance(io.vertx.ext.web.handler.CSPHandler arg) {
    return arg != null ? new CSPHandler(arg) : null;
  }

}
