/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.http;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.lang.reactivex.Helper;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import io.vertx.reactivex.core.MultiMap;
import io.vertx.reactivex.core.http.WebSocket;
import io.vertx.reactivex.core.http.WebSocketFrame;
import io.vertx.reactivex.core.net.SocketAddress;
import io.vertx.reactivex.core.streams.Pipe;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.function.Function;
import javax.net.ssl.SSLSession;

@RxGen(value=io.vertx.core.http.ClientWebSocket.class)
public class ClientWebSocket
extends WebSocket
implements RxDelegate {
    public static final TypeArg<ClientWebSocket> __TYPE_ARG = new TypeArg(obj -> new ClientWebSocket((io.vertx.core.http.ClientWebSocket)obj), ClientWebSocket::getDelegate);
    private final io.vertx.core.http.ClientWebSocket delegate;
    private Observable<io.vertx.reactivex.core.buffer.Buffer> observable;
    private Flowable<io.vertx.reactivex.core.buffer.Buffer> flowable;
    private WriteStreamObserver<io.vertx.reactivex.core.buffer.Buffer> observer;
    private WriteStreamSubscriber<io.vertx.reactivex.core.buffer.Buffer> subscriber;
    private static final TypeArg<io.vertx.reactivex.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg(o1 -> io.vertx.reactivex.core.buffer.Buffer.newInstance((Buffer)o1), o1 -> o1.getDelegate());
    private SocketAddress cached_0;
    private SocketAddress cached_1;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientWebSocket that = (ClientWebSocket)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public ClientWebSocket(io.vertx.core.http.ClientWebSocket delegate) {
        super((io.vertx.core.http.WebSocket)delegate);
        this.delegate = delegate;
    }

    public ClientWebSocket(Object delegate) {
        super((io.vertx.core.http.WebSocket)((io.vertx.core.http.ClientWebSocket)delegate));
        this.delegate = (io.vertx.core.http.ClientWebSocket)delegate;
    }

    public io.vertx.core.http.ClientWebSocket getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<io.vertx.reactivex.core.buffer.Buffer> toObservable() {
        if (this.observable == null) {
            Function<Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
            this.observable = ObservableHelper.toObservable((ReadStream)this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<io.vertx.reactivex.core.buffer.Buffer> toFlowable() {
        if (this.flowable == null) {
            Function<Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
            this.flowable = FlowableHelper.toFlowable((ReadStream)this.delegate, conv);
        }
        return this.flowable;
    }

    @Override
    public synchronized WriteStreamObserver<io.vertx.reactivex.core.buffer.Buffer> toObserver() {
        if (this.observer == null) {
            Function<io.vertx.reactivex.core.buffer.Buffer, Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::getDelegate;
            this.observer = RxHelper.toObserver((WriteStream)this.getDelegate(), conv);
        }
        return this.observer;
    }

    @Override
    public synchronized WriteStreamSubscriber<io.vertx.reactivex.core.buffer.Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<io.vertx.reactivex.core.buffer.Buffer, Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::getDelegate;
            this.subscriber = RxHelper.toSubscriber((WriteStream)this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public Pipe<io.vertx.reactivex.core.buffer.Buffer> pipe() {
        Pipe<io.vertx.reactivex.core.buffer.Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    @Override
    public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) {
        this.pipeTo(dst, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) {
        return AsyncResultCompletable.toCompletable($handler -> this.pipeTo(dst, (Handler<AsyncResult<Void>>)$handler));
    }

    @Override
    public void write(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.write((Object)data.getDelegate(), handler);
    }

    @Override
    public void write(io.vertx.reactivex.core.buffer.Buffer data) {
        this.write(data, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxWrite(io.vertx.reactivex.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable($handler -> this.write(data, (Handler<AsyncResult<Void>>)$handler));
    }

    @Override
    public void end(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.end((Object)data.getDelegate(), handler);
    }

    @Override
    public void end(io.vertx.reactivex.core.buffer.Buffer data) {
        this.end(data, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxEnd(io.vertx.reactivex.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable($handler -> this.end(data, (Handler<AsyncResult<Void>>)$handler));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public String binaryHandlerID() {
        String ret = this.delegate.binaryHandlerID();
        return ret;
    }

    @Override
    public String textHandlerID() {
        String ret = this.delegate.textHandlerID();
        return ret;
    }

    @Override
    public String subProtocol() {
        String ret = this.delegate.subProtocol();
        return ret;
    }

    @Override
    public Short closeStatusCode() {
        Short ret = this.delegate.closeStatusCode();
        return ret;
    }

    @Override
    public String closeReason() {
        String ret = this.delegate.closeReason();
        return ret;
    }

    @Override
    public MultiMap headers() {
        MultiMap ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    @Override
    public void end() {
        this.end((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable($handler -> this.end((Handler<AsyncResult<Void>>)$handler));
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    @Override
    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close((Handler<AsyncResult<Void>>)$handler));
    }

    @Override
    public void close(short statusCode, Handler<AsyncResult<Void>> handler) {
        this.delegate.close(statusCode, handler);
    }

    @Override
    public void close(short statusCode) {
        this.close(statusCode, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxClose(short statusCode) {
        return AsyncResultCompletable.toCompletable($handler -> this.close(statusCode, (Handler<AsyncResult<Void>>)$handler));
    }

    @Override
    public void close(short statusCode, String reason, Handler<AsyncResult<Void>> handler) {
        this.delegate.close(statusCode, reason, handler);
    }

    @Override
    public void close(short statusCode, String reason) {
        this.close(statusCode, reason, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxClose(short statusCode, String reason) {
        return AsyncResultCompletable.toCompletable($handler -> this.close(statusCode, reason, (Handler<AsyncResult<Void>>)$handler));
    }

    @Override
    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    @Override
    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    @Override
    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    @Override
    public boolean isClosed() {
        boolean ret = this.delegate.isClosed();
        return ret;
    }

    public void connect(int port, String host, String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.connect(port, host, requestURI, Helper.convertHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event))));
    }

    public void connect(int port, String host, String requestURI) {
        this.connect(port, host, requestURI, (Handler<AsyncResult<WebSocket>>)((Handler)ar -> {}));
    }

    public Single<WebSocket> rxConnect(int port, String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.connect(port, host, requestURI, (Handler<AsyncResult<WebSocket>>)$handler));
    }

    public void connect(WebSocketConnectOptions options, Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.connect(options, Helper.convertHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event))));
    }

    public void connect(WebSocketConnectOptions options) {
        this.connect(options, (Handler<AsyncResult<WebSocket>>)((Handler)ar -> {}));
    }

    public Single<WebSocket> rxConnect(WebSocketConnectOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.connect(options, (Handler<AsyncResult<WebSocket>>)$handler));
    }

    public void connect(String host, String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.connect(host, requestURI, Helper.convertHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event))));
    }

    public void connect(String host, String requestURI) {
        this.connect(host, requestURI, (Handler<AsyncResult<WebSocket>>)((Handler)ar -> {}));
    }

    public Single<WebSocket> rxConnect(String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.connect(host, requestURI, (Handler<AsyncResult<WebSocket>>)$handler));
    }

    public void connect(String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.connect(requestURI, Helper.convertHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event))));
    }

    public void connect(String requestURI) {
        this.connect(requestURI, (Handler<AsyncResult<WebSocket>>)((Handler)ar -> {}));
    }

    public Single<WebSocket> rxConnect(String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.connect(requestURI, (Handler<AsyncResult<WebSocket>>)$handler));
    }

    @Override
    public ClientWebSocket handler(Handler<io.vertx.reactivex.core.buffer.Buffer> handler) {
        this.delegate.handler(Helper.convertHandler(handler, event -> io.vertx.reactivex.core.buffer.Buffer.newInstance(event)));
        return this;
    }

    @Override
    public ClientWebSocket endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    @Override
    public ClientWebSocket drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    @Override
    public ClientWebSocket closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    @Override
    public ClientWebSocket frameHandler(Handler<WebSocketFrame> handler) {
        this.delegate.frameHandler(Helper.convertHandler(handler, event -> WebSocketFrame.newInstance(event)));
        return this;
    }

    @Override
    public ClientWebSocket textMessageHandler(Handler<String> handler) {
        this.delegate.textMessageHandler(handler);
        return this;
    }

    @Override
    public ClientWebSocket binaryMessageHandler(Handler<io.vertx.reactivex.core.buffer.Buffer> handler) {
        this.delegate.binaryMessageHandler(Helper.convertHandler(handler, event -> io.vertx.reactivex.core.buffer.Buffer.newInstance(event)));
        return this;
    }

    @Override
    public ClientWebSocket pongHandler(Handler<io.vertx.reactivex.core.buffer.Buffer> handler) {
        this.delegate.pongHandler(Helper.convertHandler(handler, event -> io.vertx.reactivex.core.buffer.Buffer.newInstance(event)));
        return this;
    }

    @Override
    public ClientWebSocket exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public ClientWebSocket writeFrame(WebSocketFrame frame, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFrame(frame.getDelegate(), handler);
        return this;
    }

    @Override
    public ClientWebSocket writeFrame(WebSocketFrame frame) {
        return this.writeFrame(frame, ar -> {});
    }

    @Override
    public Completable rxWriteFrame(WebSocketFrame frame) {
        return AsyncResultCompletable.toCompletable($handler -> this.writeFrame(frame, (Handler)$handler));
    }

    @Override
    public ClientWebSocket writeFinalTextFrame(String text, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFinalTextFrame(text, handler);
        return this;
    }

    @Override
    public ClientWebSocket writeFinalTextFrame(String text) {
        return this.writeFinalTextFrame(text, ar -> {});
    }

    @Override
    public Completable rxWriteFinalTextFrame(String text) {
        return AsyncResultCompletable.toCompletable($handler -> this.writeFinalTextFrame(text, (Handler)$handler));
    }

    @Override
    public ClientWebSocket writeFinalBinaryFrame(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeFinalBinaryFrame(data.getDelegate(), handler);
        return this;
    }

    @Override
    public ClientWebSocket writeFinalBinaryFrame(io.vertx.reactivex.core.buffer.Buffer data) {
        return this.writeFinalBinaryFrame(data, ar -> {});
    }

    @Override
    public Completable rxWriteFinalBinaryFrame(io.vertx.reactivex.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable($handler -> this.writeFinalBinaryFrame(data, (Handler)$handler));
    }

    @Override
    public ClientWebSocket writeBinaryMessage(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeBinaryMessage(data.getDelegate(), handler);
        return this;
    }

    @Override
    public ClientWebSocket writeBinaryMessage(io.vertx.reactivex.core.buffer.Buffer data) {
        return this.writeBinaryMessage(data, ar -> {});
    }

    @Override
    public Completable rxWriteBinaryMessage(io.vertx.reactivex.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable($handler -> this.writeBinaryMessage(data, (Handler)$handler));
    }

    @Override
    public ClientWebSocket writeTextMessage(String text, Handler<AsyncResult<Void>> handler) {
        this.delegate.writeTextMessage(text, handler);
        return this;
    }

    @Override
    public ClientWebSocket writeTextMessage(String text) {
        return this.writeTextMessage(text, ar -> {});
    }

    @Override
    public Completable rxWriteTextMessage(String text) {
        return AsyncResultCompletable.toCompletable($handler -> this.writeTextMessage(text, (Handler)$handler));
    }

    @Override
    public ClientWebSocket writePing(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.writePing(data.getDelegate(), handler);
        return this;
    }

    @Override
    public ClientWebSocket writePing(io.vertx.reactivex.core.buffer.Buffer data) {
        return this.writePing(data, ar -> {});
    }

    @Override
    public Completable rxWritePing(io.vertx.reactivex.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable($handler -> this.writePing(data, (Handler)$handler));
    }

    @Override
    public ClientWebSocket writePong(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.writePong(data.getDelegate(), handler);
        return this;
    }

    @Override
    public ClientWebSocket writePong(io.vertx.reactivex.core.buffer.Buffer data) {
        return this.writePong(data, ar -> {});
    }

    @Override
    public Completable rxWritePong(io.vertx.reactivex.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable($handler -> this.writePong(data, (Handler)$handler));
    }

    @Override
    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    public static ClientWebSocket newInstance(io.vertx.core.http.ClientWebSocket arg) {
        return arg != null ? new ClientWebSocket(arg) : null;
    }
}

