/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core;

import io.reactivex.Maybe;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.Promise;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import java.util.List;

@RxGen(value=io.vertx.core.Context.class)
public class Context {
    public static final TypeArg<Context> __TYPE_ARG = new TypeArg(obj -> new Context((io.vertx.core.Context)obj), Context::getDelegate);
    private final io.vertx.core.Context delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Context that = (Context)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Context(io.vertx.core.Context delegate) {
        this.delegate = delegate;
    }

    public Context(Object delegate) {
        this.delegate = (io.vertx.core.Context)delegate;
    }

    public io.vertx.core.Context getDelegate() {
        return this.delegate;
    }

    public static boolean isOnWorkerThread() {
        boolean ret = io.vertx.core.Context.isOnWorkerThread();
        return ret;
    }

    public static boolean isOnEventLoopThread() {
        boolean ret = io.vertx.core.Context.isOnEventLoopThread();
        return ret;
    }

    public static boolean isOnVertxThread() {
        boolean ret = io.vertx.core.Context.isOnVertxThread();
        return ret;
    }

    public void runOnContext(Handler<Void> action) {
        this.delegate.runOnContext(action);
    }

    public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> resultHandler) {
        this.delegate.executeBlocking((Handler)new DelegatingHandler(blockingCodeHandler, event -> Promise.newInstance(event, TypeArg.unknown())), ordered, resultHandler);
    }

    public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered) {
        this.executeBlocking(blockingCodeHandler, ordered, ar -> {});
    }

    public <T> Maybe<T> rxExecuteBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered) {
        return AsyncResultMaybe.toMaybe($handler -> this.executeBlocking(blockingCodeHandler, ordered, (Handler)$handler));
    }

    public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, Handler<AsyncResult<T>> resultHandler) {
        this.delegate.executeBlocking((Handler)new DelegatingHandler(blockingCodeHandler, event -> Promise.newInstance(event, TypeArg.unknown())), resultHandler);
    }

    public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler) {
        this.executeBlocking(blockingCodeHandler, ar -> {});
    }

    public <T> Maybe<T> rxExecuteBlocking(Handler<Promise<T>> blockingCodeHandler) {
        return AsyncResultMaybe.toMaybe($handler -> this.executeBlocking(blockingCodeHandler, (Handler)$handler));
    }

    public String deploymentID() {
        String ret = this.delegate.deploymentID();
        return ret;
    }

    public JsonObject config() {
        JsonObject ret = this.delegate.config();
        return ret;
    }

    public List<String> processArgs() {
        List ret = this.delegate.processArgs();
        return ret;
    }

    public boolean isEventLoopContext() {
        boolean ret = this.delegate.isEventLoopContext();
        return ret;
    }

    public boolean isWorkerContext() {
        boolean ret = this.delegate.isWorkerContext();
        return ret;
    }

    public <T> T get(Object key) {
        Object ret = this.delegate.get(key);
        return (T)ret;
    }

    public void put(Object key, Object value) {
        this.delegate.put(key, value);
    }

    public boolean remove(Object key) {
        boolean ret = this.delegate.remove(key);
        return ret;
    }

    public <T> T getLocal(Object key) {
        Object ret = this.delegate.getLocal(key);
        return (T)ret;
    }

    public void putLocal(Object key, Object value) {
        this.delegate.putLocal(key, value);
    }

    public boolean removeLocal(Object key) {
        boolean ret = this.delegate.removeLocal(key);
        return ret;
    }

    public Vertx owner() {
        Vertx ret = Vertx.newInstance(this.delegate.owner());
        return ret;
    }

    public int getInstanceCount() {
        int ret = this.delegate.getInstanceCount();
        return ret;
    }

    public Context exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public static Context newInstance(io.vertx.core.Context arg) {
        return arg != null ? new Context(arg) : null;
    }
}

