/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.mysqlclient;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.mysqlclient.MySQLAuthOptions;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLSetOption;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.sqlclient.PreparedStatement;
import io.vertx.reactivex.sqlclient.SqlConnection;

@RxGen(value=io.vertx.mysqlclient.MySQLConnection.class)
public class MySQLConnection
extends SqlConnection {
    public static final TypeArg<MySQLConnection> __TYPE_ARG = new TypeArg(obj -> new MySQLConnection((io.vertx.mysqlclient.MySQLConnection)obj), MySQLConnection::getDelegate);
    private final io.vertx.mysqlclient.MySQLConnection delegate;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MySQLConnection that = (MySQLConnection)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MySQLConnection(io.vertx.mysqlclient.MySQLConnection delegate) {
        super((io.vertx.sqlclient.SqlConnection)delegate);
        this.delegate = delegate;
    }

    public MySQLConnection(Object delegate) {
        super((io.vertx.sqlclient.SqlConnection)((io.vertx.mysqlclient.MySQLConnection)delegate));
        this.delegate = (io.vertx.mysqlclient.MySQLConnection)delegate;
    }

    public io.vertx.mysqlclient.MySQLConnection getDelegate() {
        return this.delegate;
    }

    public static void connect(io.vertx.reactivex.core.Vertx vertx, MySQLConnectOptions connectOptions, final Handler<AsyncResult<MySQLConnection>> handler) {
        io.vertx.mysqlclient.MySQLConnection.connect((Vertx)vertx.getDelegate(), (MySQLConnectOptions)connectOptions, (Handler)new Handler<AsyncResult<io.vertx.mysqlclient.MySQLConnection>>(){

            public void handle(AsyncResult<io.vertx.mysqlclient.MySQLConnection> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)MySQLConnection.newInstance((io.vertx.mysqlclient.MySQLConnection)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public static void connect(io.vertx.reactivex.core.Vertx vertx, MySQLConnectOptions connectOptions) {
        MySQLConnection.connect(vertx, connectOptions, (Handler<AsyncResult<MySQLConnection>>)((Handler)ar -> {}));
    }

    public static Single<MySQLConnection> rxConnect(io.vertx.reactivex.core.Vertx vertx, MySQLConnectOptions connectOptions) {
        return AsyncResultSingle.toSingle($handler -> MySQLConnection.connect(vertx, connectOptions, (Handler<AsyncResult<MySQLConnection>>)$handler));
    }

    public static void connect(io.vertx.reactivex.core.Vertx vertx, String connectionUri, final Handler<AsyncResult<MySQLConnection>> handler) {
        io.vertx.mysqlclient.MySQLConnection.connect((Vertx)vertx.getDelegate(), (String)connectionUri, (Handler)new Handler<AsyncResult<io.vertx.mysqlclient.MySQLConnection>>(){

            public void handle(AsyncResult<io.vertx.mysqlclient.MySQLConnection> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)MySQLConnection.newInstance((io.vertx.mysqlclient.MySQLConnection)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public static void connect(io.vertx.reactivex.core.Vertx vertx, String connectionUri) {
        MySQLConnection.connect(vertx, connectionUri, (Handler<AsyncResult<MySQLConnection>>)((Handler)ar -> {}));
    }

    public static Single<MySQLConnection> rxConnect(io.vertx.reactivex.core.Vertx vertx, String connectionUri) {
        return AsyncResultSingle.toSingle($handler -> MySQLConnection.connect(vertx, connectionUri, (Handler<AsyncResult<MySQLConnection>>)$handler));
    }

    @Override
    public MySQLConnection prepare(String sql, final Handler<AsyncResult<PreparedStatement>> handler) {
        this.delegate.prepare(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.PreparedStatement>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.PreparedStatement> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public MySQLConnection prepare(String sql) {
        return this.prepare(sql, ar -> {});
    }

    @Override
    public Single<PreparedStatement> rxPrepare(String sql) {
        return AsyncResultSingle.toSingle($handler -> this.prepare(sql, (Handler)$handler));
    }

    @Override
    public MySQLConnection exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public MySQLConnection closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public MySQLConnection ping(Handler<AsyncResult<Void>> handler) {
        this.delegate.ping(handler);
        return this;
    }

    public MySQLConnection ping() {
        return this.ping((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxPing() {
        return AsyncResultCompletable.toCompletable($handler -> this.ping((Handler<AsyncResult<Void>>)$handler));
    }

    public MySQLConnection specifySchema(String schemaName, Handler<AsyncResult<Void>> handler) {
        this.delegate.specifySchema(schemaName, handler);
        return this;
    }

    public MySQLConnection specifySchema(String schemaName) {
        return this.specifySchema(schemaName, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxSpecifySchema(String schemaName) {
        return AsyncResultCompletable.toCompletable($handler -> this.specifySchema(schemaName, (Handler<AsyncResult<Void>>)$handler));
    }

    public MySQLConnection getInternalStatistics(Handler<AsyncResult<String>> handler) {
        this.delegate.getInternalStatistics(handler);
        return this;
    }

    public MySQLConnection getInternalStatistics() {
        return this.getInternalStatistics((Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxGetInternalStatistics() {
        return AsyncResultSingle.toSingle($handler -> this.getInternalStatistics((Handler<AsyncResult<String>>)$handler));
    }

    public MySQLConnection setOption(MySQLSetOption option, Handler<AsyncResult<Void>> handler) {
        this.delegate.setOption(option, handler);
        return this;
    }

    public MySQLConnection setOption(MySQLSetOption option) {
        return this.setOption(option, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxSetOption(MySQLSetOption option) {
        return AsyncResultCompletable.toCompletable($handler -> this.setOption(option, (Handler<AsyncResult<Void>>)$handler));
    }

    public MySQLConnection resetConnection(Handler<AsyncResult<Void>> handler) {
        this.delegate.resetConnection(handler);
        return this;
    }

    public MySQLConnection resetConnection() {
        return this.resetConnection((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxResetConnection() {
        return AsyncResultCompletable.toCompletable($handler -> this.resetConnection((Handler<AsyncResult<Void>>)$handler));
    }

    public MySQLConnection debug(Handler<AsyncResult<Void>> handler) {
        this.delegate.debug(handler);
        return this;
    }

    public MySQLConnection debug() {
        return this.debug((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxDebug() {
        return AsyncResultCompletable.toCompletable($handler -> this.debug((Handler<AsyncResult<Void>>)$handler));
    }

    public MySQLConnection changeUser(MySQLAuthOptions options, Handler<AsyncResult<Void>> handler) {
        this.delegate.changeUser(options, handler);
        return this;
    }

    public MySQLConnection changeUser(MySQLAuthOptions options) {
        return this.changeUser(options, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxChangeUser(MySQLAuthOptions options) {
        return AsyncResultCompletable.toCompletable($handler -> this.changeUser(options, (Handler<AsyncResult<Void>>)$handler));
    }

    public static MySQLConnection cast(SqlConnection sqlConnection) {
        MySQLConnection ret = MySQLConnection.newInstance(io.vertx.mysqlclient.MySQLConnection.cast((io.vertx.sqlclient.SqlConnection)sqlConnection.getDelegate()));
        return ret;
    }

    public static MySQLConnection newInstance(io.vertx.mysqlclient.MySQLConnection arg) {
        return arg != null ? new MySQLConnection(arg) : null;
    }
}

