/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.servicediscovery.types;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.types.JDBCDataSource original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.servicediscovery.types.JDBCDataSource.class)
public class JDBCDataSource {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JDBCDataSource that = (JDBCDataSource) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<JDBCDataSource> __TYPE_ARG = new TypeArg<>(    obj -> new JDBCDataSource((io.vertx.servicediscovery.types.JDBCDataSource) obj),
    JDBCDataSource::getDelegate
  );

  private final io.vertx.servicediscovery.types.JDBCDataSource delegate;
  
  public JDBCDataSource(io.vertx.servicediscovery.types.JDBCDataSource delegate) {
    this.delegate = delegate;
  }

  public JDBCDataSource(Object delegate) {
    this.delegate = (io.vertx.servicediscovery.types.JDBCDataSource)delegate;
  }

  public io.vertx.servicediscovery.types.JDBCDataSource getDelegate() {
    return delegate;
  }

  public static io.vertx.servicediscovery.Record createRecord(java.lang.String name, io.vertx.core.json.JsonObject location, io.vertx.core.json.JsonObject metadata) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.JDBCDataSource.createRecord(name, location, metadata);
    return ret;
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.reactivex.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param resultHandler The result handler
   */
  public static void getJDBCClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, io.vertx.core.json.JsonObject filter, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.ext.jdbc.JDBCClient>> resultHandler) { 
    io.vertx.servicediscovery.types.JDBCDataSource.getJDBCClient(discovery.getDelegate(), filter, new Handler<AsyncResult<io.vertx.ext.jdbc.JDBCClient>>() {
      public void handle(AsyncResult<io.vertx.ext.jdbc.JDBCClient> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.jdbc.JDBCClient.newInstance((io.vertx.ext.jdbc.JDBCClient)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.reactivex.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   */
  public static void getJDBCClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, io.vertx.core.json.JsonObject filter) {
    getJDBCClient(discovery, filter, ar -> { });
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.reactivex.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @return 
   */
  public static io.reactivex.Single<io.vertx.reactivex.ext.jdbc.JDBCClient> rxGetJDBCClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, io.vertx.core.json.JsonObject filter) { 
    return AsyncResultSingle.toSingle($handler -> {
      getJDBCClient(discovery, filter, $handler);
    });
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.reactivex.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter (must not be <code>null</code>)
   * @param resultHandler The result handler
   */
  public static void getJDBCClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.ext.jdbc.JDBCClient>> resultHandler) { 
    io.vertx.servicediscovery.types.JDBCDataSource.getJDBCClient(discovery.getDelegate(), filter, new Handler<AsyncResult<io.vertx.ext.jdbc.JDBCClient>>() {
      public void handle(AsyncResult<io.vertx.ext.jdbc.JDBCClient> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.jdbc.JDBCClient.newInstance((io.vertx.ext.jdbc.JDBCClient)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.reactivex.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter (must not be <code>null</code>)
   */
  public static void getJDBCClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter) {
    getJDBCClient(discovery, filter, ar -> { });
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.reactivex.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter (must not be <code>null</code>)
   * @return 
   */
  public static io.reactivex.Single<io.vertx.reactivex.ext.jdbc.JDBCClient> rxGetJDBCClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter) { 
    return AsyncResultSingle.toSingle($handler -> {
      getJDBCClient(discovery, filter, $handler);
    });
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.reactivex.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param consumerConfiguration the consumer configuration
   * @param resultHandler the result handler
   */
  public static void getJDBCClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, io.vertx.core.json.JsonObject filter, io.vertx.core.json.JsonObject consumerConfiguration, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.ext.jdbc.JDBCClient>> resultHandler) { 
    io.vertx.servicediscovery.types.JDBCDataSource.getJDBCClient(discovery.getDelegate(), filter, consumerConfiguration, new Handler<AsyncResult<io.vertx.ext.jdbc.JDBCClient>>() {
      public void handle(AsyncResult<io.vertx.ext.jdbc.JDBCClient> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.jdbc.JDBCClient.newInstance((io.vertx.ext.jdbc.JDBCClient)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.reactivex.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param consumerConfiguration the consumer configuration
   */
  public static void getJDBCClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, io.vertx.core.json.JsonObject filter, io.vertx.core.json.JsonObject consumerConfiguration) {
    getJDBCClient(discovery, filter, consumerConfiguration, ar -> { });
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.reactivex.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param consumerConfiguration the consumer configuration
   * @return 
   */
  public static io.reactivex.Single<io.vertx.reactivex.ext.jdbc.JDBCClient> rxGetJDBCClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, io.vertx.core.json.JsonObject filter, io.vertx.core.json.JsonObject consumerConfiguration) { 
    return AsyncResultSingle.toSingle($handler -> {
      getJDBCClient(discovery, filter, consumerConfiguration, $handler);
    });
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.reactivex.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, must not be <code>null</code>
   * @param consumerConfiguration the consumer configuration
   * @param resultHandler the result handler
   */
  public static void getJDBCClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter, io.vertx.core.json.JsonObject consumerConfiguration, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.ext.jdbc.JDBCClient>> resultHandler) { 
    io.vertx.servicediscovery.types.JDBCDataSource.getJDBCClient(discovery.getDelegate(), filter, consumerConfiguration, new Handler<AsyncResult<io.vertx.ext.jdbc.JDBCClient>>() {
      public void handle(AsyncResult<io.vertx.ext.jdbc.JDBCClient> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.jdbc.JDBCClient.newInstance((io.vertx.ext.jdbc.JDBCClient)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.reactivex.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, must not be <code>null</code>
   * @param consumerConfiguration the consumer configuration
   */
  public static void getJDBCClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter, io.vertx.core.json.JsonObject consumerConfiguration) {
    getJDBCClient(discovery, filter, consumerConfiguration, ar -> { });
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.reactivex.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, must not be <code>null</code>
   * @param consumerConfiguration the consumer configuration
   * @return 
   */
  public static io.reactivex.Single<io.vertx.reactivex.ext.jdbc.JDBCClient> rxGetJDBCClient(io.vertx.reactivex.servicediscovery.ServiceDiscovery discovery, java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean> filter, io.vertx.core.json.JsonObject consumerConfiguration) { 
    return AsyncResultSingle.toSingle($handler -> {
      getJDBCClient(discovery, filter, consumerConfiguration, $handler);
    });
  }

  /**
   * Unknown type.
   */
  public static final java.lang.String UNKNOWN = io.vertx.servicediscovery.types.JDBCDataSource.UNKNOWN;
  public static final java.lang.String TYPE = io.vertx.servicediscovery.types.JDBCDataSource.TYPE;
  public static JDBCDataSource newInstance(io.vertx.servicediscovery.types.JDBCDataSource arg) {
    return arg != null ? new JDBCDataSource(arg) : null;
  }

}
