/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.json.schema;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Interface representing a <a href="https://json-schema.org/">Json Schema</a> <br/>
 * <p>
 * A schema could have two states: <br/>
 * <ul>
 *   <li>Synchronous: The validators tree can provide a synchronous validation, so you can validate your json both using  and </li>
 *   <li>Asynchronous: One or more branches of the validator tree requires an asynchronous validation, so you must use  to validate your json. If you use  it will throw a {@link io.vertx.json.schema.NoSyncValidationException}</li>
 * </ul>
 * <p>
 * To check the schema state you can use method . Note that invoking {@link io.vertx.reactivex.json.schema.Schema#validateAsync} generally doesn't have any additional overhead than invoking {@link io.vertx.reactivex.json.schema.Schema#validateSync}. <br/>
 * The schema can mutate the state in time, e.g. if you have a schema that is asynchronous because of a <code>$ref</code>,
 * after the first validation the external schema is cached inside {@link io.vertx.reactivex.json.schema.SchemaRouter} and this schema will switch to synchronous state<br/>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.json.schema.Schema original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.json.schema.Schema.class)
public class Schema {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Schema that = (Schema) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Schema> __TYPE_ARG = new TypeArg<>(    obj -> new Schema((io.vertx.json.schema.Schema) obj),
    Schema::getDelegate
  );

  private final io.vertx.json.schema.Schema delegate;
  
  public Schema(io.vertx.json.schema.Schema delegate) {
    this.delegate = delegate;
  }

  public Schema(Object delegate) {
    this.delegate = (io.vertx.json.schema.Schema)delegate;
  }

  public io.vertx.json.schema.Schema getDelegate() {
    return delegate;
  }


  /**
   * Validate the json performing an asynchronous validation.<br/>
   * <p>
   * Note: If the schema is synchronous, this method will call internally 
   * @param json input to validate
   * @return a failed future with {@link io.vertx.json.schema.ValidationException} if json doesn't match the schema, otherwise a succeeded future.
   */
  public io.vertx.core.Future<java.lang.Void> validateAsync(java.lang.Object json) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.validateAsync(json).map(val -> val);
    return ret;
  }

  /**
   * Validate the json performing a synchronous validation. Throws a {@link io.vertx.json.schema.ValidationException} if json doesn't match the schema.<br/>
   * @param json input to validate
   */
  public void validateSync(java.lang.Object json) { 
    delegate.validateSync(json);
  }

  /**
   * @return scope of this schema
   */
  public io.vertx.reactivex.core.json.pointer.JsonPointer getScope() { 
    io.vertx.reactivex.core.json.pointer.JsonPointer ret = io.vertx.reactivex.core.json.pointer.JsonPointer.newInstance((io.vertx.core.json.pointer.JsonPointer)delegate.getScope());
    return ret;
  }

  /**
   * @return Json representation of the schema
   */
  public java.lang.Object getJson() { 
    java.lang.Object ret = (Object) delegate.getJson();
    return ret;
  }

  /**
   * @return true if this validator can provide a synchronous validation.
   */
  public boolean isSync() { 
    boolean ret = delegate.isSync();
    return ret;
  }

  public static Schema newInstance(io.vertx.json.schema.Schema arg) {
    return arg != null ? new Schema(arg) : null;
  }

}
