/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.validation.builder;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * This interface is used to build complex parameter processors supported only in cookie & query. <br/>
 *
 * Look at {@link io.vertx.reactivex.ext.web.validation.builder.Parameters} for all available factories
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.validation.builder.StyledParameterProcessorFactory original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.validation.builder.StyledParameterProcessorFactory.class)
public class StyledParameterProcessorFactory {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StyledParameterProcessorFactory that = (StyledParameterProcessorFactory) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<StyledParameterProcessorFactory> __TYPE_ARG = new TypeArg<>(    obj -> new StyledParameterProcessorFactory((io.vertx.ext.web.validation.builder.StyledParameterProcessorFactory) obj),
    StyledParameterProcessorFactory::getDelegate
  );

  private final io.vertx.ext.web.validation.builder.StyledParameterProcessorFactory delegate;
  
  public StyledParameterProcessorFactory(io.vertx.ext.web.validation.builder.StyledParameterProcessorFactory delegate) {
    this.delegate = delegate;
  }

  public StyledParameterProcessorFactory(Object delegate) {
    this.delegate = (io.vertx.ext.web.validation.builder.StyledParameterProcessorFactory)delegate;
  }

  public io.vertx.ext.web.validation.builder.StyledParameterProcessorFactory getDelegate() {
    return delegate;
  }

  public io.vertx.ext.web.validation.impl.parameter.ParameterProcessor create(io.vertx.ext.web.validation.impl.ParameterLocation location, io.vertx.reactivex.json.schema.SchemaParser parser) { 
    io.vertx.ext.web.validation.impl.parameter.ParameterProcessor ret = delegate.create(location, parser.getDelegate());
    return ret;
  }

  public static StyledParameterProcessorFactory newInstance(io.vertx.ext.web.validation.builder.StyledParameterProcessorFactory arg) {
    return arg != null ? new StyledParameterProcessorFactory(arg) : null;
  }

}
