/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.sql;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a SQL query interface to a database
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.sql.SQLOperations original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.sql.SQLOperations.class)
public interface SQLOperations {

  io.vertx.ext.sql.SQLOperations getDelegate();

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param resultHandler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations query(java.lang.String sql, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.sql.ResultSet>> resultHandler);

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations query(java.lang.String sql);

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return 
   */
  public io.reactivex.Single<io.vertx.ext.sql.ResultSet> rxQuery(java.lang.String sql);

  /**
   * Executes the given SQL <code>SELECT</code> prepared statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @param resultHandler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations queryWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.sql.ResultSet>> resultHandler);

  /**
   * Executes the given SQL <code>SELECT</code> prepared statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations queryWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params);

  /**
   * Executes the given SQL <code>SELECT</code> prepared statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public io.reactivex.Single<io.vertx.ext.sql.ResultSet> rxQueryWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params);

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param handler the handler which is called once the operation completes. It will return a <code>SQLRowStream</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations queryStream(java.lang.String sql, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.ext.sql.SQLRowStream>> handler);

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations queryStream(java.lang.String sql);

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.sql.SQLRowStream> rxQueryStream(java.lang.String sql);

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @param handler the handler which is called once the operation completes. It will return a <code>SQLRowStream</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations queryStreamWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.ext.sql.SQLRowStream>> handler);

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations queryStreamWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params);

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.sql.SQLRowStream> rxQueryStreamWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params);

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @param handler the result handler
   * @return self
   */
  public io.vertx.reactivex.ext.sql.SQLOperations querySingle(java.lang.String sql, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonArray>> handler);

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @return self
   */
  public io.vertx.reactivex.ext.sql.SQLOperations querySingle(java.lang.String sql);

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @return self
   */
  public io.reactivex.Maybe<io.vertx.core.json.JsonArray> rxQuerySingle(java.lang.String sql);

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @param handler the result handler
   * @return self
   */
  public io.vertx.reactivex.ext.sql.SQLOperations querySingleWithParams(java.lang.String sql, io.vertx.core.json.JsonArray arguments, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonArray>> handler);

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return self
   */
  public io.vertx.reactivex.ext.sql.SQLOperations querySingleWithParams(java.lang.String sql, io.vertx.core.json.JsonArray arguments);

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return self
   */
  public io.reactivex.Maybe<io.vertx.core.json.JsonArray> rxQuerySingleWithParams(java.lang.String sql, io.vertx.core.json.JsonArray arguments);

  /**
   * Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param resultHandler the handler which is called once the operation completes.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations update(java.lang.String sql, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.sql.UpdateResult>> resultHandler);

  /**
   * Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations update(java.lang.String sql);

  /**
   * Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @return 
   */
  public io.reactivex.Single<io.vertx.ext.sql.UpdateResult> rxUpdate(java.lang.String sql);

  /**
   * Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement with the given parameters
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @param resultHandler the handler which is called once the operation completes.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations updateWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.sql.UpdateResult>> resultHandler);

  /**
   * Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement with the given parameters
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations updateWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params);

  /**
   * Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement with the given parameters
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public io.reactivex.Single<io.vertx.ext.sql.UpdateResult> rxUpdateWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params);

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @param resultHandler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations call(java.lang.String sql, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.sql.ResultSet>> resultHandler);

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations call(java.lang.String sql);

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @return 
   */
  public io.reactivex.Single<io.vertx.ext.sql.ResultSet> rxCall(java.lang.String sql);

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   *
   * The index of params and outputs are important for both arrays, for example when dealing with a prodecure that
   * takes the first 2 arguments as input values and the 3 arg as an output then the arrays should be like:
   *
   * <pre>
   *   params = [VALUE1, VALUE2, null]
   *   outputs = [null, null, "VARCHAR"]
   * </pre>
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @param resultHandler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations callWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params, io.vertx.core.json.JsonArray outputs, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.sql.ResultSet>> resultHandler);

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   *
   * The index of params and outputs are important for both arrays, for example when dealing with a prodecure that
   * takes the first 2 arguments as input values and the 3 arg as an output then the arrays should be like:
   *
   * <pre>
   *   params = [VALUE1, VALUE2, null]
   *   outputs = [null, null, "VARCHAR"]
   * </pre>
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations callWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params, io.vertx.core.json.JsonArray outputs);

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   *
   * The index of params and outputs are important for both arrays, for example when dealing with a prodecure that
   * takes the first 2 arguments as input values and the 3 arg as an output then the arrays should be like:
   *
   * <pre>
   *   params = [VALUE1, VALUE2, null]
   *   outputs = [null, null, "VARCHAR"]
   * </pre>
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @return 
   */
  public io.reactivex.Single<io.vertx.ext.sql.ResultSet> rxCallWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params, io.vertx.core.json.JsonArray outputs);

  public static SQLOperations newInstance(io.vertx.ext.sql.SQLOperations arg) {
    return arg != null ? new SQLOperationsImpl(arg) : null;
  }

}

class SQLOperationsImpl implements SQLOperations {
  private final io.vertx.ext.sql.SQLOperations delegate;
  
  public SQLOperationsImpl(io.vertx.ext.sql.SQLOperations delegate) {
    this.delegate = delegate;
  }

  public SQLOperationsImpl(Object delegate) {
    this.delegate = (io.vertx.ext.sql.SQLOperations)delegate;
  }

  public io.vertx.ext.sql.SQLOperations getDelegate() {
    return delegate;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param resultHandler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations query(java.lang.String sql, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.sql.ResultSet>> resultHandler) { 
    delegate.query(sql, resultHandler);
    return this;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations query(java.lang.String sql) {
    return 
query(sql, ar -> { });
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return 
   */
  public io.reactivex.Single<io.vertx.ext.sql.ResultSet> rxQuery(java.lang.String sql) { 
    return AsyncResultSingle.toSingle($handler -> {
      query(sql, $handler);
    });
  }

  /**
   * Executes the given SQL <code>SELECT</code> prepared statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @param resultHandler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations queryWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.sql.ResultSet>> resultHandler) { 
    delegate.queryWithParams(sql, params, resultHandler);
    return this;
  }

  /**
   * Executes the given SQL <code>SELECT</code> prepared statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations queryWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params) {
    return 
queryWithParams(sql, params, ar -> { });
  }

  /**
   * Executes the given SQL <code>SELECT</code> prepared statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public io.reactivex.Single<io.vertx.ext.sql.ResultSet> rxQueryWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params) { 
    return AsyncResultSingle.toSingle($handler -> {
      queryWithParams(sql, params, $handler);
    });
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param handler the handler which is called once the operation completes. It will return a <code>SQLRowStream</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations queryStream(java.lang.String sql, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.ext.sql.SQLRowStream>> handler) { 
    delegate.queryStream(sql, new Handler<AsyncResult<io.vertx.ext.sql.SQLRowStream>>() {
      public void handle(AsyncResult<io.vertx.ext.sql.SQLRowStream> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.sql.SQLRowStream.newInstance((io.vertx.ext.sql.SQLRowStream)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations queryStream(java.lang.String sql) {
    return 
queryStream(sql, ar -> { });
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.sql.SQLRowStream> rxQueryStream(java.lang.String sql) { 
    return AsyncResultSingle.toSingle($handler -> {
      queryStream(sql, $handler);
    });
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @param handler the handler which is called once the operation completes. It will return a <code>SQLRowStream</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations queryStreamWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.ext.sql.SQLRowStream>> handler) { 
    delegate.queryStreamWithParams(sql, params, new Handler<AsyncResult<io.vertx.ext.sql.SQLRowStream>>() {
      public void handle(AsyncResult<io.vertx.ext.sql.SQLRowStream> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.ext.sql.SQLRowStream.newInstance((io.vertx.ext.sql.SQLRowStream)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations queryStreamWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params) {
    return 
queryStreamWithParams(sql, params, ar -> { });
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.sql.SQLRowStream> rxQueryStreamWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params) { 
    return AsyncResultSingle.toSingle($handler -> {
      queryStreamWithParams(sql, params, $handler);
    });
  }

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @param handler the result handler
   * @return self
   */
  public io.vertx.reactivex.ext.sql.SQLOperations querySingle(java.lang.String sql, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonArray>> handler) { 
    delegate.querySingle(sql, handler);
    return this;
  }

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @return self
   */
  public io.vertx.reactivex.ext.sql.SQLOperations querySingle(java.lang.String sql) {
    return 
querySingle(sql, ar -> { });
  }

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @return self
   */
  public io.reactivex.Maybe<io.vertx.core.json.JsonArray> rxQuerySingle(java.lang.String sql) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      querySingle(sql, $handler);
    });
  }

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @param handler the result handler
   * @return self
   */
  public io.vertx.reactivex.ext.sql.SQLOperations querySingleWithParams(java.lang.String sql, io.vertx.core.json.JsonArray arguments, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.core.json.JsonArray>> handler) { 
    delegate.querySingleWithParams(sql, arguments, handler);
    return this;
  }

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return self
   */
  public io.vertx.reactivex.ext.sql.SQLOperations querySingleWithParams(java.lang.String sql, io.vertx.core.json.JsonArray arguments) {
    return 
querySingleWithParams(sql, arguments, ar -> { });
  }

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return self
   */
  public io.reactivex.Maybe<io.vertx.core.json.JsonArray> rxQuerySingleWithParams(java.lang.String sql, io.vertx.core.json.JsonArray arguments) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      querySingleWithParams(sql, arguments, $handler);
    });
  }

  /**
   * Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param resultHandler the handler which is called once the operation completes.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations update(java.lang.String sql, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.sql.UpdateResult>> resultHandler) { 
    delegate.update(sql, resultHandler);
    return this;
  }

  /**
   * Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations update(java.lang.String sql) {
    return 
update(sql, ar -> { });
  }

  /**
   * Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @return 
   */
  public io.reactivex.Single<io.vertx.ext.sql.UpdateResult> rxUpdate(java.lang.String sql) { 
    return AsyncResultSingle.toSingle($handler -> {
      update(sql, $handler);
    });
  }

  /**
   * Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement with the given parameters
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @param resultHandler the handler which is called once the operation completes.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations updateWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.sql.UpdateResult>> resultHandler) { 
    delegate.updateWithParams(sql, params, resultHandler);
    return this;
  }

  /**
   * Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement with the given parameters
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations updateWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params) {
    return 
updateWithParams(sql, params, ar -> { });
  }

  /**
   * Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement with the given parameters
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public io.reactivex.Single<io.vertx.ext.sql.UpdateResult> rxUpdateWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params) { 
    return AsyncResultSingle.toSingle($handler -> {
      updateWithParams(sql, params, $handler);
    });
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @param resultHandler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations call(java.lang.String sql, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.sql.ResultSet>> resultHandler) { 
    delegate.call(sql, resultHandler);
    return this;
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations call(java.lang.String sql) {
    return 
call(sql, ar -> { });
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @return 
   */
  public io.reactivex.Single<io.vertx.ext.sql.ResultSet> rxCall(java.lang.String sql) { 
    return AsyncResultSingle.toSingle($handler -> {
      call(sql, $handler);
    });
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   *
   * The index of params and outputs are important for both arrays, for example when dealing with a prodecure that
   * takes the first 2 arguments as input values and the 3 arg as an output then the arrays should be like:
   *
   * <pre>
   *   params = [VALUE1, VALUE2, null]
   *   outputs = [null, null, "VARCHAR"]
   * </pre>
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @param resultHandler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations callWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params, io.vertx.core.json.JsonArray outputs, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.ext.sql.ResultSet>> resultHandler) { 
    delegate.callWithParams(sql, params, outputs, resultHandler);
    return this;
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   *
   * The index of params and outputs are important for both arrays, for example when dealing with a prodecure that
   * takes the first 2 arguments as input values and the 3 arg as an output then the arrays should be like:
   *
   * <pre>
   *   params = [VALUE1, VALUE2, null]
   *   outputs = [null, null, "VARCHAR"]
   * </pre>
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLOperations callWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params, io.vertx.core.json.JsonArray outputs) {
    return 
callWithParams(sql, params, outputs, ar -> { });
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   *
   * The index of params and outputs are important for both arrays, for example when dealing with a prodecure that
   * takes the first 2 arguments as input values and the 3 arg as an output then the arrays should be like:
   *
   * <pre>
   *   params = [VALUE1, VALUE2, null]
   *   outputs = [null, null, "VARCHAR"]
   * </pre>
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @return 
   */
  public io.reactivex.Single<io.vertx.ext.sql.ResultSet> rxCallWithParams(java.lang.String sql, io.vertx.core.json.JsonArray params, io.vertx.core.json.JsonArray outputs) { 
    return AsyncResultSingle.toSingle($handler -> {
      callWithParams(sql, params, outputs, $handler);
    });
  }

}
