/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents an authenticates User and contains operations to authorise the user.
 * <p>
 * Please consult the documentation for a detailed explanation.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.User original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.User.class)
public class User {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    User that = (User) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<User> __TYPE_ARG = new TypeArg<>(    obj -> new User((io.vertx.ext.auth.User) obj),
    User::getDelegate
  );

  private final io.vertx.ext.auth.User delegate;
  
  public User(io.vertx.ext.auth.User delegate) {
    this.delegate = delegate;
  }

  public User(Object delegate) {
    this.delegate = (io.vertx.ext.auth.User)delegate;
  }

  public io.vertx.ext.auth.User getDelegate() {
    return delegate;
  }

  /**
   * Factory for user instances that are single string. The credentials will be added to the principal
   * of this instance. As nothing can be said about the credentials no validation will be done.
   *
   * Will create a principal with a property <code>"username"</code> with the name as value.
   * @param username the value for this user
   * @return user instance
   */
  public static io.vertx.reactivex.ext.auth.User fromName(java.lang.String username) { 
    io.vertx.reactivex.ext.auth.User ret = io.vertx.reactivex.ext.auth.User.newInstance((io.vertx.ext.auth.User)io.vertx.ext.auth.User.fromName(username));
    return ret;
  }

  /**
   * Factory for user instances that are single string. The credentials will be added to the principal
   * of this instance. As nothing can be said about the credentials no validation will be done.
   *
   * Will create a principal with a property <code>"access_token"</code> with the name as value.
   * @param token the value for this user
   * @return user instance
   */
  public static io.vertx.reactivex.ext.auth.User fromToken(java.lang.String token) { 
    io.vertx.reactivex.ext.auth.User ret = io.vertx.reactivex.ext.auth.User.newInstance((io.vertx.ext.auth.User)io.vertx.ext.auth.User.fromToken(token));
    return ret;
  }

  /**
   * Factory for user instances that are free form. The credentials will be added to the principal
   * of this instance. As nothing can be said about the credentials no validation will be done.
   * @param principal the free form json principal
   * @return user instance
   */
  public static io.vertx.reactivex.ext.auth.User create(io.vertx.core.json.JsonObject principal) { 
    io.vertx.reactivex.ext.auth.User ret = io.vertx.reactivex.ext.auth.User.newInstance((io.vertx.ext.auth.User)io.vertx.ext.auth.User.create(principal));
    return ret;
  }

  /**
   * Factory for user instances that are free form. The credentials will be added to the principal
   * of this instance. As nothing can be said about the credentials no validation will be done.
   * @param principal the free form json principal
   * @param attributes the free form json attributes that further describe the principal
   * @return user instance
   */
  public static io.vertx.reactivex.ext.auth.User create(io.vertx.core.json.JsonObject principal, io.vertx.core.json.JsonObject attributes) { 
    io.vertx.reactivex.ext.auth.User ret = io.vertx.reactivex.ext.auth.User.newInstance((io.vertx.ext.auth.User)io.vertx.ext.auth.User.create(principal, attributes));
    return ret;
  }

  /**
   * Gets extra attributes of the user. Attributes contains any attributes related
   * to the outcome of authenticating a user (e.g.: issued date, metadata, etc...)
   * @return a json object with any relevant attribute.
   */
  public io.vertx.core.json.JsonObject attributes() { 
    io.vertx.core.json.JsonObject ret = delegate.attributes();
    return ret;
  }

  /**
   * Flags this user object to be expired. A User is considered expired if it contains an expiration time and
   * the current clock time is post the expiration date.
   * @return <code>true</code> if expired
   */
  public boolean expired() { 
    boolean ret = delegate.expired();
    return ret;
  }

  /**
   * Flags this user object to be expired. Expiration takes 3 values in account:
   *
   * <ol>
   *   <li><code>exp</code> "expiration" timestamp in seconds.</li>
   *   <li><code>iat</code> "issued at" in seconds.</li>
   *   <li><code>nbf</code> "not before" in seconds.</li>
   * </ol>
   * A User is considered expired if it contains any of the above and
   * the current clock time does not agree with the parameter value. If the {@link io.vertx.reactivex.ext.auth.User#attributes} do not contain a key
   * then {@link io.vertx.reactivex.ext.auth.User#principal} properties are checked.
   * <p>
   * If all of the properties are not available the user will not expire.
   * <p>
   * Implementations of this interface might relax this rule to account for a leeway to safeguard against
   * clock drifting.
   * @param leeway a greater than zero leeway value.
   * @return <code>true</code> if expired
   */
  public boolean expired(int leeway) { 
    boolean ret = delegate.expired(leeway);
    return ret;
  }

  /**
   * Get a value from the user object. This method will perform lookups on several places before returning a value.
   * <ol>
   *   <li>If there is a <code>rootClaim</code> the look up will happen in the <code>attributes[rootClaim]</code></li>
   *   <li>If exists the value will be returned from the {@link io.vertx.reactivex.ext.auth.User#attributes}</li>
   *   <li>If exists the value will be returned from the {@link io.vertx.reactivex.ext.auth.User#principal}</li>
   *   <li>Otherwise it will be <code>null</code></li>
   * </ol>
   * @param key the key to look up
   * @return the value or null if missing
   */
  public <T> T get(java.lang.String key) { 
    T ret = (T) delegate.get(key);
    return ret;
  }

  /**
   * Checks if a value exists on the user object. This method will perform lookups on several places before returning.
   * <ol>
   *   <li>If there is a <code>rootClaim</code> the look up will happen in the <code>attributes[rootClaim]</code></li>
   *   <li>If exists the value will be returned from the {@link io.vertx.reactivex.ext.auth.User#attributes}</li>
   *   <li>If exists the value will be returned from the {@link io.vertx.reactivex.ext.auth.User#principal}</li>
   *   <li>Otherwise it will be <code>null</code></li>
   * </ol>
   * @param key the key to look up
   * @return the value or null if missing
   */
  public boolean containsKey(java.lang.String key) { 
    boolean ret = delegate.containsKey(key);
    return ret;
  }

  /**
   * Returns user's authorizations that have been previously loaded by the providers.
   * @return authorizations holder for the user.
   */
  public io.vertx.reactivex.ext.auth.authorization.Authorizations authorizations() { 
    io.vertx.reactivex.ext.auth.authorization.Authorizations ret = io.vertx.reactivex.ext.auth.authorization.Authorizations.newInstance((io.vertx.ext.auth.authorization.Authorizations)delegate.authorizations());
    return ret;
  }

  /**
   * Is the user authorised to
   * @param authority the authority - what this really means is determined by the specific implementation. It might represent a permission to access a resource e.g. `printers:printer34` or it might represent authority to a role in a roles based model, e.g. `role:admin`.
   * @param resultHandler handler that will be called with an {@link io.vertx.core.AsyncResult} containing the value `true` if the they has the authority or `false` otherwise.
   * @return the User to enable fluent use
   */
  @Deprecated()
  public io.vertx.reactivex.ext.auth.User isAuthorized(io.vertx.reactivex.ext.auth.authorization.Authorization authority, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Boolean>> resultHandler) { 
    delegate.isAuthorized(authority.getDelegate(), resultHandler);
    return this;
  }

  /**
   * Is the user authorised to
   * @param authority the authority - what this really means is determined by the specific implementation. It might represent a permission to access a resource e.g. `printers:printer34` or it might represent authority to a role in a roles based model, e.g. `role:admin`.
   * @return the User to enable fluent use
   */
  @Deprecated()
  public io.vertx.reactivex.ext.auth.User isAuthorized(io.vertx.reactivex.ext.auth.authorization.Authorization authority) {
    return 
isAuthorized(authority, ar -> { });
  }

  /**
   * Is the user authorised to
   * @param authority the authority - what this really means is determined by the specific implementation. It might represent a permission to access a resource e.g. `printers:printer34` or it might represent authority to a role in a roles based model, e.g. `role:admin`.
   * @return the User to enable fluent use
   */
  @Deprecated()
  public io.reactivex.Single<java.lang.Boolean> rxIsAuthorized(io.vertx.reactivex.ext.auth.authorization.Authorization authority) { 
    return AsyncResultSingle.toSingle($handler -> {
      isAuthorized(authority, $handler);
    });
  }

  /**
   * Is the user authorised to
   * @param authority the authority - what this really means is determined by the specific implementation. It might represent a permission to access a resource e.g. `printers:printer34` or it might represent authority to a role in a roles based model, e.g. `role:admin`.
   * @param resultHandler handler that will be called with an {@link io.vertx.core.AsyncResult} containing the value `true` if the they has the authority or `false` otherwise.
   * @return the User to enable fluent use
   */
  @Deprecated()
  public io.vertx.reactivex.ext.auth.User isAuthorized(java.lang.String authority, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Boolean>> resultHandler) { 
    delegate.isAuthorized(authority, resultHandler);
    return this;
  }

  /**
   * Is the user authorised to
   * @param authority the authority - what this really means is determined by the specific implementation. It might represent a permission to access a resource e.g. `printers:printer34` or it might represent authority to a role in a roles based model, e.g. `role:admin`.
   * @return the User to enable fluent use
   */
  @Deprecated()
  public io.vertx.reactivex.ext.auth.User isAuthorized(java.lang.String authority) {
    return 
isAuthorized(authority, ar -> { });
  }

  /**
   * Is the user authorised to
   * @param authority the authority - what this really means is determined by the specific implementation. It might represent a permission to access a resource e.g. `printers:printer34` or it might represent authority to a role in a roles based model, e.g. `role:admin`.
   * @return the User to enable fluent use
   */
  @Deprecated()
  public io.reactivex.Single<java.lang.Boolean> rxIsAuthorized(java.lang.String authority) { 
    return AsyncResultSingle.toSingle($handler -> {
      isAuthorized(authority, $handler);
    });
  }

  /**
   * The User object will cache any authorities that it knows it has to avoid hitting the
   * underlying auth provider each time.  Use this method if you want to clear this cache.
   * @return the User to enable fluent use
   */
  @Deprecated()
  public io.vertx.reactivex.ext.auth.User clearCache() { 
    delegate.clearCache();
    return this;
  }

  /**
   * Get the underlying principal for the User. What this actually returns depends on the implementation.
   * For a simple user/password based auth, it's likely to contain a JSON object with the following structure:
   * <pre>
   *   {
   *     "username", "tim"
   *   }
   * </pre>
   * @return JSON representation of the Principal
   */
  public io.vertx.core.json.JsonObject principal() { 
    io.vertx.core.json.JsonObject ret = delegate.principal();
    return ret;
  }

  /**
   * Set the auth provider for the User. This is typically used to reattach a detached User with an AuthProvider, e.g.
   * after it has been deserialized.
   * @param authProvider the AuthProvider - this must be the same type of AuthProvider that originally created the User
   */
  @Deprecated()
  public void setAuthProvider(io.vertx.reactivex.ext.auth.AuthProvider authProvider) { 
    delegate.setAuthProvider(authProvider.getDelegate());
  }

  /**
   * Merge the principal and attributes of a second user into this object properties.
   *
   * It is important to notice that the principal merges by replacing existing keys with the new values, while the
   * attributes (as they represent decoded data) are accumulated at the root level.
   *
   * This means that given:
   *
   * <pre><code>userA = {
   attributes: {
     roles: [ 'read' ]</code>
   * }
   *
   * userB = {
   *   attributes: {
   *     roles: [ 'write' ]
   *   }
   * }
   * }</pre>
   *
   * When performing a merge of <code>userA</code> with <code>userB</code>, you will get:
   *
   * <pre><code>userA.merge(userB);
 // results in
 {
   attributes: {
     roles: [ 'read', 'write' ]</code>
   * }
   * }</pre>
   * @param other the other user to merge
   * @return fluent self
   */
  public io.vertx.reactivex.ext.auth.User merge(io.vertx.reactivex.ext.auth.User other) { 
    delegate.merge(other.getDelegate());
    return this;
  }

  public static User newInstance(io.vertx.ext.auth.User arg) {
    return arg != null ? new User(arg) : null;
  }

}
