/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.http;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An HTTP/2 frame.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpFrame original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.http.HttpFrame.class)
public class HttpFrame {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpFrame that = (HttpFrame) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HttpFrame> __TYPE_ARG = new TypeArg<>(    obj -> new HttpFrame((io.vertx.core.http.HttpFrame) obj),
    HttpFrame::getDelegate
  );

  private final io.vertx.core.http.HttpFrame delegate;
  
  public HttpFrame(io.vertx.core.http.HttpFrame delegate) {
    this.delegate = delegate;
  }

  public HttpFrame(Object delegate) {
    this.delegate = (io.vertx.core.http.HttpFrame)delegate;
  }

  public io.vertx.core.http.HttpFrame getDelegate() {
    return delegate;
  }

  /**
   * @return the 8-bit type of the frame
   */
  public int type() { 
    if (cached_0 != null) {
      return cached_0;
    }
    int ret = delegate.type();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the 8-bit flags specific to the frame
   */
  public int flags() { 
    if (cached_1 != null) {
      return cached_1;
    }
    int ret = delegate.flags();
    cached_1 = ret;
    return ret;
  }

  /**
   * @return the frame payload
   */
  public io.vertx.reactivex.core.buffer.Buffer payload() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.vertx.reactivex.core.buffer.Buffer ret = io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.payload());
    cached_2 = ret;
    return ret;
  }

  private java.lang.Integer cached_0;
  private java.lang.Integer cached_1;
  private io.vertx.reactivex.core.buffer.Buffer cached_2;
  public static HttpFrame newInstance(io.vertx.core.http.HttpFrame arg) {
    return arg != null ? new HttpFrame(arg) : null;
  }

}
