/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.web;

import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.SingleHelper;
import io.vertx.reactivex.ext.web.Router;
import io.vertx.reactivex.ext.web.RoutingContext;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

@RxGen(value=io.vertx.ext.web.Route.class)
public class Route {
    public static final TypeArg<Route> __TYPE_ARG = new TypeArg(obj -> new Route((io.vertx.ext.web.Route)obj), Route::getDelegate);
    private final io.vertx.ext.web.Route delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Route that = (Route)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Route(io.vertx.ext.web.Route delegate) {
        this.delegate = delegate;
    }

    public Route(Object delegate) {
        this.delegate = (io.vertx.ext.web.Route)delegate;
    }

    public io.vertx.ext.web.Route getDelegate() {
        return this.delegate;
    }

    public Route method(HttpMethod method) {
        this.delegate.method(method);
        return this;
    }

    public Route path(String path) {
        this.delegate.path(path);
        return this;
    }

    public Route pathRegex(String path) {
        this.delegate.pathRegex(path);
        return this;
    }

    public Route produces(String contentType) {
        this.delegate.produces(contentType);
        return this;
    }

    public Route consumes(String contentType) {
        this.delegate.consumes(contentType);
        return this;
    }

    public Route virtualHost(String hostnamePattern) {
        this.delegate.virtualHost(hostnamePattern);
        return this;
    }

    public Route order(int order) {
        this.delegate.order(order);
        return this;
    }

    public Route last() {
        this.delegate.last();
        return this;
    }

    public Route handler(final Handler<RoutingContext> requestHandler) {
        this.delegate.handler((Handler)new Handler<io.vertx.ext.web.RoutingContext>(){

            public void handle(io.vertx.ext.web.RoutingContext event) {
                requestHandler.handle((Object)RoutingContext.newInstance(event));
            }
        });
        return this;
    }

    public Route blockingHandler(final Handler<RoutingContext> requestHandler) {
        this.delegate.blockingHandler((Handler)new Handler<io.vertx.ext.web.RoutingContext>(){

            public void handle(io.vertx.ext.web.RoutingContext event) {
                requestHandler.handle((Object)RoutingContext.newInstance(event));
            }
        });
        return this;
    }

    public Route subRouter(Router subRouter) {
        this.delegate.subRouter(subRouter.getDelegate());
        return this;
    }

    public Route blockingHandler(final Handler<RoutingContext> requestHandler, boolean ordered) {
        this.delegate.blockingHandler((Handler)new Handler<io.vertx.ext.web.RoutingContext>(){

            public void handle(io.vertx.ext.web.RoutingContext event) {
                requestHandler.handle((Object)RoutingContext.newInstance(event));
            }
        }, ordered);
        return this;
    }

    public Route failureHandler(final Handler<RoutingContext> failureHandler) {
        this.delegate.failureHandler((Handler)new Handler<io.vertx.ext.web.RoutingContext>(){

            public void handle(io.vertx.ext.web.RoutingContext event) {
                failureHandler.handle((Object)RoutingContext.newInstance(event));
            }
        });
        return this;
    }

    public Route remove() {
        this.delegate.remove();
        return this;
    }

    public Route disable() {
        this.delegate.disable();
        return this;
    }

    public Route enable() {
        this.delegate.enable();
        return this;
    }

    @Deprecated
    public Route useNormalisedPath(boolean useNormalizedPath) {
        this.delegate.useNormalisedPath(useNormalizedPath);
        return this;
    }

    public Route useNormalizedPath(boolean useNormalizedPath) {
        this.delegate.useNormalizedPath(useNormalizedPath);
        return this;
    }

    public String getPath() {
        String ret = this.delegate.getPath();
        return ret;
    }

    public boolean isRegexPath() {
        boolean ret = this.delegate.isRegexPath();
        return ret;
    }

    public Set<HttpMethod> methods() {
        Set ret = this.delegate.methods();
        return ret;
    }

    public Route setRegexGroupsNames(List<String> groups) {
        this.delegate.setRegexGroupsNames(groups);
        return this;
    }

    public Route setName(String name) {
        this.delegate.setName(name);
        return this;
    }

    public String getName() {
        String ret = this.delegate.getName();
        return ret;
    }

    public <T> Route respond(final Function<RoutingContext, io.vertx.reactivex.core.Future<T>> function) {
        this.delegate.respond(new Function<io.vertx.ext.web.RoutingContext, Future<T>>(){

            @Override
            public Future<T> apply(io.vertx.ext.web.RoutingContext arg) {
                io.vertx.reactivex.core.Future ret = (io.vertx.reactivex.core.Future)function.apply(RoutingContext.newInstance(arg));
                return ret.getDelegate();
            }
        });
        return this;
    }

    public <T> Route respond(final io.reactivex.functions.Function<RoutingContext, Single<T>> function) {
        this.delegate.respond(new Function<io.vertx.ext.web.RoutingContext, Future<T>>(){

            @Override
            public Future<T> apply(io.vertx.ext.web.RoutingContext arg) {
                Single ret;
                try {
                    ret = (Single)function.apply((Object)RoutingContext.newInstance(arg));
                }
                catch (Exception e) {
                    return Future.failedFuture((Throwable)e);
                }
                return SingleHelper.toFuture((Single)ret, obj -> obj);
            }
        });
        return this;
    }

    public static Route newInstance(io.vertx.ext.web.Route arg) {
        return arg != null ? new Route(arg) : null;
    }
}

