/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.http;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.Future;
import io.vertx.reactivex.core.MultiMap;
import io.vertx.reactivex.core.buffer.Buffer;
import io.vertx.reactivex.core.http.HttpClientRequest;
import io.vertx.reactivex.core.http.HttpClientResponse;
import io.vertx.reactivex.core.http.HttpConnection;
import io.vertx.reactivex.core.http.WebSocket;
import io.vertx.reactivex.core.metrics.Measured;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.ReadStreamSubscriber;
import java.util.List;
import java.util.function.Function;

@RxGen(value=io.vertx.core.http.HttpClient.class)
public class HttpClient
implements Measured {
    public static final TypeArg<HttpClient> __TYPE_ARG = new TypeArg(obj -> new HttpClient((io.vertx.core.http.HttpClient)obj), HttpClient::getDelegate);
    private final io.vertx.core.http.HttpClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClient that = (HttpClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpClient(io.vertx.core.http.HttpClient delegate) {
        this.delegate = delegate;
    }

    public HttpClient(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpClient)delegate;
    }

    public io.vertx.core.http.HttpClient getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public void send(RequestOptions options, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(options, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(RequestOptions options) {
        this.send(options, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(RequestOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.send(options, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(RequestOptions options, Buffer body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(options, body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(RequestOptions options, Buffer body) {
        this.send(options, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(RequestOptions options, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.send(options, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(RequestOptions options, ReadStream<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(options, body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(RequestOptions options, ReadStream<Buffer> body) {
        this.send(options, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(RequestOptions options, ReadStream<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.send(options, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(RequestOptions options, Flowable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(options, ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(RequestOptions options, Flowable<Buffer> body) {
        this.send(options, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(RequestOptions options, Flowable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.send(options, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(RequestOptions options, Observable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(options, ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(RequestOptions options, Observable<Buffer> body) {
        this.send(options, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(RequestOptions options, Observable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.send(options, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, int port, String host, String requestURI, MultiMap headers, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, port, host, requestURI, headers.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, int port, String host, String requestURI, MultiMap headers) {
        this.send(method, port, host, requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, int port, String host, String requestURI, MultiMap headers) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, port, host, requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, int port, String host, String requestURI, MultiMap headers, Buffer body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, port, host, requestURI, headers.getDelegate(), body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, int port, String host, String requestURI, MultiMap headers, Buffer body) {
        this.send(method, port, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, int port, String host, String requestURI, MultiMap headers, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, port, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, int port, String host, String requestURI, MultiMap headers, ReadStream<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, port, host, requestURI, headers.getDelegate(), body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, int port, String host, String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        this.send(method, port, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, int port, String host, String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, port, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, int port, String host, String requestURI, MultiMap headers, Flowable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, port, host, requestURI, headers.getDelegate(), ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, int port, String host, String requestURI, MultiMap headers, Flowable<Buffer> body) {
        this.send(method, port, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, int port, String host, String requestURI, MultiMap headers, Flowable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, port, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, int port, String host, String requestURI, MultiMap headers, Observable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, port, host, requestURI, headers.getDelegate(), ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, int port, String host, String requestURI, MultiMap headers, Observable<Buffer> body) {
        this.send(method, port, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, int port, String host, String requestURI, MultiMap headers, Observable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, port, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, int port, String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, port, host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, int port, String host, String requestURI) {
        this.send(method, port, host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, int port, String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, port, host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, int port, String host, String requestURI, Buffer body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, port, host, requestURI, body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, int port, String host, String requestURI, Buffer body) {
        this.send(method, port, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, int port, String host, String requestURI, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, port, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, int port, String host, String requestURI, ReadStream<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, port, host, requestURI, body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, int port, String host, String requestURI, ReadStream<Buffer> body) {
        this.send(method, port, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, int port, String host, String requestURI, ReadStream<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, port, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, int port, String host, String requestURI, Flowable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, port, host, requestURI, ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, int port, String host, String requestURI, Flowable<Buffer> body) {
        this.send(method, port, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, int port, String host, String requestURI, Flowable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, port, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, int port, String host, String requestURI, Observable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, port, host, requestURI, ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, int port, String host, String requestURI, Observable<Buffer> body) {
        this.send(method, port, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, int port, String host, String requestURI, Observable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, port, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, String host, String requestURI, MultiMap headers, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, host, requestURI, headers.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, String host, String requestURI, MultiMap headers) {
        this.send(method, host, requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, String host, String requestURI, MultiMap headers) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, host, requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, String host, String requestURI, MultiMap headers, Buffer body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, host, requestURI, headers.getDelegate(), body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, String host, String requestURI, MultiMap headers, Buffer body) {
        this.send(method, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, String host, String requestURI, MultiMap headers, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, String host, String requestURI, MultiMap headers, ReadStream<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, host, requestURI, headers.getDelegate(), body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, String host, String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        this.send(method, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, String host, String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, String host, String requestURI, MultiMap headers, Flowable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, host, requestURI, headers.getDelegate(), ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, String host, String requestURI, MultiMap headers, Flowable<Buffer> body) {
        this.send(method, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, String host, String requestURI, MultiMap headers, Flowable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, String host, String requestURI, MultiMap headers, Observable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, host, requestURI, headers.getDelegate(), ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, String host, String requestURI, MultiMap headers, Observable<Buffer> body) {
        this.send(method, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, String host, String requestURI, MultiMap headers, Observable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, String host, String requestURI) {
        this.send(method, host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, String host, String requestURI, Buffer body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, host, requestURI, body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, String host, String requestURI, Buffer body) {
        this.send(method, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, String host, String requestURI, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, String host, String requestURI, ReadStream<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, host, requestURI, body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, String host, String requestURI, ReadStream<Buffer> body) {
        this.send(method, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, String host, String requestURI, ReadStream<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, String host, String requestURI, Flowable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, host, requestURI, ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, String host, String requestURI, Flowable<Buffer> body) {
        this.send(method, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, String host, String requestURI, Flowable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, String host, String requestURI, Observable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, host, requestURI, ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, String host, String requestURI, Observable<Buffer> body) {
        this.send(method, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, String host, String requestURI, Observable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, String requestURI, MultiMap headers, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, requestURI, headers.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, String requestURI, MultiMap headers) {
        this.send(method, requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, String requestURI, MultiMap headers) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, String requestURI, MultiMap headers, Buffer body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, requestURI, headers.getDelegate(), body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, String requestURI, MultiMap headers, Buffer body) {
        this.send(method, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, String requestURI, MultiMap headers, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, String requestURI, MultiMap headers, ReadStream<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, requestURI, headers.getDelegate(), body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        this.send(method, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, String requestURI, MultiMap headers, Flowable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, requestURI, headers.getDelegate(), ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, String requestURI, MultiMap headers, Flowable<Buffer> body) {
        this.send(method, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, String requestURI, MultiMap headers, Flowable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, String requestURI, MultiMap headers, Observable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, requestURI, headers.getDelegate(), ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, String requestURI, MultiMap headers, Observable<Buffer> body) {
        this.send(method, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, String requestURI, MultiMap headers, Observable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, String requestURI) {
        this.send(method, requestURI, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, requestURI, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, String requestURI, Buffer body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, requestURI, body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, String requestURI, Buffer body) {
        this.send(method, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, String requestURI, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, String requestURI, ReadStream<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, requestURI, body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, String requestURI, ReadStream<Buffer> body) {
        this.send(method, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, String requestURI, ReadStream<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, String requestURI, Flowable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, requestURI, ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, String requestURI, Flowable<Buffer> body) {
        this.send(method, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, String requestURI, Flowable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void send(HttpMethod method, String requestURI, Observable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.send(method, requestURI, ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void send(HttpMethod method, String requestURI, Observable<Buffer> body) {
        this.send(method, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxSend(HttpMethod method, String requestURI, Observable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.send(method, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void request(RequestOptions options, final Handler<AsyncResult<HttpClientRequest>> handler) {
        this.delegate.request(options, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientRequest>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientRequest> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)ar.result())));
                } else {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void request(RequestOptions options) {
        this.request(options, (Handler<AsyncResult<HttpClientRequest>>)((Handler)ar -> {}));
    }

    public Single<HttpClientRequest> rxRequest(RequestOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.request(options, (Handler<AsyncResult<HttpClientRequest>>)$handler));
    }

    public void request(HttpMethod method, int port, String host, String requestURI, final Handler<AsyncResult<HttpClientRequest>> handler) {
        this.delegate.request(method, port, host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientRequest>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientRequest> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)ar.result())));
                } else {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void request(HttpMethod method, int port, String host, String requestURI) {
        this.request(method, port, host, requestURI, (Handler<AsyncResult<HttpClientRequest>>)((Handler)ar -> {}));
    }

    public Single<HttpClientRequest> rxRequest(HttpMethod method, int port, String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.request(method, port, host, requestURI, (Handler<AsyncResult<HttpClientRequest>>)$handler));
    }

    public void request(HttpMethod method, String host, String requestURI, final Handler<AsyncResult<HttpClientRequest>> handler) {
        this.delegate.request(method, host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientRequest>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientRequest> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)ar.result())));
                } else {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void request(HttpMethod method, String host, String requestURI) {
        this.request(method, host, requestURI, (Handler<AsyncResult<HttpClientRequest>>)((Handler)ar -> {}));
    }

    public Single<HttpClientRequest> rxRequest(HttpMethod method, String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.request(method, host, requestURI, (Handler<AsyncResult<HttpClientRequest>>)$handler));
    }

    public void request(HttpMethod method, String requestURI, final Handler<AsyncResult<HttpClientRequest>> handler) {
        this.delegate.request(method, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientRequest>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientRequest> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)ar.result())));
                } else {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void request(HttpMethod method, String requestURI) {
        this.request(method, requestURI, (Handler<AsyncResult<HttpClientRequest>>)((Handler)ar -> {}));
    }

    public Single<HttpClientRequest> rxRequest(HttpMethod method, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.request(method, requestURI, (Handler<AsyncResult<HttpClientRequest>>)$handler));
    }

    public void get(int port, String host, String requestURI, MultiMap headers, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.get(port, host, requestURI, headers.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void get(int port, String host, String requestURI, MultiMap headers) {
        this.get(port, host, requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxGet(int port, String host, String requestURI, MultiMap headers) {
        return AsyncResultSingle.toSingle($handler -> this.get(port, host, requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void get(String host, String requestURI, MultiMap headers, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.get(host, requestURI, headers.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void get(String host, String requestURI, MultiMap headers) {
        this.get(host, requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxGet(String host, String requestURI, MultiMap headers) {
        return AsyncResultSingle.toSingle($handler -> this.get(host, requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void get(String requestURI, MultiMap headers, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.get(requestURI, headers.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void get(String requestURI, MultiMap headers) {
        this.get(requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxGet(String requestURI, MultiMap headers) {
        return AsyncResultSingle.toSingle($handler -> this.get(requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void get(RequestOptions options, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.get(options, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void get(RequestOptions options) {
        this.get(options, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxGet(RequestOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.get(options, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void get(int port, String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.get(port, host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void get(int port, String host, String requestURI) {
        this.get(port, host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxGet(int port, String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.get(port, host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void get(String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.get(host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void get(String host, String requestURI) {
        this.get(host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxGet(String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.get(host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void get(String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.get(requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void get(String requestURI) {
        this.get(requestURI, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxGet(String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.get(requestURI, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(int port, String host, String requestURI, MultiMap headers, Buffer body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(port, host, requestURI, headers.getDelegate(), body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(int port, String host, String requestURI, MultiMap headers, Buffer body) {
        this.post(port, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(int port, String host, String requestURI, MultiMap headers, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.post(port, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(int port, String host, String requestURI, MultiMap headers, ReadStream<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(port, host, requestURI, headers.getDelegate(), body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(int port, String host, String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        this.post(port, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(int port, String host, String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.post(port, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(int port, String host, String requestURI, MultiMap headers, Flowable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(port, host, requestURI, headers.getDelegate(), ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(int port, String host, String requestURI, MultiMap headers, Flowable<Buffer> body) {
        this.post(port, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(int port, String host, String requestURI, MultiMap headers, Flowable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.post(port, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(int port, String host, String requestURI, MultiMap headers, Observable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(port, host, requestURI, headers.getDelegate(), ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(int port, String host, String requestURI, MultiMap headers, Observable<Buffer> body) {
        this.post(port, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(int port, String host, String requestURI, MultiMap headers, Observable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.post(port, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(String host, String requestURI, MultiMap headers, Buffer body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(host, requestURI, headers.getDelegate(), body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(String host, String requestURI, MultiMap headers, Buffer body) {
        this.post(host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(String host, String requestURI, MultiMap headers, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.post(host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(String host, String requestURI, MultiMap headers, ReadStream<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(host, requestURI, headers.getDelegate(), body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(String host, String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        this.post(host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(String host, String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.post(host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(String host, String requestURI, MultiMap headers, Flowable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(host, requestURI, headers.getDelegate(), ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(String host, String requestURI, MultiMap headers, Flowable<Buffer> body) {
        this.post(host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(String host, String requestURI, MultiMap headers, Flowable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.post(host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(String host, String requestURI, MultiMap headers, Observable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(host, requestURI, headers.getDelegate(), ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(String host, String requestURI, MultiMap headers, Observable<Buffer> body) {
        this.post(host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(String host, String requestURI, MultiMap headers, Observable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.post(host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(String requestURI, MultiMap headers, Buffer body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(requestURI, headers.getDelegate(), body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(String requestURI, MultiMap headers, Buffer body) {
        this.post(requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(String requestURI, MultiMap headers, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.post(requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(String requestURI, MultiMap headers, ReadStream<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(requestURI, headers.getDelegate(), body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        this.post(requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.post(requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(String requestURI, MultiMap headers, Flowable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(requestURI, headers.getDelegate(), ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(String requestURI, MultiMap headers, Flowable<Buffer> body) {
        this.post(requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(String requestURI, MultiMap headers, Flowable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.post(requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(String requestURI, MultiMap headers, Observable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(requestURI, headers.getDelegate(), ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(String requestURI, MultiMap headers, Observable<Buffer> body) {
        this.post(requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(String requestURI, MultiMap headers, Observable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.post(requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(RequestOptions options, Buffer body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(options, body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(RequestOptions options, Buffer body) {
        this.post(options, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(RequestOptions options, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.post(options, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(RequestOptions options, ReadStream<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(options, body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(RequestOptions options, ReadStream<Buffer> body) {
        this.post(options, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(RequestOptions options, ReadStream<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.post(options, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(RequestOptions options, Flowable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(options, ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(RequestOptions options, Flowable<Buffer> body) {
        this.post(options, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(RequestOptions options, Flowable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.post(options, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(RequestOptions options, Observable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(options, ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(RequestOptions options, Observable<Buffer> body) {
        this.post(options, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(RequestOptions options, Observable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.post(options, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(int port, String host, String requestURI, Buffer body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(port, host, requestURI, body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(int port, String host, String requestURI, Buffer body) {
        this.post(port, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(int port, String host, String requestURI, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.post(port, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(int port, String host, String requestURI, ReadStream<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(port, host, requestURI, body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(int port, String host, String requestURI, ReadStream<Buffer> body) {
        this.post(port, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(int port, String host, String requestURI, ReadStream<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.post(port, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(int port, String host, String requestURI, Flowable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(port, host, requestURI, ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(int port, String host, String requestURI, Flowable<Buffer> body) {
        this.post(port, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(int port, String host, String requestURI, Flowable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.post(port, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(int port, String host, String requestURI, Observable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(port, host, requestURI, ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(int port, String host, String requestURI, Observable<Buffer> body) {
        this.post(port, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(int port, String host, String requestURI, Observable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.post(port, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(String host, String requestURI, Buffer body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(host, requestURI, body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(String host, String requestURI, Buffer body) {
        this.post(host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(String host, String requestURI, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.post(host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(String host, String requestURI, ReadStream<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(host, requestURI, body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(String host, String requestURI, ReadStream<Buffer> body) {
        this.post(host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(String host, String requestURI, ReadStream<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.post(host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(String host, String requestURI, Flowable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(host, requestURI, ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(String host, String requestURI, Flowable<Buffer> body) {
        this.post(host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(String host, String requestURI, Flowable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.post(host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(String host, String requestURI, Observable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(host, requestURI, ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(String host, String requestURI, Observable<Buffer> body) {
        this.post(host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(String host, String requestURI, Observable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.post(host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(String requestURI, Buffer body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(requestURI, body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(String requestURI, Buffer body) {
        this.post(requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(String requestURI, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.post(requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(String requestURI, ReadStream<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(requestURI, body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(String requestURI, ReadStream<Buffer> body) {
        this.post(requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(String requestURI, ReadStream<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.post(requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(String requestURI, Flowable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(requestURI, ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(String requestURI, Flowable<Buffer> body) {
        this.post(requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(String requestURI, Flowable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.post(requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void post(String requestURI, Observable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.post(requestURI, ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void post(String requestURI, Observable<Buffer> body) {
        this.post(requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPost(String requestURI, Observable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.post(requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(int port, String host, String requestURI, MultiMap headers, Buffer body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(port, host, requestURI, headers.getDelegate(), body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(int port, String host, String requestURI, MultiMap headers, Buffer body) {
        this.put(port, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(int port, String host, String requestURI, MultiMap headers, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.put(port, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(int port, String host, String requestURI, MultiMap headers, ReadStream<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(port, host, requestURI, headers.getDelegate(), body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(int port, String host, String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        this.put(port, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(int port, String host, String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.put(port, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(int port, String host, String requestURI, MultiMap headers, Flowable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(port, host, requestURI, headers.getDelegate(), ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(int port, String host, String requestURI, MultiMap headers, Flowable<Buffer> body) {
        this.put(port, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(int port, String host, String requestURI, MultiMap headers, Flowable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.put(port, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(int port, String host, String requestURI, MultiMap headers, Observable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(port, host, requestURI, headers.getDelegate(), ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(int port, String host, String requestURI, MultiMap headers, Observable<Buffer> body) {
        this.put(port, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(int port, String host, String requestURI, MultiMap headers, Observable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.put(port, host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(String host, String requestURI, MultiMap headers, Buffer body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(host, requestURI, headers.getDelegate(), body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(String host, String requestURI, MultiMap headers, Buffer body) {
        this.put(host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(String host, String requestURI, MultiMap headers, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.put(host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(String host, String requestURI, MultiMap headers, ReadStream<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(host, requestURI, headers.getDelegate(), body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(String host, String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        this.put(host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(String host, String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.put(host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(String host, String requestURI, MultiMap headers, Flowable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(host, requestURI, headers.getDelegate(), ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(String host, String requestURI, MultiMap headers, Flowable<Buffer> body) {
        this.put(host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(String host, String requestURI, MultiMap headers, Flowable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.put(host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(String host, String requestURI, MultiMap headers, Observable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(host, requestURI, headers.getDelegate(), ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(String host, String requestURI, MultiMap headers, Observable<Buffer> body) {
        this.put(host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(String host, String requestURI, MultiMap headers, Observable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.put(host, requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(String requestURI, MultiMap headers, Buffer body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(requestURI, headers.getDelegate(), body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(String requestURI, MultiMap headers, Buffer body) {
        this.put(requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(String requestURI, MultiMap headers, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.put(requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(String requestURI, MultiMap headers, ReadStream<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(requestURI, headers.getDelegate(), body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        this.put(requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(String requestURI, MultiMap headers, ReadStream<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.put(requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(String requestURI, MultiMap headers, Flowable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(requestURI, headers.getDelegate(), ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(String requestURI, MultiMap headers, Flowable<Buffer> body) {
        this.put(requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(String requestURI, MultiMap headers, Flowable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.put(requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(String requestURI, MultiMap headers, Observable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(requestURI, headers.getDelegate(), ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(String requestURI, MultiMap headers, Observable<Buffer> body) {
        this.put(requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(String requestURI, MultiMap headers, Observable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.put(requestURI, headers, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(RequestOptions options, Buffer body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(options, body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(RequestOptions options, Buffer body) {
        this.put(options, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(RequestOptions options, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.put(options, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(RequestOptions options, ReadStream<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(options, body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(RequestOptions options, ReadStream<Buffer> body) {
        this.put(options, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(RequestOptions options, ReadStream<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.put(options, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(RequestOptions options, Flowable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(options, ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(RequestOptions options, Flowable<Buffer> body) {
        this.put(options, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(RequestOptions options, Flowable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.put(options, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(RequestOptions options, Observable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(options, ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(RequestOptions options, Observable<Buffer> body) {
        this.put(options, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(RequestOptions options, Observable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.put(options, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(int port, String host, String requestURI, Buffer body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(port, host, requestURI, body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(int port, String host, String requestURI, Buffer body) {
        this.put(port, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(int port, String host, String requestURI, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.put(port, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(int port, String host, String requestURI, ReadStream<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(port, host, requestURI, body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(int port, String host, String requestURI, ReadStream<Buffer> body) {
        this.put(port, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(int port, String host, String requestURI, ReadStream<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.put(port, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(int port, String host, String requestURI, Flowable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(port, host, requestURI, ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(int port, String host, String requestURI, Flowable<Buffer> body) {
        this.put(port, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(int port, String host, String requestURI, Flowable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.put(port, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(int port, String host, String requestURI, Observable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(port, host, requestURI, ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(int port, String host, String requestURI, Observable<Buffer> body) {
        this.put(port, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(int port, String host, String requestURI, Observable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.put(port, host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(String host, String requestURI, Buffer body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(host, requestURI, body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(String host, String requestURI, Buffer body) {
        this.put(host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(String host, String requestURI, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.put(host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(String host, String requestURI, ReadStream<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(host, requestURI, body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(String host, String requestURI, ReadStream<Buffer> body) {
        this.put(host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(String host, String requestURI, ReadStream<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.put(host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(String host, String requestURI, Flowable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(host, requestURI, ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(String host, String requestURI, Flowable<Buffer> body) {
        this.put(host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(String host, String requestURI, Flowable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.put(host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(String host, String requestURI, Observable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(host, requestURI, ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(String host, String requestURI, Observable<Buffer> body) {
        this.put(host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(String host, String requestURI, Observable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.put(host, requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(String requestURI, Buffer body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(requestURI, body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(String requestURI, Buffer body) {
        this.put(requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(String requestURI, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.put(requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(String requestURI, ReadStream<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(requestURI, body.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(String requestURI, ReadStream<Buffer> body) {
        this.put(requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(String requestURI, ReadStream<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.put(requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(String requestURI, Flowable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(requestURI, ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(String requestURI, Flowable<Buffer> body) {
        this.put(requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(String requestURI, Flowable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.put(requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void put(String requestURI, Observable<Buffer> body, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.put(requestURI, ReadStreamSubscriber.asReadStream(body, obj -> obj.getDelegate()).resume(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void put(String requestURI, Observable<Buffer> body) {
        this.put(requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxPut(String requestURI, Observable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.put(requestURI, body, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void head(int port, String host, String requestURI, MultiMap headers, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.head(port, host, requestURI, headers.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void head(int port, String host, String requestURI, MultiMap headers) {
        this.head(port, host, requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxHead(int port, String host, String requestURI, MultiMap headers) {
        return AsyncResultSingle.toSingle($handler -> this.head(port, host, requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void head(String host, String requestURI, MultiMap headers, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.head(host, requestURI, headers.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void head(String host, String requestURI, MultiMap headers) {
        this.head(host, requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxHead(String host, String requestURI, MultiMap headers) {
        return AsyncResultSingle.toSingle($handler -> this.head(host, requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void head(String requestURI, MultiMap headers, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.head(requestURI, headers.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void head(String requestURI, MultiMap headers) {
        this.head(requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxHead(String requestURI, MultiMap headers) {
        return AsyncResultSingle.toSingle($handler -> this.head(requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void head(RequestOptions options, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.head(options, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void head(RequestOptions options) {
        this.head(options, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxHead(RequestOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.head(options, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void head(int port, String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.head(port, host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void head(int port, String host, String requestURI) {
        this.head(port, host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxHead(int port, String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.head(port, host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void head(String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.head(host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void head(String host, String requestURI) {
        this.head(host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxHead(String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.head(host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void head(String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.head(requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void head(String requestURI) {
        this.head(requestURI, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxHead(String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.head(requestURI, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void options(int port, String host, String requestURI, MultiMap headers, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.options(port, host, requestURI, headers.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void options(int port, String host, String requestURI, MultiMap headers) {
        this.options(port, host, requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxOptions(int port, String host, String requestURI, MultiMap headers) {
        return AsyncResultSingle.toSingle($handler -> this.options(port, host, requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void options(String host, String requestURI, MultiMap headers, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.options(host, requestURI, headers.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void options(String host, String requestURI, MultiMap headers) {
        this.options(host, requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxOptions(String host, String requestURI, MultiMap headers) {
        return AsyncResultSingle.toSingle($handler -> this.options(host, requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void options(String requestURI, MultiMap headers, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.options(requestURI, headers.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void options(String requestURI, MultiMap headers) {
        this.options(requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxOptions(String requestURI, MultiMap headers) {
        return AsyncResultSingle.toSingle($handler -> this.options(requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void options(RequestOptions options, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.options(options, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void options(RequestOptions options) {
        this.options(options, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxOptions(RequestOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.options(options, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void options(int port, String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.options(port, host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void options(int port, String host, String requestURI) {
        this.options(port, host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxOptions(int port, String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.options(port, host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void options(String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.options(host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void options(String host, String requestURI) {
        this.options(host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxOptions(String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.options(host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void options(String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.options(requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void options(String requestURI) {
        this.options(requestURI, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxOptions(String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.options(requestURI, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void delete(int port, String host, String requestURI, MultiMap headers, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.delete(port, host, requestURI, headers.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void delete(int port, String host, String requestURI, MultiMap headers) {
        this.delete(port, host, requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxDelete(int port, String host, String requestURI, MultiMap headers) {
        return AsyncResultSingle.toSingle($handler -> this.delete(port, host, requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void delete(String host, String requestURI, MultiMap headers, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.delete(host, requestURI, headers.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void delete(String host, String requestURI, MultiMap headers) {
        this.delete(host, requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxDelete(String host, String requestURI, MultiMap headers) {
        return AsyncResultSingle.toSingle($handler -> this.delete(host, requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void delete(String requestURI, MultiMap headers, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.delete(requestURI, headers.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void delete(String requestURI, MultiMap headers) {
        this.delete(requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxDelete(String requestURI, MultiMap headers) {
        return AsyncResultSingle.toSingle($handler -> this.delete(requestURI, headers, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void delete(RequestOptions options, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.delete(options, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void delete(RequestOptions options) {
        this.delete(options, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxDelete(RequestOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.delete(options, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void delete(int port, String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.delete(port, host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void delete(int port, String host, String requestURI) {
        this.delete(port, host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxDelete(int port, String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.delete(port, host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void delete(String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.delete(host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void delete(String host, String requestURI) {
        this.delete(host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxDelete(String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.delete(host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void delete(String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.delete(requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void delete(String requestURI) {
        this.delete(requestURI, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxDelete(String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.delete(requestURI, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public void webSocket(int port, String host, String requestURI, final Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.webSocket(port, host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.WebSocket>>(){

            public void handle(AsyncResult<io.vertx.core.http.WebSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)WebSocket.newInstance((io.vertx.core.http.WebSocket)ar.result())));
                } else {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void webSocket(int port, String host, String requestURI) {
        this.webSocket(port, host, requestURI, (Handler<AsyncResult<WebSocket>>)((Handler)ar -> {}));
    }

    public Single<WebSocket> rxWebSocket(int port, String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.webSocket(port, host, requestURI, (Handler<AsyncResult<WebSocket>>)$handler));
    }

    public void webSocket(String host, String requestURI, final Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.webSocket(host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.WebSocket>>(){

            public void handle(AsyncResult<io.vertx.core.http.WebSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)WebSocket.newInstance((io.vertx.core.http.WebSocket)ar.result())));
                } else {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void webSocket(String host, String requestURI) {
        this.webSocket(host, requestURI, (Handler<AsyncResult<WebSocket>>)((Handler)ar -> {}));
    }

    public Single<WebSocket> rxWebSocket(String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.webSocket(host, requestURI, (Handler<AsyncResult<WebSocket>>)$handler));
    }

    public void webSocket(String requestURI, final Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.webSocket(requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.WebSocket>>(){

            public void handle(AsyncResult<io.vertx.core.http.WebSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)WebSocket.newInstance((io.vertx.core.http.WebSocket)ar.result())));
                } else {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void webSocket(String requestURI) {
        this.webSocket(requestURI, (Handler<AsyncResult<WebSocket>>)((Handler)ar -> {}));
    }

    public Single<WebSocket> rxWebSocket(String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.webSocket(requestURI, (Handler<AsyncResult<WebSocket>>)$handler));
    }

    public void webSocket(WebSocketConnectOptions options, final Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.webSocket(options, (Handler)new Handler<AsyncResult<io.vertx.core.http.WebSocket>>(){

            public void handle(AsyncResult<io.vertx.core.http.WebSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)WebSocket.newInstance((io.vertx.core.http.WebSocket)ar.result())));
                } else {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void webSocket(WebSocketConnectOptions options) {
        this.webSocket(options, (Handler<AsyncResult<WebSocket>>)((Handler)ar -> {}));
    }

    public Single<WebSocket> rxWebSocket(WebSocketConnectOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.webSocket(options, (Handler<AsyncResult<WebSocket>>)$handler));
    }

    public void webSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols, final Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.webSocketAbs(url, headers.getDelegate(), version, subProtocols, (Handler)new Handler<AsyncResult<io.vertx.core.http.WebSocket>>(){

            public void handle(AsyncResult<io.vertx.core.http.WebSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)WebSocket.newInstance((io.vertx.core.http.WebSocket)ar.result())));
                } else {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void webSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols) {
        this.webSocketAbs(url, headers, version, subProtocols, (Handler<AsyncResult<WebSocket>>)((Handler)ar -> {}));
    }

    public Single<WebSocket> rxWebSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols) {
        return AsyncResultSingle.toSingle($handler -> this.webSocketAbs(url, headers, version, subProtocols, (Handler<AsyncResult<WebSocket>>)$handler));
    }

    public HttpClient connectionHandler(final Handler<HttpConnection> handler) {
        this.delegate.connectionHandler((Handler)new Handler<io.vertx.core.http.HttpConnection>(){

            public void handle(io.vertx.core.http.HttpConnection event) {
                handler.handle((Object)HttpConnection.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient redirectHandler(final Function<HttpClientResponse, Future<RequestOptions>> handler) {
        this.delegate.redirectHandler((Function)new Function<io.vertx.core.http.HttpClientResponse, io.vertx.core.Future<RequestOptions>>(){

            @Override
            public io.vertx.core.Future<RequestOptions> apply(io.vertx.core.http.HttpClientResponse arg) {
                Future ret = (Future)handler.apply(HttpClientResponse.newInstance(arg));
                return ret.getDelegate();
            }
        });
        return this;
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public void close() {
        this.close((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close((Handler<AsyncResult<Void>>)$handler));
    }

    public static HttpClient newInstance(io.vertx.core.http.HttpClient arg) {
        return arg != null ? new HttpClient(arg) : null;
    }
}

