/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.http;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.GoAway;
import io.vertx.core.http.Http2Settings;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.Future;
import io.vertx.reactivex.core.net.SocketAddress;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import javax.net.ssl.SSLSession;

@RxGen(value=io.vertx.core.http.HttpConnection.class)
public class HttpConnection {
    public static final TypeArg<HttpConnection> __TYPE_ARG = new TypeArg(obj -> new HttpConnection((io.vertx.core.http.HttpConnection)obj), HttpConnection::getDelegate);
    private final io.vertx.core.http.HttpConnection delegate;
    private SocketAddress cached_0;
    private SocketAddress cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpConnection that = (HttpConnection)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpConnection(io.vertx.core.http.HttpConnection delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.http.HttpConnection getDelegate() {
        return this.delegate;
    }

    public int getWindowSize() {
        int ret = this.delegate.getWindowSize();
        return ret;
    }

    public HttpConnection setWindowSize(int windowSize) {
        this.delegate.setWindowSize(windowSize);
        return this;
    }

    public HttpConnection goAway(long errorCode) {
        this.delegate.goAway(errorCode);
        return this;
    }

    public HttpConnection goAway(long errorCode, int lastStreamId) {
        this.delegate.goAway(errorCode, lastStreamId);
        return this;
    }

    public HttpConnection goAway(long errorCode, int lastStreamId, io.vertx.reactivex.core.buffer.Buffer debugData) {
        this.delegate.goAway(errorCode, lastStreamId, debugData.getDelegate());
        return this;
    }

    public HttpConnection goAwayHandler(Handler<GoAway> handler) {
        this.delegate.goAwayHandler(handler);
        return this;
    }

    public HttpConnection shutdownHandler(Handler<Void> handler) {
        this.delegate.shutdownHandler(handler);
        return this;
    }

    public HttpConnection shutdown() {
        this.delegate.shutdown();
        return this;
    }

    public HttpConnection shutdown(long timeoutMs) {
        this.delegate.shutdown(timeoutMs);
        return this;
    }

    public HttpConnection closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public Future<Void> close() {
        Future<Void> ret = Future.newInstance(this.delegate.close(), TypeArg.unknown());
        return ret;
    }

    public Http2Settings settings() {
        Http2Settings ret = this.delegate.settings();
        return ret;
    }

    public HttpConnection updateSettings(Http2Settings settings, Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.updateSettings(settings, completionHandler);
        return this;
    }

    public HttpConnection updateSettings(Http2Settings settings) {
        return this.updateSettings(settings, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Completable rxUpdateSettings(Http2Settings settings) {
        return AsyncResultCompletable.toCompletable($handler -> this.updateSettings(settings, (Handler<AsyncResult<Void>>)$handler));
    }

    public Http2Settings remoteSettings() {
        Http2Settings ret = this.delegate.remoteSettings();
        return ret;
    }

    public HttpConnection remoteSettingsHandler(Handler<Http2Settings> handler) {
        this.delegate.remoteSettingsHandler(handler);
        return this;
    }

    public HttpConnection ping(io.vertx.reactivex.core.buffer.Buffer data, final Handler<AsyncResult<io.vertx.reactivex.core.buffer.Buffer>> pongHandler) {
        this.delegate.ping(data.getDelegate(), (Handler)new Handler<AsyncResult<Buffer>>(){

            public void handle(AsyncResult<Buffer> ar) {
                if (ar.succeeded()) {
                    pongHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)io.vertx.reactivex.core.buffer.Buffer.newInstance((Buffer)ar.result())));
                } else {
                    pongHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpConnection ping(io.vertx.reactivex.core.buffer.Buffer data) {
        return this.ping(data, (Handler<AsyncResult<io.vertx.reactivex.core.buffer.Buffer>>)((Handler)ar -> {}));
    }

    public Single<io.vertx.reactivex.core.buffer.Buffer> rxPing(io.vertx.reactivex.core.buffer.Buffer data) {
        return AsyncResultSingle.toSingle($handler -> this.ping(data, (Handler<AsyncResult<io.vertx.reactivex.core.buffer.Buffer>>)$handler));
    }

    public HttpConnection pingHandler(final Handler<io.vertx.reactivex.core.buffer.Buffer> handler) {
        this.delegate.pingHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                handler.handle((Object)io.vertx.reactivex.core.buffer.Buffer.newInstance(event));
            }
        });
        return this;
    }

    public HttpConnection exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    public String indicatedServerName() {
        String ret = this.delegate.indicatedServerName();
        return ret;
    }

    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    public static HttpConnection newInstance(io.vertx.core.http.HttpConnection arg) {
        return arg != null ? new HttpConnection(arg) : null;
    }
}

