/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.http;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.streams.ReadStream;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.core.MultiMap;
import io.vertx.reactivex.core.http.HttpClientRequest;
import io.vertx.reactivex.core.http.HttpFrame;
import io.vertx.reactivex.core.streams.Pipe;
import io.vertx.reactivex.core.streams.WriteStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.List;
import java.util.function.Function;

@RxGen(value=io.vertx.core.http.HttpClientResponse.class)
public class HttpClientResponse
implements io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer> {
    public static final TypeArg<HttpClientResponse> __TYPE_ARG = new TypeArg(obj -> new HttpClientResponse((io.vertx.core.http.HttpClientResponse)obj), HttpClientResponse::getDelegate);
    private final io.vertx.core.http.HttpClientResponse delegate;
    private Observable<io.vertx.reactivex.core.buffer.Buffer> observable;
    private Flowable<io.vertx.reactivex.core.buffer.Buffer> flowable;
    private MultiMap cached_0;
    private MultiMap cached_1;
    private List<String> cached_2;
    private HttpClientRequest cached_3;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClientResponse that = (HttpClientResponse)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpClientResponse(io.vertx.core.http.HttpClientResponse delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.http.HttpClientResponse getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<io.vertx.reactivex.core.buffer.Buffer> toObservable() {
        if (this.observable == null) {
            Function<Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
            this.observable = ObservableHelper.toObservable((ReadStream)this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<io.vertx.reactivex.core.buffer.Buffer> toFlowable() {
        if (this.flowable == null) {
            Function<Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
            this.flowable = FlowableHelper.toFlowable((ReadStream)this.delegate, conv);
        }
        return this.flowable;
    }

    @Override
    public Pipe<io.vertx.reactivex.core.buffer.Buffer> pipe() {
        Pipe<io.vertx.reactivex.core.buffer.Buffer> ret = Pipe.newInstance(this.delegate.pipe(), io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
        return ret;
    }

    @Override
    public void pipeTo(WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    @Override
    public void pipeTo(WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) {
        this.pipeTo(dst, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    @Override
    public Completable rxPipeTo(WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) {
        return AsyncResultCompletable.toCompletable($handler -> this.pipeTo(dst, (Handler<AsyncResult<Void>>)$handler));
    }

    public HttpClientResponse fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public HttpClientResponse resume() {
        this.delegate.resume();
        return this;
    }

    @Override
    public HttpClientResponse exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpClientResponse handler(final Handler<io.vertx.reactivex.core.buffer.Buffer> handler) {
        this.delegate.handler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                handler.handle((Object)io.vertx.reactivex.core.buffer.Buffer.newInstance(event));
            }
        });
        return this;
    }

    public HttpClientResponse pause() {
        this.delegate.pause();
        return this;
    }

    public HttpClientResponse endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public HttpVersion version() {
        HttpVersion ret = this.delegate.version();
        return ret;
    }

    public int statusCode() {
        int ret = this.delegate.statusCode();
        return ret;
    }

    public String statusMessage() {
        String ret = this.delegate.statusMessage();
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    public String getHeader(String headerName) {
        String ret = this.delegate.getHeader(headerName);
        return ret;
    }

    public String getTrailer(String trailerName) {
        String ret = this.delegate.getTrailer(trailerName);
        return ret;
    }

    public MultiMap trailers() {
        MultiMap ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = MultiMap.newInstance(this.delegate.trailers());
        return ret;
    }

    public List<String> cookies() {
        List ret;
        if (this.cached_2 != null) {
            return this.cached_2;
        }
        this.cached_2 = ret = this.delegate.cookies();
        return ret;
    }

    public HttpClientResponse bodyHandler(final Handler<io.vertx.reactivex.core.buffer.Buffer> bodyHandler) {
        this.delegate.bodyHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                bodyHandler.handle((Object)io.vertx.reactivex.core.buffer.Buffer.newInstance(event));
            }
        });
        return this;
    }

    public HttpClientResponse body(final Handler<AsyncResult<io.vertx.reactivex.core.buffer.Buffer>> handler) {
        this.delegate.body((Handler)new Handler<AsyncResult<Buffer>>(){

            public void handle(AsyncResult<Buffer> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)io.vertx.reactivex.core.buffer.Buffer.newInstance((Buffer)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpClientResponse body() {
        return this.body((Handler<AsyncResult<io.vertx.reactivex.core.buffer.Buffer>>)((Handler)ar -> {}));
    }

    public Single<io.vertx.reactivex.core.buffer.Buffer> rxBody() {
        return AsyncResultSingle.toSingle($handler -> this.body((Handler<AsyncResult<io.vertx.reactivex.core.buffer.Buffer>>)$handler));
    }

    public HttpClientResponse customFrameHandler(final Handler<HttpFrame> handler) {
        this.delegate.customFrameHandler((Handler)new Handler<io.vertx.core.http.HttpFrame>(){

            public void handle(io.vertx.core.http.HttpFrame event) {
                handler.handle((Object)HttpFrame.newInstance(event));
            }
        });
        return this;
    }

    public HttpClientRequest request() {
        HttpClientRequest ret;
        if (this.cached_3 != null) {
            return this.cached_3;
        }
        this.cached_3 = ret = HttpClientRequest.newInstance(this.delegate.request());
        return ret;
    }

    public HttpClientResponse streamPriorityHandler(Handler<StreamPriority> handler) {
        this.delegate.streamPriorityHandler(handler);
        return this;
    }

    public String getHeader(CharSequence headerName) {
        String ret = this.delegate.getHeader(headerName);
        return ret;
    }

    public static HttpClientResponse newInstance(io.vertx.core.http.HttpClientResponse arg) {
        return arg != null ? new HttpClientResponse(arg) : null;
    }
}

