/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.http;

import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.Future;
import io.vertx.reactivex.core.MultiMap;
import io.vertx.reactivex.core.http.HttpClientRequest;
import io.vertx.reactivex.core.http.HttpClientResponse;
import io.vertx.reactivex.core.http.HttpConnection;
import io.vertx.reactivex.core.http.WebSocket;
import io.vertx.reactivex.core.metrics.Measured;
import io.vertx.reactivex.core.net.SocketAddress;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.List;
import java.util.function.Function;

@RxGen(value=io.vertx.core.http.HttpClient.class)
public class HttpClient
implements Measured {
    public static final TypeArg<HttpClient> __TYPE_ARG = new TypeArg(obj -> new HttpClient((io.vertx.core.http.HttpClient)obj), HttpClient::getDelegate);
    private final io.vertx.core.http.HttpClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClient that = (HttpClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpClient(io.vertx.core.http.HttpClient delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.http.HttpClient getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public HttpClientRequest request(HttpMethod method, SocketAddress serverAddress, RequestOptions options) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.request(method, serverAddress.getDelegate(), options));
        return ret;
    }

    public HttpClientRequest request(HttpMethod method, RequestOptions options) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.request(method, options));
        return ret;
    }

    public HttpClientRequest request(HttpMethod method, int port, String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.request(method, port, host, requestURI));
        return ret;
    }

    public HttpClientRequest request(HttpMethod method, SocketAddress serverAddress, int port, String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.request(method, serverAddress.getDelegate(), port, host, requestURI));
        return ret;
    }

    public HttpClientRequest request(HttpMethod method, String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.request(method, host, requestURI));
        return ret;
    }

    public HttpClientRequest request(HttpMethod method, RequestOptions options, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.request(method, options, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest request(HttpMethod method, SocketAddress serverAddress, RequestOptions options, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.request(method, serverAddress.getDelegate(), options, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest request(HttpMethod method, int port, String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.request(method, port, host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest request(HttpMethod method, SocketAddress serverAddress, int port, String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.request(method, serverAddress.getDelegate(), port, host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest request(HttpMethod method, String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.request(method, host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest request(HttpMethod method, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.request(method, requestURI));
        return ret;
    }

    public HttpClientRequest request(HttpMethod method, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.request(method, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest requestAbs(HttpMethod method, String absoluteURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.requestAbs(method, absoluteURI));
        return ret;
    }

    public HttpClientRequest requestAbs(HttpMethod method, SocketAddress serverAddress, String absoluteURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.requestAbs(method, serverAddress.getDelegate(), absoluteURI));
        return ret;
    }

    public HttpClientRequest requestAbs(HttpMethod method, String absoluteURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.requestAbs(method, absoluteURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest requestAbs(HttpMethod method, SocketAddress serverAddress, String absoluteURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.requestAbs(method, serverAddress.getDelegate(), absoluteURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest get(RequestOptions options) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.get(options));
        return ret;
    }

    public HttpClientRequest get(int port, String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.get(port, host, requestURI));
        return ret;
    }

    public HttpClientRequest get(String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.get(host, requestURI));
        return ret;
    }

    public HttpClientRequest get(RequestOptions options, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.get(options, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest get(int port, String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.get(port, host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest get(String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.get(host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest get(String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.get(requestURI));
        return ret;
    }

    public HttpClientRequest get(String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.get(requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest getAbs(String absoluteURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.getAbs(absoluteURI));
        return ret;
    }

    public HttpClientRequest getAbs(String absoluteURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.getAbs(absoluteURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClient getNow(RequestOptions options, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.getNow(options, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpClient getNow(RequestOptions options) {
        return this.getNow(options, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxGetNow(RequestOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.getNow(options, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public HttpClient getNow(int port, String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.getNow(port, host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpClient getNow(int port, String host, String requestURI) {
        return this.getNow(port, host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxGetNow(int port, String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.getNow(port, host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public HttpClient getNow(String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.getNow(host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpClient getNow(String host, String requestURI) {
        return this.getNow(host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxGetNow(String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.getNow(host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public HttpClient getNow(String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.getNow(requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpClient getNow(String requestURI) {
        return this.getNow(requestURI, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxGetNow(String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.getNow(requestURI, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public HttpClientRequest post(RequestOptions options) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.post(options));
        return ret;
    }

    public HttpClientRequest post(int port, String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.post(port, host, requestURI));
        return ret;
    }

    public HttpClientRequest post(String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.post(host, requestURI));
        return ret;
    }

    public HttpClientRequest post(RequestOptions options, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.post(options, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest post(int port, String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.post(port, host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest post(String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.post(host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest post(String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.post(requestURI));
        return ret;
    }

    public HttpClientRequest post(String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.post(requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest postAbs(String absoluteURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.postAbs(absoluteURI));
        return ret;
    }

    public HttpClientRequest postAbs(String absoluteURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.postAbs(absoluteURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest head(RequestOptions options) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.head(options));
        return ret;
    }

    public HttpClientRequest head(int port, String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.head(port, host, requestURI));
        return ret;
    }

    public HttpClientRequest head(String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.head(host, requestURI));
        return ret;
    }

    public HttpClientRequest head(RequestOptions options, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.head(options, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest head(int port, String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.head(port, host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest head(String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.head(host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest head(String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.head(requestURI));
        return ret;
    }

    public HttpClientRequest head(String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.head(requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest headAbs(String absoluteURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.headAbs(absoluteURI));
        return ret;
    }

    public HttpClientRequest headAbs(String absoluteURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.headAbs(absoluteURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClient headNow(RequestOptions options, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.headNow(options, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpClient headNow(RequestOptions options) {
        return this.headNow(options, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxHeadNow(RequestOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.headNow(options, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public HttpClient headNow(int port, String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.headNow(port, host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpClient headNow(int port, String host, String requestURI) {
        return this.headNow(port, host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxHeadNow(int port, String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.headNow(port, host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public HttpClient headNow(String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.headNow(host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpClient headNow(String host, String requestURI) {
        return this.headNow(host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxHeadNow(String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.headNow(host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public HttpClient headNow(String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.headNow(requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpClient headNow(String requestURI) {
        return this.headNow(requestURI, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxHeadNow(String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.headNow(requestURI, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public HttpClientRequest options(RequestOptions options) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.options(options));
        return ret;
    }

    public HttpClientRequest options(int port, String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.options(port, host, requestURI));
        return ret;
    }

    public HttpClientRequest options(String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.options(host, requestURI));
        return ret;
    }

    public HttpClientRequest options(RequestOptions options, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.options(options, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest options(int port, String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.options(port, host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest options(String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.options(host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest options(String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.options(requestURI));
        return ret;
    }

    public HttpClientRequest options(String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.options(requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest optionsAbs(String absoluteURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.optionsAbs(absoluteURI));
        return ret;
    }

    public HttpClientRequest optionsAbs(String absoluteURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.optionsAbs(absoluteURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClient optionsNow(RequestOptions options, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.optionsNow(options, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpClient optionsNow(RequestOptions options) {
        return this.optionsNow(options, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxOptionsNow(RequestOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.optionsNow(options, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public HttpClient optionsNow(int port, String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.optionsNow(port, host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpClient optionsNow(int port, String host, String requestURI) {
        return this.optionsNow(port, host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxOptionsNow(int port, String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.optionsNow(port, host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public HttpClient optionsNow(String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.optionsNow(host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpClient optionsNow(String host, String requestURI) {
        return this.optionsNow(host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxOptionsNow(String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.optionsNow(host, requestURI, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public HttpClient optionsNow(String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.delegate.optionsNow(requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public HttpClient optionsNow(String requestURI) {
        return this.optionsNow(requestURI, (Handler<AsyncResult<HttpClientResponse>>)((Handler)ar -> {}));
    }

    public Single<HttpClientResponse> rxOptionsNow(String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.optionsNow(requestURI, (Handler<AsyncResult<HttpClientResponse>>)$handler));
    }

    public HttpClientRequest put(RequestOptions options) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.put(options));
        return ret;
    }

    public HttpClientRequest put(int port, String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.put(port, host, requestURI));
        return ret;
    }

    public HttpClientRequest put(String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.put(host, requestURI));
        return ret;
    }

    public HttpClientRequest put(RequestOptions options, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.put(options, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest put(int port, String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.put(port, host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest put(String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.put(host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest put(String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.put(requestURI));
        return ret;
    }

    public HttpClientRequest put(String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.put(requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest putAbs(String absoluteURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.putAbs(absoluteURI));
        return ret;
    }

    public HttpClientRequest putAbs(String absoluteURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.putAbs(absoluteURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest delete(RequestOptions options) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.delete(options));
        return ret;
    }

    public HttpClientRequest delete(int port, String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.delete(port, host, requestURI));
        return ret;
    }

    public HttpClientRequest delete(String host, String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.delete(host, requestURI));
        return ret;
    }

    public HttpClientRequest delete(RequestOptions options, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.delete(options, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest delete(int port, String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.delete(port, host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest delete(String host, String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.delete(host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest delete(String requestURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.delete(requestURI));
        return ret;
    }

    public HttpClientRequest delete(String requestURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.delete(requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public HttpClientRequest deleteAbs(String absoluteURI) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.deleteAbs(absoluteURI));
        return ret;
    }

    public HttpClientRequest deleteAbs(String absoluteURI, final Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.deleteAbs(absoluteURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpClientResponse>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpClientResponse> ar) {
                if (ar.succeeded()) {
                    responseHandler.handle((Object)io.vertx.core.Future.succeededFuture((Object)HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)ar.result())));
                } else {
                    responseHandler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
        return ret;
    }

    public void webSocket(int port, String host, String requestURI, final Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.webSocket(port, host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.WebSocket>>(){

            public void handle(AsyncResult<io.vertx.core.http.WebSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)WebSocket.newInstance((io.vertx.core.http.WebSocket)ar.result())));
                } else {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void webSocket(int port, String host, String requestURI) {
        this.webSocket(port, host, requestURI, (Handler<AsyncResult<WebSocket>>)((Handler)ar -> {}));
    }

    public Single<WebSocket> rxWebSocket(int port, String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.webSocket(port, host, requestURI, (Handler<AsyncResult<WebSocket>>)$handler));
    }

    public void webSocket(String host, String requestURI, final Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.webSocket(host, requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.WebSocket>>(){

            public void handle(AsyncResult<io.vertx.core.http.WebSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)WebSocket.newInstance((io.vertx.core.http.WebSocket)ar.result())));
                } else {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void webSocket(String host, String requestURI) {
        this.webSocket(host, requestURI, (Handler<AsyncResult<WebSocket>>)((Handler)ar -> {}));
    }

    public Single<WebSocket> rxWebSocket(String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.webSocket(host, requestURI, (Handler<AsyncResult<WebSocket>>)$handler));
    }

    public void webSocket(String requestURI, final Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.webSocket(requestURI, (Handler)new Handler<AsyncResult<io.vertx.core.http.WebSocket>>(){

            public void handle(AsyncResult<io.vertx.core.http.WebSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)WebSocket.newInstance((io.vertx.core.http.WebSocket)ar.result())));
                } else {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void webSocket(String requestURI) {
        this.webSocket(requestURI, (Handler<AsyncResult<WebSocket>>)((Handler)ar -> {}));
    }

    public Single<WebSocket> rxWebSocket(String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.webSocket(requestURI, (Handler<AsyncResult<WebSocket>>)$handler));
    }

    public void webSocket(WebSocketConnectOptions options, final Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.webSocket(options, (Handler)new Handler<AsyncResult<io.vertx.core.http.WebSocket>>(){

            public void handle(AsyncResult<io.vertx.core.http.WebSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)WebSocket.newInstance((io.vertx.core.http.WebSocket)ar.result())));
                } else {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void webSocket(WebSocketConnectOptions options) {
        this.webSocket(options, (Handler<AsyncResult<WebSocket>>)((Handler)ar -> {}));
    }

    public Single<WebSocket> rxWebSocket(WebSocketConnectOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.webSocket(options, (Handler<AsyncResult<WebSocket>>)$handler));
    }

    public void webSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols, final Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.webSocketAbs(url, headers.getDelegate(), version, subProtocols, (Handler)new Handler<AsyncResult<io.vertx.core.http.WebSocket>>(){

            public void handle(AsyncResult<io.vertx.core.http.WebSocket> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)io.vertx.core.Future.succeededFuture((Object)WebSocket.newInstance((io.vertx.core.http.WebSocket)ar.result())));
                } else {
                    handler.handle((Object)io.vertx.core.Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void webSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols) {
        this.webSocketAbs(url, headers, version, subProtocols, (Handler<AsyncResult<WebSocket>>)((Handler)ar -> {}));
    }

    public Single<WebSocket> rxWebSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols) {
        return AsyncResultSingle.toSingle($handler -> this.webSocketAbs(url, headers, version, subProtocols, (Handler<AsyncResult<WebSocket>>)$handler));
    }

    public HttpClient connectionHandler(final Handler<HttpConnection> handler) {
        this.delegate.connectionHandler((Handler)new Handler<io.vertx.core.http.HttpConnection>(){

            public void handle(io.vertx.core.http.HttpConnection event) {
                handler.handle((Object)HttpConnection.newInstance(event));
            }
        });
        return this;
    }

    public HttpClient redirectHandler(final Function<HttpClientResponse, Future<HttpClientRequest>> handler) {
        this.delegate.redirectHandler((Function)new Function<io.vertx.core.http.HttpClientResponse, io.vertx.core.Future<io.vertx.core.http.HttpClientRequest>>(){

            @Override
            public io.vertx.core.Future<io.vertx.core.http.HttpClientRequest> apply(io.vertx.core.http.HttpClientResponse arg) {
                Future ret = (Future)handler.apply(HttpClientResponse.newInstance(arg));
                return ret.getDelegate();
            }
        });
        return this;
    }

    public void close() {
        this.delegate.close();
    }

    public static HttpClient newInstance(io.vertx.core.http.HttpClient arg) {
        return arg != null ? new HttpClient(arg) : null;
    }
}

