/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.reactivex;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.vertx.codegen.ClassModel;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeReflectionFactory;
import io.vertx.lang.rx.AbstractRxGenerator;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class RxJava2Generator
extends AbstractRxGenerator {
    RxJava2Generator() {
        super("reactivex");
        this.kinds = Collections.singleton("class");
        this.name = "RxJava2";
    }

    protected boolean isImported(TypeInfo type) {
        return type.getName().startsWith("io.reactivex.") || super.isImported(type);
    }

    protected void genImports(ClassModel model, PrintWriter writer) {
        writer.println("import io.reactivex.Observable;");
        writer.println("import io.reactivex.Flowable;");
        writer.println("import io.reactivex.Single;");
        writer.println("import io.reactivex.Completable;");
        writer.println("import io.reactivex.Maybe;");
        writer.println("import io.vertx.reactivex.RxHelper;");
        writer.println("import io.vertx.reactivex.ObservableHelper;");
        writer.println("import io.vertx.reactivex.FlowableHelper;");
        writer.println("import io.vertx.reactivex.impl.AsyncResultMaybe;");
        writer.println("import io.vertx.reactivex.impl.AsyncResultSingle;");
        writer.println("import io.vertx.reactivex.impl.AsyncResultCompletable;");
        writer.println("import io.vertx.reactivex.WriteStreamObserver;");
        writer.println("import io.vertx.reactivex.WriteStreamSubscriber;");
        super.genImports(model, writer);
    }

    protected void genToObservable(TypeInfo streamType, PrintWriter writer) {
        writer.print("  private Observable<");
        writer.print(this.genTranslatedTypeName(streamType));
        writer.println("> observable;");
        writer.print("  private Flowable<");
        writer.print(this.genTranslatedTypeName(streamType));
        writer.println("> flowable;");
        writer.println();
        this.genToXXXAble(streamType, "Observable", "observable", writer);
        this.genToXXXAble(streamType, "Flowable", "flowable", writer);
    }

    private void genToXXXAble(TypeInfo streamType, String rxType, String rxName, PrintWriter writer) {
        writer.print("  public synchronized ");
        writer.print(rxType);
        writer.print("<");
        writer.print(this.genTranslatedTypeName(streamType));
        writer.print("> to");
        writer.print(rxType);
        writer.println("() {");
        writer.print("    ");
        writer.print("if (");
        writer.print(rxName);
        writer.println(" == null) {");
        if (streamType.getKind() == ClassKind.API) {
            writer.print("      Function<");
            writer.print(streamType.getName());
            writer.print(", ");
            writer.print(this.genTranslatedTypeName(streamType));
            writer.print("> conv = ");
            writer.print(this.genTranslatedTypeName((TypeInfo)streamType.getRaw()));
            writer.println("::newInstance;");
            writer.print("      ");
            writer.print(rxName);
            writer.print(" = ");
            writer.print(rxType);
            writer.print("Helper.to");
            writer.print(rxType);
            writer.println("(delegate, conv);");
        } else if (streamType.isVariable()) {
            String typeVar = streamType.getSimpleName();
            writer.print("      Function<");
            writer.print(typeVar);
            writer.print(", ");
            writer.print(typeVar);
            writer.print("> conv = (Function<");
            writer.print(typeVar);
            writer.print(", ");
            writer.print(typeVar);
            writer.println(">) __typeArg_0.wrap;");
            writer.print("      ");
            writer.print(rxName);
            writer.print(" = ");
            writer.print(rxType);
            writer.print("Helper.to");
            writer.print(rxType);
            writer.println("(delegate, conv);");
        } else {
            writer.print("      ");
            writer.print(rxName);
            writer.print(" = ");
            writer.print(rxType);
            writer.print("Helper.to");
            writer.print(rxType);
            writer.println("(this.getDelegate());");
        }
        writer.println("    }");
        writer.print("    return ");
        writer.print(rxName);
        writer.println(";");
        writer.println("  }");
        writer.println();
    }

    protected void genToSubscriber(TypeInfo streamType, PrintWriter writer) {
        writer.format("  private WriteStreamObserver<%s> observer;%n", this.genTranslatedTypeName(streamType));
        writer.format("  private WriteStreamSubscriber<%s> subscriber;%n", this.genTranslatedTypeName(streamType));
        writer.println();
        this.genToXXXEr(streamType, "Observer", "observer", writer);
        this.genToXXXEr(streamType, "Subscriber", "subscriber", writer);
    }

    private void genToXXXEr(TypeInfo streamType, String rxType, String rxName, PrintWriter writer) {
        writer.format("  public synchronized WriteStream%s<%s> to%s() {%n", rxType, this.genTranslatedTypeName(streamType), rxType);
        writer.format("    if (%s == null) {%n", rxName);
        if (streamType.getKind() == ClassKind.API) {
            writer.format("      Function<%s, %s> conv = %s::getDelegate;%n", this.genTranslatedTypeName((TypeInfo)streamType.getRaw()), streamType.getName(), this.genTranslatedTypeName(streamType));
            writer.format("      %s = RxHelper.to%s(getDelegate(), conv);%n", rxName, rxType);
        } else if (streamType.isVariable()) {
            String typeVar = streamType.getSimpleName();
            writer.format("      Function<%s, %s> conv = (Function<%s, %s>) __typeArg_0.unwrap;%n", typeVar, typeVar, typeVar, typeVar);
            writer.format("      %s = RxHelper.to%s(getDelegate(), conv);%n", rxName, rxType);
        } else {
            writer.format("      %s = RxHelper.to%s(getDelegate());%n", rxName, rxType);
        }
        writer.println("    }");
        writer.format("    return %s;%n", rxName);
        writer.println("  }");
        writer.println();
    }

    protected void genMethods(ClassModel model, MethodInfo method, List<String> cacheDecls, PrintWriter writer) {
        this.genMethod(model, method, cacheDecls, writer);
        MethodInfo flowableOverload = this.genOverloadedMethod(method, Flowable.class);
        MethodInfo observableOverload = this.genOverloadedMethod(method, Observable.class);
        if (flowableOverload != null) {
            this.genMethod(model, flowableOverload, cacheDecls, writer);
        }
        if (observableOverload != null) {
            this.genMethod(model, observableOverload, cacheDecls, writer);
        }
    }

    protected void genRxMethod(ClassModel model, MethodInfo method, PrintWriter writer) {
        MethodInfo futMethod = this.genFutureMethod(method);
        ClassTypeInfo raw = futMethod.getReturnType().getRaw();
        String methodSimpleName = raw.getSimpleName();
        String adapterType = "AsyncResult" + methodSimpleName + ".to" + methodSimpleName;
        String rxType = raw.getName();
        this.startMethodTemplate(model.getType(), futMethod, "", writer);
        writer.println(" { ");
        writer.print("    return ");
        writer.print(adapterType);
        writer.println("(handler -> {");
        writer.print("      ");
        writer.print(method.getName());
        writer.print("(");
        List params = futMethod.getParams();
        writer.print(params.stream().map(ParamInfo::getName).collect(Collectors.joining(", ")));
        if (params.size() > 0) {
            writer.print(", ");
        }
        writer.println("handler);");
        writer.println("    });");
        writer.println("  }");
        writer.println();
    }

    protected void genReadStream(List<? extends TypeParamInfo> typeParams, PrintWriter writer) {
        writer.print("  Observable<");
        writer.print(typeParams.get(0).getName());
        writer.println("> toObservable();");
        writer.println();
        writer.print("  Flowable<");
        writer.print(typeParams.get(0).getName());
        writer.println("> toFlowable();");
        writer.println();
    }

    private MethodInfo genFutureMethod(MethodInfo method) {
        String futMethodName = this.genFutureMethodName(method);
        ArrayList<ParamInfo> futParams = new ArrayList<ParamInfo>();
        int size = method.getParams().size() - 1;
        for (int count = 0; count < size; ++count) {
            ParamInfo param = method.getParam(count);
            futParams.add(param);
        }
        ParamInfo futParam = method.getParam(size);
        TypeInfo futType = ((ParameterizedTypeInfo)((ParameterizedTypeInfo)futParam.getType()).getArg(0)).getArg(0);
        TypeInfo futUnresolvedType = ((ParameterizedTypeInfo)((ParameterizedTypeInfo)futParam.getUnresolvedType()).getArg(0)).getArg(0);
        Object futReturnType = futUnresolvedType.getKind() == ClassKind.VOID ? TypeReflectionFactory.create(Completable.class) : (futUnresolvedType.isNullable() ? new ParameterizedTypeInfo(TypeReflectionFactory.create(Maybe.class).getRaw(), false, Collections.singletonList(futType)) : new ParameterizedTypeInfo(TypeReflectionFactory.create(Single.class).getRaw(), false, Collections.singletonList(futType)));
        return method.copy().setName(futMethodName).setReturnType(futReturnType).setParams(futParams);
    }

    private MethodInfo genOverloadedMethod(MethodInfo method, Class streamType) {
        ArrayList<ParamInfo> params = null;
        int count = 0;
        for (ParamInfo param : method.getParams()) {
            if (param.getType().isParameterized() && param.getType().getRaw().getName().equals("io.vertx.core.streams.ReadStream")) {
                if (params == null) {
                    params = new ArrayList<ParamInfo>(method.getParams());
                }
                ParameterizedTypeInfo paramType = new ParameterizedTypeInfo(TypeReflectionFactory.create((Type)streamType).getRaw(), false, Collections.singletonList(((ParameterizedTypeInfo)param.getType()).getArg(0)));
                params.set(count, new ParamInfo(param.getIndex(), param.getName(), param.getDescription(), (TypeInfo)paramType));
            }
            ++count;
        }
        if (params != null) {
            return method.copy().setParams(params);
        }
        return null;
    }
}

