/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.http;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.core.MultiMap;
import io.vertx.reactivex.core.http.HttpConnection;
import io.vertx.reactivex.core.http.HttpFrame;
import io.vertx.reactivex.core.http.HttpServerFileUpload;
import io.vertx.reactivex.core.http.HttpServerResponse;
import io.vertx.reactivex.core.http.ServerWebSocket;
import io.vertx.reactivex.core.net.NetSocket;
import io.vertx.reactivex.core.net.SocketAddress;
import io.vertx.reactivex.core.streams.Pipe;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.reactivex.core.streams.WriteStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import java.util.function.Function;
import javax.net.ssl.SSLSession;

@RxGen(value=io.vertx.core.http.HttpServerRequest.class)
public class HttpServerRequest
implements ReadStream<io.vertx.reactivex.core.buffer.Buffer> {
    public static final TypeArg<HttpServerRequest> __TYPE_ARG = new TypeArg(obj -> new HttpServerRequest((io.vertx.core.http.HttpServerRequest)obj), HttpServerRequest::getDelegate);
    private final io.vertx.core.http.HttpServerRequest delegate;
    private Observable<io.vertx.reactivex.core.buffer.Buffer> observable;
    private Flowable<io.vertx.reactivex.core.buffer.Buffer> flowable;
    private HttpServerResponse cached_0;
    private MultiMap cached_1;
    private MultiMap cached_2;
    private SocketAddress cached_3;
    private SocketAddress cached_4;
    private NetSocket cached_5;
    private MultiMap cached_6;
    private HttpConnection cached_7;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpServerRequest that = (HttpServerRequest)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpServerRequest(io.vertx.core.http.HttpServerRequest delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.http.HttpServerRequest getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<io.vertx.reactivex.core.buffer.Buffer> toObservable() {
        if (this.observable == null) {
            Function<Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
            this.observable = ObservableHelper.toObservable(this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<io.vertx.reactivex.core.buffer.Buffer> toFlowable() {
        if (this.flowable == null) {
            Function<Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
            this.flowable = FlowableHelper.toFlowable(this.delegate, conv);
        }
        return this.flowable;
    }

    @Override
    public Pipe<io.vertx.reactivex.core.buffer.Buffer> pipe() {
        Pipe<io.vertx.reactivex.core.buffer.Buffer> ret = Pipe.newInstance(this.delegate.pipe(), io.vertx.reactivex.core.buffer.Buffer.__TYPE_ARG);
        return ret;
    }

    @Override
    public void pipeTo(WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) {
        this.delegate.pipeTo(dst.getDelegate());
    }

    @Override
    public void pipeTo(WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    public Completable rxPipeTo(WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) {
        return AsyncResultCompletable.toCompletable(handler -> this.pipeTo(dst, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpServerRequest handler(final Handler<io.vertx.reactivex.core.buffer.Buffer> handler) {
        this.delegate.handler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                handler.handle((Object)io.vertx.reactivex.core.buffer.Buffer.newInstance(event));
            }
        });
        return this;
    }

    public HttpServerRequest pause() {
        this.delegate.pause();
        return this;
    }

    public HttpServerRequest resume() {
        this.delegate.resume();
        return this;
    }

    public HttpServerRequest fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public HttpServerRequest endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public HttpVersion version() {
        HttpVersion ret = this.delegate.version();
        return ret;
    }

    public HttpMethod method() {
        HttpMethod ret = this.delegate.method();
        return ret;
    }

    public String rawMethod() {
        String ret = this.delegate.rawMethod();
        return ret;
    }

    public boolean isSSL() {
        boolean ret = this.delegate.isSSL();
        return ret;
    }

    public String scheme() {
        String ret = this.delegate.scheme();
        return ret;
    }

    public String uri() {
        String ret = this.delegate.uri();
        return ret;
    }

    public String path() {
        String ret = this.delegate.path();
        return ret;
    }

    public String query() {
        String ret = this.delegate.query();
        return ret;
    }

    public String host() {
        String ret = this.delegate.host();
        return ret;
    }

    public long bytesRead() {
        long ret = this.delegate.bytesRead();
        return ret;
    }

    public HttpServerResponse response() {
        HttpServerResponse ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = HttpServerResponse.newInstance(this.delegate.response());
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    public String getHeader(String headerName) {
        String ret = this.delegate.getHeader(headerName);
        return ret;
    }

    public MultiMap params() {
        MultiMap ret;
        if (this.cached_2 != null) {
            return this.cached_2;
        }
        this.cached_2 = ret = MultiMap.newInstance(this.delegate.params());
        return ret;
    }

    public String getParam(String paramName) {
        String ret = this.delegate.getParam(paramName);
        return ret;
    }

    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_3 != null) {
            return this.cached_3;
        }
        this.cached_3 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_4 != null) {
            return this.cached_4;
        }
        this.cached_4 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    public String absoluteURI() {
        String ret = this.delegate.absoluteURI();
        return ret;
    }

    public HttpServerRequest bodyHandler(final Handler<io.vertx.reactivex.core.buffer.Buffer> bodyHandler) {
        this.delegate.bodyHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                bodyHandler.handle((Object)io.vertx.reactivex.core.buffer.Buffer.newInstance(event));
            }
        });
        return this;
    }

    public NetSocket netSocket() {
        NetSocket ret;
        if (this.cached_5 != null) {
            return this.cached_5;
        }
        this.cached_5 = ret = NetSocket.newInstance(this.delegate.netSocket());
        return ret;
    }

    public HttpServerRequest setExpectMultipart(boolean expect) {
        this.delegate.setExpectMultipart(expect);
        return this;
    }

    public boolean isExpectMultipart() {
        boolean ret = this.delegate.isExpectMultipart();
        return ret;
    }

    public HttpServerRequest uploadHandler(final Handler<HttpServerFileUpload> uploadHandler) {
        this.delegate.uploadHandler((Handler)new Handler<io.vertx.core.http.HttpServerFileUpload>(){

            public void handle(io.vertx.core.http.HttpServerFileUpload event) {
                uploadHandler.handle((Object)HttpServerFileUpload.newInstance(event));
            }
        });
        return this;
    }

    public MultiMap formAttributes() {
        MultiMap ret;
        if (this.cached_6 != null) {
            return this.cached_6;
        }
        this.cached_6 = ret = MultiMap.newInstance(this.delegate.formAttributes());
        return ret;
    }

    public String getFormAttribute(String attributeName) {
        String ret = this.delegate.getFormAttribute(attributeName);
        return ret;
    }

    public ServerWebSocket upgrade() {
        ServerWebSocket ret = ServerWebSocket.newInstance(this.delegate.upgrade());
        return ret;
    }

    public boolean isEnded() {
        boolean ret = this.delegate.isEnded();
        return ret;
    }

    public HttpServerRequest customFrameHandler(final Handler<HttpFrame> handler) {
        this.delegate.customFrameHandler((Handler)new Handler<io.vertx.core.http.HttpFrame>(){

            public void handle(io.vertx.core.http.HttpFrame event) {
                handler.handle((Object)HttpFrame.newInstance(event));
            }
        });
        return this;
    }

    public HttpConnection connection() {
        HttpConnection ret;
        if (this.cached_7 != null) {
            return this.cached_7;
        }
        this.cached_7 = ret = HttpConnection.newInstance(this.delegate.connection());
        return ret;
    }

    public StreamPriority streamPriority() {
        StreamPriority ret = this.delegate.streamPriority();
        return ret;
    }

    public HttpServerRequest streamPriorityHandler(Handler<StreamPriority> handler) {
        this.delegate.streamPriorityHandler(handler);
        return this;
    }

    public String getHeader(CharSequence headerName) {
        String ret = this.delegate.getHeader(headerName);
        return ret;
    }

    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    public static HttpServerRequest newInstance(io.vertx.core.http.HttpServerRequest arg) {
        return arg != null ? new HttpServerRequest(arg) : null;
    }
}

