/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.amqpbridge;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.amqpbridge.AmqpBridgeOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.eventbus.MessageConsumer;
import io.vertx.reactivex.core.eventbus.MessageProducer;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;

@RxGen(value=io.vertx.amqpbridge.AmqpBridge.class)
public class AmqpBridge {
    public static final TypeArg<AmqpBridge> __TYPE_ARG = new TypeArg(obj -> new AmqpBridge((io.vertx.amqpbridge.AmqpBridge)obj), AmqpBridge::getDelegate);
    private final io.vertx.amqpbridge.AmqpBridge delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmqpBridge that = (AmqpBridge)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AmqpBridge(io.vertx.amqpbridge.AmqpBridge delegate) {
        this.delegate = delegate;
    }

    public io.vertx.amqpbridge.AmqpBridge getDelegate() {
        return this.delegate;
    }

    public static AmqpBridge create(io.vertx.reactivex.core.Vertx vertx) {
        AmqpBridge ret = AmqpBridge.newInstance(io.vertx.amqpbridge.AmqpBridge.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static AmqpBridge create(io.vertx.reactivex.core.Vertx vertx, AmqpBridgeOptions options) {
        AmqpBridge ret = AmqpBridge.newInstance(io.vertx.amqpbridge.AmqpBridge.create((Vertx)vertx.getDelegate(), (AmqpBridgeOptions)options));
        return ret;
    }

    public void start(String hostname, int port, String username, String password, final Handler<AsyncResult<AmqpBridge>> resultHandler) {
        this.delegate.start(hostname, port, username, password, (Handler)new Handler<AsyncResult<io.vertx.amqpbridge.AmqpBridge>>(){

            public void handle(AsyncResult<io.vertx.amqpbridge.AmqpBridge> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)AmqpBridge.newInstance((io.vertx.amqpbridge.AmqpBridge)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Single<AmqpBridge> rxStart(String hostname, int port, String username, String password) {
        return AsyncResultSingle.toSingle(handler -> this.start(hostname, port, username, password, (Handler<AsyncResult<AmqpBridge>>)handler));
    }

    public void start(String hostname, int port, final Handler<AsyncResult<AmqpBridge>> resultHandler) {
        this.delegate.start(hostname, port, (Handler)new Handler<AsyncResult<io.vertx.amqpbridge.AmqpBridge>>(){

            public void handle(AsyncResult<io.vertx.amqpbridge.AmqpBridge> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)AmqpBridge.newInstance((io.vertx.amqpbridge.AmqpBridge)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Single<AmqpBridge> rxStart(String hostname, int port) {
        return AsyncResultSingle.toSingle(handler -> this.start(hostname, port, (Handler<AsyncResult<AmqpBridge>>)handler));
    }

    public <T> MessageConsumer<T> createConsumer(String amqpAddress) {
        MessageConsumer ret = MessageConsumer.newInstance(this.delegate.createConsumer(amqpAddress), TypeArg.unknown());
        return ret;
    }

    public <T> MessageProducer<T> createProducer(String amqpAddress) {
        MessageProducer ret = MessageProducer.newInstance(this.delegate.createProducer(amqpAddress), TypeArg.unknown());
        return ret;
    }

    public void close(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.close(resultHandler);
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(handler -> this.close((Handler<AsyncResult<Void>>)handler));
    }

    public void endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
    }

    public static AmqpBridge newInstance(io.vertx.amqpbridge.AmqpBridge arg) {
        return arg != null ? new AmqpBridge(arg) : null;
    }
}

