/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex;

import io.reactivex.CompletableObserver;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import java.util.concurrent.atomic.AtomicBoolean;

public class CompletableHelper {
    public static <T> CompletableObserver toObserver(final Handler<AsyncResult<T>> handler) {
        final AtomicBoolean completed = new AtomicBoolean();
        return new CompletableObserver(){

            public void onSubscribe(@NonNull Disposable d) {
            }

            public void onComplete() {
                if (completed.compareAndSet(false, true)) {
                    handler.handle((Object)Future.succeededFuture());
                }
            }

            public void onSuccess() {
                if (completed.compareAndSet(false, true)) {
                    handler.handle((Object)Future.succeededFuture());
                }
            }

            public void onError(Throwable error) {
                if (completed.compareAndSet(false, true)) {
                    handler.handle((Object)Future.failedFuture((Throwable)error));
                }
            }
        };
    }
}

