/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.impl;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.processors.UnicastProcessor;
import io.vertx.core.streams.ReadStream;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class FlowableReadStream<T, U>
extends Flowable<U> {
    public static final long DEFAULT_MAX_BUFFER_SIZE = 256L;
    private final ReadStream<T> stream;
    private final Function<T, U> f;
    private final AtomicReference<UnicastProcessor<U>> processor = new AtomicReference();
    private final long highWaterMark;
    private final long lowWaterMark;
    private boolean subscribed;
    private long pending;
    private boolean paused;

    public FlowableReadStream(ReadStream<T> stream, long maxBufferSize, Function<T, U> f) {
        this.stream = stream;
        this.f = f;
        this.highWaterMark = maxBufferSize;
        this.lowWaterMark = maxBufferSize / 2L;
    }

    protected void subscribeActual(final Subscriber<? super U> subscriber) {
        final UnicastProcessor p = UnicastProcessor.create();
        if (!this.processor.compareAndSet(null, p)) {
            EmptySubscription.error((Throwable)new IllegalStateException("This processor allows only a single Subscriber"), subscriber);
            return;
        }
        p.subscribe(new FlowableSubscriber<U>(){

            public void onSubscribe(Subscription s) {
                final BasicIntQueueSubscription sub = (BasicIntQueueSubscription)s;
                BasicIntQueueSubscription basic = new BasicIntQueueSubscription<U>(){

                    public int requestFusion(int mode) {
                        return sub.requestFusion(mode);
                    }

                    public U poll() throws Exception {
                        return sub.poll();
                    }

                    public boolean isEmpty() {
                        return sub.isEmpty();
                    }

                    public void clear() {
                        sub.clear();
                    }

                    public void request(long n) {
                        if (p == FlowableReadStream.this.processor.get()) {
                            if (n == Long.MAX_VALUE) {
                                FlowableReadStream.this.pending = Long.MIN_VALUE;
                            } else {
                                FlowableReadStream.this.pending = FlowableReadStream.this.pending - n;
                            }
                            if (FlowableReadStream.this.subscribed && FlowableReadStream.this.paused && FlowableReadStream.this.pending < FlowableReadStream.this.lowWaterMark) {
                                FlowableReadStream.this.paused = false;
                                FlowableReadStream.this.stream.resume();
                            }
                            sub.request(n);
                        }
                    }

                    public void cancel() {
                        sub.cancel();
                        this.release();
                    }
                };
                FlowableReadStream.this.stream.endHandler(v -> p.onComplete());
                FlowableReadStream.this.stream.exceptionHandler(arg_0 -> ((UnicastProcessor)p).onError(arg_0));
                FlowableReadStream.this.stream.handler(item -> {
                    p.onNext(FlowableReadStream.this.f.apply(item));
                    if (++FlowableReadStream.this.pending >= FlowableReadStream.this.highWaterMark && !FlowableReadStream.this.paused) {
                        FlowableReadStream.this.paused = true;
                        FlowableReadStream.this.stream.pause();
                    }
                });
                subscriber.onSubscribe((Subscription)basic);
                FlowableReadStream.this.subscribed = true;
            }

            public void onNext(U t) {
                subscriber.onNext(t);
            }

            public void onError(Throwable t) {
                this.release();
                subscriber.onError(t);
            }

            public void onComplete() {
                this.release();
                subscriber.onComplete();
            }

            private void release() {
                FlowableReadStream.this.subscribed = false;
                FlowableReadStream.this.processor.set(null);
                FlowableReadStream.this.pending = 0L;
                try {
                    FlowableReadStream.this.stream.exceptionHandler(null);
                    FlowableReadStream.this.stream.endHandler(null);
                    FlowableReadStream.this.stream.handler(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (FlowableReadStream.this.paused) {
                    FlowableReadStream.this.paused = false;
                    FlowableReadStream.this.stream.resume();
                }
            }
        });
    }
}

