/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.json;

import com.fasterxml.jackson.core.type.TypeReference;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.MaybeTransformer;
import io.reactivex.annotations.NonNull;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;

public class MaybeUnmarshaller<T, B>
implements MaybeTransformer<B, T> {
    private final Function<B, Buffer> unwrap;
    private final Class<T> mappedType;
    private final TypeReference<T> mappedTypeRef;

    public MaybeUnmarshaller(Function<B, Buffer> unwrap, Class<T> mappedType) {
        this.unwrap = unwrap;
        this.mappedType = mappedType;
        this.mappedTypeRef = null;
    }

    public MaybeUnmarshaller(Function<B, Buffer> unwrap, TypeReference<T> mappedTypeRef) {
        this.unwrap = unwrap;
        this.mappedType = null;
        this.mappedTypeRef = mappedTypeRef;
    }

    public MaybeSource<T> apply(@NonNull Maybe<B> upstream) {
        Maybe unwrapped = upstream.map(this.unwrap::apply);
        Maybe unmarshalled = unwrapped.concatMap(buffer -> {
            if (buffer.length() > 0) {
                try {
                    Object obj = Objects.nonNull(this.mappedType) ? Json.mapper.readValue(buffer.getBytes(), this.mappedType) : Json.mapper.readValue(buffer.getBytes(), this.mappedTypeRef);
                    return Maybe.just((Object)obj);
                }
                catch (IOException e) {
                    return Maybe.error((Throwable)e);
                }
            }
            return Maybe.empty();
        });
        return unmarshalled;
    }
}

