/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.impl;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.util.concurrent.atomic.AtomicBoolean;

public class AsyncResultSingle<T>
extends Single<T> {
    private final Handler<Handler<AsyncResult<T>>> method;

    public AsyncResultSingle(Handler<Handler<AsyncResult<T>>> method) {
        this.method = method;
    }

    protected void subscribeActual(@NonNull SingleObserver<? super T> observer) {
        final AtomicBoolean disposed = new AtomicBoolean();
        observer.onSubscribe(new Disposable(){

            public void dispose() {
                disposed.set(true);
            }

            public boolean isDisposed() {
                return disposed.get();
            }
        });
        if (!disposed.get()) {
            this.method.handle(ar -> {
                if (!disposed.getAndSet(true)) {
                    if (ar.succeeded()) {
                        try {
                            observer.onSuccess(ar.result());
                        }
                        catch (Throwable throwable) {}
                    } else if (ar.failed()) {
                        try {
                            observer.onError(ar.cause());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }
}

