/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex;

import com.fasterxml.jackson.core.type.TypeReference;
import io.reactivex.Observable;
import io.reactivex.ObservableTransformer;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;
import io.vertx.reactivex.core.impl.ObservableReadStream;
import io.vertx.reactivex.core.impl.ReadStreamSubscriber;
import io.vertx.reactivex.core.json.ObservableUnmarshaller;
import java.util.function.Function;

public class ObservableHelper {
    public static <T> ReadStream<T> toReadStream(Observable<T> observable) {
        return ReadStreamSubscriber.asReadStream(observable, Function.identity());
    }

    public static <T> Observable<T> toObservable(ReadStream<T> stream) {
        return new ObservableReadStream(stream, Function.identity());
    }

    public static <T, U> Observable<U> toObservable(ReadStream<T> stream, Function<T, U> mapping) {
        return new ObservableReadStream<T, U>(stream, mapping);
    }

    public static <T> ObservableTransformer<Buffer, T> unmarshaller(Class<T> mappedType) {
        return new ObservableUnmarshaller(Function.identity(), mappedType);
    }

    public static <T> ObservableTransformer<Buffer, T> unmarshaller(TypeReference<T> mappedTypeRef) {
        return new ObservableUnmarshaller(Function.identity(), mappedTypeRef);
    }
}

