/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.reactivex;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import io.vertx.codegen.processor.ClassModel;
import io.vertx.codegen.processor.MethodInfo;
import io.vertx.codegen.processor.MethodKind;
import io.vertx.codegen.processor.ParamInfo;
import io.vertx.codegen.processor.TypeParamInfo;
import io.vertx.codegen.processor.type.ClassKind;
import io.vertx.codegen.processor.type.ClassTypeInfo;
import io.vertx.codegen.processor.type.ParameterizedTypeInfo;
import io.vertx.codegen.processor.type.TypeInfo;
import io.vertx.codegen.processor.type.TypeReflectionFactory;
import io.vertx.lang.rx.AbstractRxGenerator;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class RxJava2Generator
extends AbstractRxGenerator {
    RxJava2Generator() {
        super("reactivex");
        this.kinds = Collections.singleton("class");
        this.name = "RxJava2";
    }

    protected final void genMethods(ClassModel model, MethodInfo method, List<String> cacheDecls, boolean genBody, PrintWriter writer) {
        if (this.isStreamMethod(model, method)) {
            this.genStreamMethod(model, writer);
            return;
        }
        this.genMethod(model, method, cacheDecls, genBody, writer);
        MethodInfo overload = this.genOverloadedMethod(method);
        if (overload != null) {
            this.genMethod(model, overload, cacheDecls, genBody, writer);
        }
    }

    private void genMethod(ClassModel model, MethodInfo method, List<String> cacheDecls, boolean genBody, PrintWriter writer) {
        this.genSimpleMethod("public", model, method, cacheDecls, genBody, writer);
        if (method.getKind() == MethodKind.OTHER || method.getKind() == MethodKind.HANDLER) {
            return;
        }
        this.genRxMethod(model, method, cacheDecls, genBody, writer);
    }

    protected void genImports(ClassModel model, PrintWriter writer) {
        writer.println("import io.vertx.reactivex.RxHelper;");
        writer.println("import io.vertx.reactivex.ObservableHelper;");
        writer.println("import io.vertx.reactivex.FlowableHelper;");
        writer.println("import io.vertx.reactivex.impl.AsyncResultMaybe;");
        writer.println("import io.vertx.reactivex.impl.AsyncResultSingle;");
        writer.println("import io.vertx.reactivex.impl.AsyncResultCompletable;");
        writer.println("import io.vertx.reactivex.impl.AsyncResultFlowable;");
        writer.println("import io.vertx.reactivex.WriteStreamObserver;");
        writer.println("import io.vertx.reactivex.WriteStreamSubscriber;");
        super.genImports(model, writer);
    }

    protected void genToObservable(TypeInfo streamType, PrintWriter writer) {
        writer.print("  private io.reactivex.Observable<");
        writer.print(this.genTranslatedTypeName(streamType));
        writer.println("> observable;");
        writer.print("  private io.reactivex.Flowable<");
        writer.print(this.genTranslatedTypeName(streamType));
        writer.println("> flowable;");
        writer.println();
        this.genToXXXAble(streamType, "Observable", "observable", writer);
        this.genToXXXAble(streamType, "Flowable", "flowable", writer);
    }

    private void genToXXXAble(TypeInfo streamType, String rxType, String rxName, PrintWriter writer) {
        writer.print("  public synchronized ");
        writer.print("io.reactivex.");
        writer.print(rxType);
        writer.print("<");
        writer.print(this.genTranslatedTypeName(streamType));
        writer.print("> to");
        writer.print(rxType);
        writer.println("() {");
        writer.print("    ");
        writer.print("if (");
        writer.print(rxName);
        writer.println(" == null) {");
        if (streamType.getKind() == ClassKind.API) {
            writer.print("      Function<");
            writer.print(streamType.getName());
            writer.print(", ");
            writer.print(this.genTranslatedTypeName(streamType));
            writer.print("> conv = ");
            writer.print(this.genTranslatedTypeName((TypeInfo)streamType.getRaw()));
            writer.println("::newInstance;");
            writer.print("      ");
            writer.print(rxName);
            writer.print(" = ");
            writer.print(rxType);
            writer.print("Helper.to");
            writer.print(rxType);
            writer.println("(delegate, conv);");
        } else if (streamType.isVariable()) {
            String typeVar = streamType.getSimpleName();
            writer.print("      Function<");
            writer.print(typeVar);
            writer.print(", ");
            writer.print(typeVar);
            writer.print("> conv = (Function<");
            writer.print(typeVar);
            writer.print(", ");
            writer.print(typeVar);
            writer.println(">) __typeArg_0.wrap;");
            writer.print("      ");
            writer.print(rxName);
            writer.print(" = ");
            writer.print(rxType);
            writer.print("Helper.to");
            writer.print(rxType);
            writer.println("(delegate, conv);");
        } else {
            writer.print("      ");
            writer.print(rxName);
            writer.print(" = ");
            writer.print(rxType);
            writer.print("Helper.to");
            writer.print(rxType);
            writer.println("(this.getDelegate());");
        }
        writer.println("    }");
        writer.print("    return ");
        writer.print(rxName);
        writer.println(";");
        writer.println("  }");
        writer.println();
    }

    protected void genToSubscriber(TypeInfo streamType, PrintWriter writer) {
        writer.format("  private WriteStreamObserver<%s> observer;%n", this.genTranslatedTypeName(streamType));
        writer.format("  private WriteStreamSubscriber<%s> subscriber;%n", this.genTranslatedTypeName(streamType));
        writer.println();
        this.genToXXXEr(streamType, "Observer", "observer", writer);
        this.genToXXXEr(streamType, "Subscriber", "subscriber", writer);
    }

    private void genToXXXEr(TypeInfo streamType, String rxType, String rxName, PrintWriter writer) {
        writer.format("  public synchronized WriteStream%s<%s> to%s() {%n", rxType, this.genTranslatedTypeName(streamType), rxType);
        writer.format("    if (%s == null) {%n", rxName);
        if (streamType.getKind() == ClassKind.API) {
            writer.format("      Function<%s, %s> conv = %s::getDelegate;%n", this.genTranslatedTypeName((TypeInfo)streamType.getRaw()), streamType.getName(), this.genTranslatedTypeName(streamType));
            writer.format("      %s = RxHelper.to%s(getDelegate(), conv);%n", rxName, rxType);
        } else if (streamType.isVariable()) {
            String typeVar = streamType.getSimpleName();
            writer.format("      Function<%s, %s> conv = (Function<%s, %s>) __typeArg_0.unwrap;%n", typeVar, typeVar, typeVar, typeVar);
            writer.format("      %s = RxHelper.to%s(getDelegate(), conv);%n", rxName, rxType);
        } else {
            writer.format("      %s = RxHelper.to%s(getDelegate());%n", rxName, rxType);
        }
        writer.println("    }");
        writer.format("    return %s;%n", rxName);
        writer.println("  }");
        writer.println();
    }

    private void genRxMethod(ClassModel model, MethodInfo method, List<String> cacheDecls, boolean genBody, PrintWriter writer) {
        MethodInfo futMethod = this.genFutureMethod(method);
        ClassTypeInfo raw = futMethod.getReturnType().getRaw();
        String methodSimpleName = raw.getSimpleName();
        String adapterType = "AsyncResult" + methodSimpleName + ".to" + methodSimpleName;
        this.startMethodTemplate("public", model.getType(), futMethod, "", writer);
        if (genBody) {
            writer.println(" { ");
            writer.print("    return ");
            writer.print(adapterType);
            writer.println("($handler -> {");
            writer.print("      ");
            if (method.isStaticMethod()) {
                writer.print(this.genTranslatedTypeName((TypeInfo)model.getType()));
                writer.print(".");
            } else {
                writer.print("this.");
            }
            List typeParams = method.getTypeParams();
            if (typeParams.size() > 0) {
                writer.print(method.getTypeParams().stream().map(TypeParamInfo::getName).collect(Collectors.joining(", ", "<", ">")));
            }
            writer.print(method.getName());
            writer.print("(");
            List params = futMethod.getParams();
            writer.print(params.stream().map(ParamInfo::getName).collect(Collectors.joining(", ")));
            writer.print(")");
            if (methodSimpleName.equals("Flowable")) {
                TypeInfo arg = ((ParameterizedTypeInfo)futMethod.getReturnType()).getArg(0);
                writer.print(".map(stream_ -> (io.vertx.core.streams.ReadStream<" + arg.getName() + ">)stream_.getDelegate())");
            }
            writer.println(".onComplete($handler);");
            writer.println("    });");
            writer.println("  }");
        } else {
            writer.println(";");
        }
        writer.println();
    }

    protected void genReadStream(List<? extends TypeParamInfo> typeParams, PrintWriter writer) {
        writer.print("  io.reactivex.Observable<");
        writer.print(typeParams.get(0).getName());
        writer.println("> toObservable();");
        writer.println();
        writer.print("  io.reactivex.Flowable<");
        writer.print(typeParams.get(0).getName());
        writer.println("> toFlowable();");
        writer.println();
    }

    protected void genWriteStream(List<? extends TypeParamInfo> typeParams, PrintWriter writer) {
        writer.print("  WriteStreamObserver<");
        writer.print(typeParams.get(0).getName());
        writer.println("> toObserver();");
        writer.println();
        writer.print("  WriteStreamSubscriber<");
        writer.print(typeParams.get(0).getName());
        writer.println("> toSubscriber();");
        writer.println();
    }

    protected String genConvParam(TypeInfo type, MethodInfo method, String expr) {
        if (type.isParameterized() && (type.getRaw().getName().equals("io.reactivex.Flowable") || type.getRaw().getName().equals("io.reactivex.Observable"))) {
            ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
            String adapterFunction = "obj -> " + this.genConvParam(parameterizedType.getArg(0), method, "obj");
            return "io.vertx.reactivex.impl.ReadStreamSubscriber.asReadStream(" + expr + ", " + adapterFunction + ").resume()";
        }
        if (type.isParameterized() && type.getRaw().getName().equals("io.reactivex.Single")) {
            ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
            String adapterFunction = "obj -> " + this.genConvParam(parameterizedType.getArg(0), method, "obj");
            return "io.vertx.reactivex.SingleHelper.toFuture(" + expr + ", " + adapterFunction + ")";
        }
        if (type.isParameterized() && type.getRaw().getName().equals("io.reactivex.Maybe")) {
            ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
            String adapterFunction = "obj -> " + this.genConvParam(parameterizedType.getArg(0), method, "obj");
            return "io.vertx.reactivex.MaybeHelper.toFuture(" + expr + ", " + adapterFunction + ")";
        }
        if (type.getName().equals("io.reactivex.Completable")) {
            return "io.vertx.reactivex.CompletableHelper.toFuture(" + expr + ")";
        }
        if (type.isParameterized() && type.getRaw().getName().equals("io.reactivex.functions.Function")) {
            ParameterizedTypeInfo parameterizedTypeInfo = (ParameterizedTypeInfo)type;
            TypeInfo argType = parameterizedTypeInfo.getArg(0);
            TypeInfo retType = parameterizedTypeInfo.getArg(1);
            String argName = this.rewriteParamType(argType);
            String retName = this.rewriteParamType(retType);
            return "new Function<" + argName + "," + retName + ">() {\n      public " + retName + " apply(" + argName + " arg) {\n        " + this.genTranslatedTypeName(retType) + " ret;\n        try {\n          ret = " + expr + ".apply(" + this.genConvReturn(argType, method, "arg") + ");\n        } catch (Exception e) {\n          return io.vertx.core.Future.failedFuture(e);\n        }\n        return " + this.genConvParam(retType, method, "ret") + ";\n      }\n    }";
        }
        return super.genConvParam(type, method, expr);
    }

    private String rewriteParamType(TypeInfo type) {
        if (type.isParameterized()) {
            String rawTypeName = type.getRaw().getName();
            if (rawTypeName.equals("io.reactivex.Single") || rawTypeName.equals("io.reactivex.Maybe")) {
                ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)type;
                return "io.vertx.core.Future<" + super.genTypeName(parameterizedType.getArg(0)) + ">";
            }
        } else if (type.getName().equals("io.reactivex.Completable")) {
            return "io.vertx.core.Future<Void>";
        }
        return this.genTypeName(type);
    }

    private MethodInfo genFutureMethod(MethodInfo method) {
        Object futReturnType;
        String futMethodName = this.genFutureMethodName(method);
        ArrayList futParams = new ArrayList(method.getParams());
        TypeInfo futParam = method.getReturnType();
        TypeInfo futType = ((ParameterizedTypeInfo)futParam).getArg(0);
        if (futType.getKind() == ClassKind.API && futType.getRaw().getName().equals("io.vertx.core.streams.ReadStream")) {
            ParameterizedTypeInfo readStreamType = (ParameterizedTypeInfo)futType;
            futReturnType = new ParameterizedTypeInfo(TypeReflectionFactory.create(Flowable.class).getRaw(), false, Collections.singletonList(readStreamType.getArg(0)));
        } else {
            futReturnType = futType.getKind() == ClassKind.VOID ? TypeReflectionFactory.create(Completable.class) : (futType.isNullable() ? new ParameterizedTypeInfo(TypeReflectionFactory.create(Maybe.class).getRaw(), false, Collections.singletonList(futType)) : new ParameterizedTypeInfo(TypeReflectionFactory.create(Single.class).getRaw(), false, Collections.singletonList(futType)));
        }
        return method.copy().setName(futMethodName).setReturnType(futReturnType).setParams(futParams);
    }

    protected MethodInfo genOverloadedMethod(MethodInfo method) {
        ArrayList<ParamInfo> params = null;
        int count = 0;
        for (ParamInfo param : method.getParams()) {
            TypeInfo paramType = this.genOverloadedType(param.getType());
            if (paramType != param.getType()) {
                if (params == null) {
                    params = new ArrayList<ParamInfo>(method.getParams());
                }
                params.set(count, new ParamInfo(param.getIndex(), param.getName(), param.getDescription(), paramType));
            }
            ++count;
        }
        if (params != null) {
            return method.copy().setParams(params);
        }
        return null;
    }

    private TypeInfo genOverloadedType(TypeInfo type) {
        if (type.isParameterized() && type.getRaw().getName().equals("io.vertx.core.streams.ReadStream")) {
            return new ParameterizedTypeInfo(TypeReflectionFactory.create(Flowable.class).getRaw(), false, Collections.singletonList(((ParameterizedTypeInfo)type).getArg(0)));
        }
        if (type.getKind() == ClassKind.FUNCTION) {
            ParameterizedTypeInfo functionType = (ParameterizedTypeInfo)type;
            TypeInfo argType = this.genOverloadedType(functionType.getArg(0));
            TypeInfo retType = this.genOverloadedType(functionType.getArg(1));
            if (argType != functionType.getArg(0) || retType != functionType.getArg(1)) {
                return new ParameterizedTypeInfo(TypeReflectionFactory.create(Function.class).getRaw(), functionType.isNullable(), Arrays.asList(argType, retType));
            }
        } else if (type.getKind() == ClassKind.FUTURE) {
            TypeInfo futType = ((ParameterizedTypeInfo)type).getArg(0);
            if (futType.getKind() == ClassKind.VOID) {
                return TypeReflectionFactory.create(Completable.class);
            }
            if (futType.isNullable()) {
                return new ParameterizedTypeInfo(TypeReflectionFactory.create(Maybe.class).getRaw(), false, Collections.singletonList(futType));
            }
            return new ParameterizedTypeInfo(TypeReflectionFactory.create(Single.class).getRaw(), false, Collections.singletonList(futType));
        }
        return type;
    }
}

