/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.Single;
import io.reactivex.annotations.NonNull;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import io.vertx.core.json.jackson.JacksonFactory;
import java.util.Objects;
import java.util.function.Function;

public class ObservableUnmarshaller<T, B>
implements ObservableTransformer<B, T> {
    private final Function<B, Buffer> unwrap;
    private final Class<T> mappedType;
    private final TypeReference<T> mappedTypeRef;
    private ObjectCodec mapper;

    public ObservableUnmarshaller(Function<B, Buffer> unwrap, Class<T> mappedType) {
        this(unwrap, mappedType, null, null);
    }

    public ObservableUnmarshaller(Function<B, Buffer> unwrap, TypeReference<T> mappedTypeRef) {
        this(unwrap, null, mappedTypeRef, null);
    }

    public ObservableUnmarshaller(Function<B, Buffer> unwrap, Class<T> mappedType, ObjectCodec mapper) {
        this(unwrap, mappedType, null, mapper);
    }

    public ObservableUnmarshaller(Function<B, Buffer> unwrap, TypeReference<T> mappedTypeRef, ObjectCodec mapper) {
        this(unwrap, null, mappedTypeRef, mapper);
    }

    private ObservableUnmarshaller(Function<B, Buffer> unwrap, Class<T> mappedType, TypeReference<T> mappedTypeRef, ObjectCodec mapper) {
        this.unwrap = unwrap;
        this.mappedType = mappedType;
        this.mappedTypeRef = mappedTypeRef;
        this.mapper = mapper;
    }

    public ObservableSource<T> apply(@NonNull Observable<B> upstream) {
        Observable unwrapped = upstream.map(this.unwrap::apply);
        Single aggregated = unwrapped.collect(Buffer::buffer, Buffer::appendBuffer);
        Maybe unmarshalled = aggregated.toMaybe().concatMap(buffer -> {
            if (buffer.length() > 0) {
                try {
                    Object obj;
                    if (this.mapper != null) {
                        JsonParser parser = this.mapper.getFactory().createParser(buffer.getBytes());
                        obj = Objects.nonNull(this.mappedType) ? this.mapper.readValue(parser, this.mappedType) : this.mapper.readValue(parser, this.mappedTypeRef);
                    } else {
                        obj = ObservableUnmarshaller.getT(buffer, this.mappedType, this.mappedTypeRef);
                    }
                    return Maybe.just(obj);
                }
                catch (Exception e) {
                    return Maybe.error((Throwable)e);
                }
            }
            return Maybe.empty();
        });
        return unmarshalled.toObservable();
    }

    static <T> T getT(Buffer buffer, Class<T> mappedType, TypeReference<T> mappedTypeRef) {
        Object obj = Objects.nonNull(mappedType) ? Json.CODEC.fromBuffer(buffer, mappedType) : JacksonFactory.CODEC.fromBuffer(buffer, mappedTypeRef);
        return (T)obj;
    }
}

