/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.impl;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.plugins.RxJavaPlugins;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class AsyncResultCompletable
extends Completable {
    private final Consumer<Handler<AsyncResult<Void>>> subscriptionConsumer;

    public static Completable toCompletable(Consumer<Handler<AsyncResult<Void>>> subscriptionConsumer) {
        return RxJavaPlugins.onAssembly((Completable)new AsyncResultCompletable(subscriptionConsumer));
    }

    public AsyncResultCompletable(Consumer<Handler<AsyncResult<Void>>> subscriptionConsumer) {
        this.subscriptionConsumer = subscriptionConsumer;
    }

    protected void subscribeActual(CompletableObserver observer) {
        block5: {
            final AtomicBoolean disposed = new AtomicBoolean();
            observer.onSubscribe(new Disposable(){

                public void dispose() {
                    disposed.set(true);
                }

                public boolean isDisposed() {
                    return disposed.get();
                }
            });
            if (!disposed.get()) {
                try {
                    this.subscriptionConsumer.accept((Handler<AsyncResult<Void>>)((Handler)ar -> {
                        if (!disposed.getAndSet(true)) {
                            if (ar.succeeded()) {
                                try {
                                    observer.onComplete();
                                }
                                catch (Throwable throwable) {}
                            } else {
                                try {
                                    observer.onError(ar.cause());
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }
                    }));
                }
                catch (Exception e) {
                    if (disposed.getAndSet(true)) break block5;
                    try {
                        observer.onError((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

