/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.rx;

import io.vertx.codegen.annotations.ModuleGen;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.codegen.processor.ClassModel;
import io.vertx.codegen.processor.ConstantInfo;
import io.vertx.codegen.processor.Generator;
import io.vertx.codegen.processor.Helper;
import io.vertx.codegen.processor.MethodInfo;
import io.vertx.codegen.processor.ModuleInfo;
import io.vertx.codegen.processor.ParamInfo;
import io.vertx.codegen.processor.TypeArgExpression;
import io.vertx.codegen.processor.TypeParamInfo;
import io.vertx.codegen.processor.doc.Doc;
import io.vertx.codegen.processor.doc.Tag;
import io.vertx.codegen.processor.doc.Token;
import io.vertx.codegen.processor.type.ApiTypeInfo;
import io.vertx.codegen.processor.type.ClassKind;
import io.vertx.codegen.processor.type.ClassTypeInfo;
import io.vertx.codegen.processor.type.ParameterizedTypeInfo;
import io.vertx.codegen.processor.type.PrimitiveTypeInfo;
import io.vertx.codegen.processor.type.TypeInfo;
import io.vertx.codegen.processor.type.TypeNameTranslator;
import io.vertx.codegen.processor.type.TypeVariableInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;

public abstract class AbstractRxGenerator
extends Generator<ClassModel> {
    private final String id;
    private final TypeNameTranslator typeNameTranslator;
    private final Map<MethodInfo, Map<TypeInfo, String>> methodTypeArgMap = new HashMap<MethodInfo, Map<TypeInfo, String>>();

    public AbstractRxGenerator(String id) {
        this.id = id;
        this.typeNameTranslator = TypeNameTranslator.hierarchical((String)id);
        this.kinds = Collections.singleton("class");
    }

    public Collection<Class<? extends Annotation>> annotations() {
        return Arrays.asList(VertxGen.class, ModuleGen.class);
    }

    public String filename(ClassModel model) {
        ModuleInfo module = model.getModule();
        return module.translateQualifiedName(model.getFqn(), this.id) + ".java";
    }

    public String render(ClassModel model, int index, int size, Map<String, Object> session) {
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        this.methodTypeArgMap.clear();
        this.generateClass(model, writer);
        return sw.toString();
    }

    private void generateClass(ClassModel model, PrintWriter writer) {
        ClassTypeInfo type = model.getType();
        this.generateLicense(writer);
        writer.print("package ");
        writer.print(type.translatePackageName(this.id));
        writer.println(";");
        writer.println();
        this.genImports(model, writer);
        writer.println();
        this.generateDoc(model, writer);
        writer.println();
        writer.print("@RxGen(");
        writer.print(type.getName());
        writer.println(".class)");
        if (model.isDeprecated()) {
            writer.println("@Deprecated()");
        }
        writer.print("public ");
        if (model.isConcrete()) {
            writer.print("class");
        } else {
            writer.print("interface");
        }
        writer.print(" ");
        writer.print(Helper.getSimpleName((String)model.getIfaceFQCN()));
        if (model.isConcrete() && model.getConcreteSuperType() != null) {
            writer.print(" extends ");
            writer.print(this.genTranslatedTypeName(model.getConcreteSuperType()));
        }
        ArrayList<Object> interfaces = new ArrayList<Object>();
        interfaces.add("RxDelegate");
        for (TypeInfo typeInfo : model.getAbstractSuperTypes()) {
            interfaces.add(this.genTranslatedTypeName(typeInfo));
        }
        if (model.isHandler()) {
            interfaces.add("Handler<" + this.genTranslatedTypeName(model.getHandlerArg()) + ">");
        }
        if (model.isIterable()) {
            interfaces.add("Iterable<" + this.genTranslatedTypeName(model.getIterableArg()) + ">");
        }
        if (model.isIterator()) {
            interfaces.add("Iterator<" + this.genTranslatedTypeName(model.getIteratorArg()) + ">");
        }
        if (model.isFunction()) {
            TypeInfo[] functionArgs = model.getFunctionArgs();
            interfaces.add("Function<" + this.genTranslatedTypeName(functionArgs[0]) + ", " + this.genTranslatedTypeName(functionArgs[1]) + ">");
        }
        if (model.isSupplier()) {
            TypeInfo supplierArg = model.getSupplierArg();
            interfaces.add("Supplier<" + this.genTranslatedTypeName(supplierArg) + ">");
        }
        if (!interfaces.isEmpty()) {
            writer.print(interfaces.stream().collect(Collectors.joining(", ", model.isConcrete() ? " implements " : " extends ", "")));
        }
        writer.println(" {");
        writer.println();
        if (model.isConcrete()) {
            List methods = model.getMethods();
            if (methods.stream().noneMatch(it -> it.getParams().isEmpty() && "toString".equals(it.getName()))) {
                writer.println("  @Override");
                writer.println("  public String toString() {");
                writer.println("    return delegate.toString();");
                writer.println("  }");
                writer.println();
            }
            writer.println("  @Override");
            writer.println("  public boolean equals(Object o) {");
            writer.println("    if (this == o) return true;");
            writer.println("    if (o == null || getClass() != o.getClass()) return false;");
            writer.print("    ");
            writer.print(type.getSimpleName());
            writer.print(" that = (");
            writer.print(type.getSimpleName());
            writer.println(") o;");
            writer.println("    return delegate.equals(that.delegate);");
            writer.println("  }");
            writer.println("  ");
            writer.println("  @Override");
            writer.println("  public int hashCode() {");
            writer.println("    return delegate.hashCode();");
            writer.println("  }");
            writer.println();
            if (model.isIterable()) {
                this.generateIterableMethod(model, writer);
            }
            if (model.isIterator()) {
                this.generateIteratorMethods(model, writer);
            }
            if (model.isFunction()) {
                this.generateFunctionMethod(model, writer);
            }
            if (model.isSupplier()) {
                this.generateSupplierMethod(model, writer);
            }
            this.generateClassBody(model, model.getIfaceSimpleName(), writer);
        } else {
            writer.println("  @Override ");
            writer.print("  ");
            writer.print(type.getName());
            writer.println(" getDelegate();");
            writer.println();
            for (MethodInfo method : model.getMethods()) {
                this.genMethods(model, method, Collections.emptyList(), false, writer);
            }
            if (type.getRaw().getName().equals("io.vertx.core.streams.ReadStream")) {
                this.genReadStream(type.getParams(), writer);
            } else if (type.getRaw().getName().equals("io.vertx.core.streams.WriteStream")) {
                this.genWriteStream(type.getParams(), writer);
            }
        }
        writer.print("  public static ");
        if (!type.getParams().isEmpty()) {
            writer.print(this.genTypeParamsDecl(type));
            writer.print(" ");
        }
        writer.print(type.getSimpleName());
        writer.print(this.genTypeParamsDecl(type));
        writer.print(" newInstance(");
        writer.print(type.getName());
        writer.println(" arg) {");
        writer.print("    return arg != null ? new ");
        writer.print(type.getSimpleName());
        if (!model.isConcrete()) {
            writer.print("Impl");
        }
        writer.print(this.genTypeParamsDecl(type));
        writer.println("(arg) : null;");
        writer.println("  }");
        writer.println();
        if (!type.getParams().isEmpty()) {
            writer.print("  public static ");
            writer.print(this.genTypeParamsDecl(type));
            writer.print(" ");
            writer.print(type.getSimpleName());
            writer.print(this.genTypeParamsDecl(type));
            writer.print(" newInstance(");
            writer.print(type.getName());
            writer.print(" arg");
            for (TypeParamInfo typeParam : type.getParams()) {
                writer.print(", TypeArg<");
                writer.print(typeParam.getName());
                writer.print("> __typeArg_");
                writer.print(typeParam.getName());
            }
            writer.println(") {");
            writer.print("    return arg != null ? new ");
            writer.print(type.getSimpleName());
            if (!model.isConcrete()) {
                writer.print("Impl");
            }
            writer.print(this.genTypeParamsDecl(type));
            writer.print("(arg");
            for (TypeParamInfo typeParam : type.getParams()) {
                writer.print(", __typeArg_");
                writer.print(typeParam.getName());
            }
            writer.println(") : null;");
            writer.println("  }");
            writer.println();
        }
        writer.println("}");
        if (!model.isConcrete()) {
            writer.println();
            writer.print("class ");
            writer.print(type.getSimpleName());
            writer.print("Impl");
            writer.print(this.genTypeParamsDecl(type));
            writer.print(" implements ");
            writer.print(Helper.getSimpleName((String)model.getIfaceFQCN()));
            writer.println(" {");
            this.generateClassBody(model, type.getSimpleName() + "Impl", writer);
            writer.println("}");
        }
    }

    private void generateIterableMethod(ClassModel model, PrintWriter writer) {
        if (model.getMethods().stream().noneMatch(it -> it.getParams().isEmpty() && "iterator".equals(it.getName()))) {
            TypeInfo iterableArg = model.getIterableArg();
            writer.println("  @Override");
            writer.printf("  public Iterator<%s> iterator() {%n", this.genTranslatedTypeName(iterableArg));
            if (iterableArg.getKind() == ClassKind.API) {
                writer.format("    Function<%s, %s> conv = %s::newInstance;%n", iterableArg.getName(), this.genTranslatedTypeName((TypeInfo)iterableArg.getRaw()), this.genTranslatedTypeName(iterableArg));
                writer.println("    return new MappingIterator<>(delegate.iterator(), conv);");
            } else if (iterableArg.isVariable()) {
                String typeVar = iterableArg.getSimpleName();
                writer.format("    Function<%s, %s> conv = (Function<%s, %s>) __typeArg_0.wrap;%n", typeVar, typeVar, typeVar, typeVar);
                writer.println("    return new MappingIterator<>(delegate.iterator(), conv);");
            } else {
                writer.println("    return delegate.iterator();");
            }
            writer.println("  }");
            writer.println();
        }
    }

    private void generateIteratorMethods(ClassModel model, PrintWriter writer) {
        if (model.getMethods().stream().noneMatch(it -> it.getParams().isEmpty() && "hasNext".equals(it.getName()))) {
            writer.println("  @Override");
            writer.println("  public boolean hasNext() {");
            writer.println("    return delegate.hasNext();");
            writer.println("  }");
            writer.println();
        }
        if (model.getMethods().stream().noneMatch(it -> it.getParams().isEmpty() && "next".equals(it.getName()))) {
            TypeInfo iteratorArg = model.getIteratorArg();
            writer.println("  @Override");
            writer.printf("  public %s next() {%n", this.genTranslatedTypeName(iteratorArg));
            if (iteratorArg.getKind() == ClassKind.API) {
                writer.format("    return %s.newInstance(delegate.next());%n", this.genTranslatedTypeName(iteratorArg));
            } else if (iteratorArg.isVariable()) {
                writer.println("    return __typeArg_0.wrap(delegate.next());");
            } else {
                writer.println("    return delegate.next();");
            }
            writer.println("  }");
            writer.println();
        }
    }

    private void generateFunctionMethod(ClassModel model, PrintWriter writer) {
        if (model.getMethods().stream().noneMatch(it -> it.getParams().size() == 1 && "apply".equals(it.getName()))) {
            String typeVar;
            TypeInfo[] functionArgs = model.getFunctionArgs();
            TypeInfo inArg = functionArgs[0];
            TypeInfo outArg = functionArgs[1];
            writer.println("  @Override");
            writer.printf("  public %s apply(%s in) {%n", this.genTranslatedTypeName(outArg), this.genTranslatedTypeName(inArg));
            writer.printf("    %s ret;%n", outArg.getName());
            if (inArg.getKind() == ClassKind.API) {
                writer.println("    ret = getDelegate().apply(in.getDelegate());");
            } else if (inArg.isVariable()) {
                typeVar = inArg.getSimpleName();
                writer.format("    Function<%s, %s> inConv = (Function<%s, %s>) __typeArg_0.unwrap;%n", typeVar, typeVar, typeVar, typeVar);
                writer.println("    ret = getDelegate().apply(inConv.apply);");
            } else {
                writer.println("    ret = getDelegate().apply(in);");
            }
            if (outArg.getKind() == ClassKind.API) {
                writer.format("    Function<%s, %s> outConv = %s::newInstance;%n", outArg.getName(), this.genTranslatedTypeName((TypeInfo)outArg.getRaw()), this.genTranslatedTypeName(outArg));
                writer.println("    return outConv.apply(ret);");
            } else if (outArg.isVariable()) {
                typeVar = outArg.getSimpleName();
                writer.format("    Function<%s, %s> outConv = (Function<%s, %s>) __typeArg_1.wrap;%n", typeVar, typeVar, typeVar, typeVar);
                writer.println("    return outConv.apply(ret);");
            } else {
                writer.println("    return ret;");
            }
            writer.println("  }");
            writer.println();
        }
    }

    private void generateSupplierMethod(ClassModel model, PrintWriter writer) {
        throw new UnsupportedOperationException("Not implementet (yet)");
    }

    protected abstract void genReadStream(List<? extends TypeParamInfo> var1, PrintWriter var2);

    protected void genWriteStream(List<? extends TypeParamInfo> typeParams, PrintWriter writer) {
    }

    private void generateClassBody(ClassModel model, String constructor, PrintWriter writer) {
        ClassTypeInfo type = model.getType();
        String simpleName = type.getSimpleName();
        if (model.isConcrete()) {
            writer.print("  public static final TypeArg<");
            writer.print(simpleName);
            writer.print("> __TYPE_ARG = new TypeArg<>(");
            writer.print("    obj -> new ");
            writer.print(simpleName);
            writer.print("((");
            writer.print(type.getName());
            writer.println(") obj),");
            writer.print("    ");
            writer.print(simpleName);
            writer.println("::getDelegate");
            writer.println("  );");
            writer.println();
        }
        writer.print("  private final ");
        writer.print(Helper.getNonGenericType((String)model.getIfaceFQCN()));
        List typeParams = model.getTypeParams();
        if (!typeParams.isEmpty()) {
            writer.print(typeParams.stream().map(TypeParamInfo::getName).collect(Collectors.joining(",", "<", ">")));
        }
        writer.println(" delegate;");
        for (TypeParamInfo.Class typeParam : typeParams) {
            writer.print("  public final TypeArg<");
            writer.print(typeParam.getName());
            writer.print("> __typeArg_");
            writer.print(typeParam.getIndex());
            writer.println(";");
        }
        writer.println("  ");
        writer.print("  public ");
        writer.print(constructor);
        writer.print("(");
        writer.print(Helper.getNonGenericType((String)model.getIfaceFQCN()));
        writer.println(" delegate) {");
        if (model.isConcrete() && model.getConcreteSuperType() != null) {
            writer.println("    super(delegate);");
        }
        writer.println("    this.delegate = delegate;");
        for (TypeParamInfo.Class typeParam : typeParams) {
            writer.print("    this.__typeArg_");
            writer.print(typeParam.getIndex());
            writer.print(" = TypeArg.unknown();");
        }
        writer.println("  }");
        writer.println();
        writer.print("  public ");
        writer.print(constructor);
        writer.print("(Object delegate");
        for (TypeParamInfo.Class typeParam : typeParams) {
            writer.print(", TypeArg<");
            writer.print(typeParam.getName());
            writer.print("> typeArg_");
            writer.print(typeParam.getIndex());
        }
        writer.println(") {");
        if (model.isConcrete() && model.getConcreteSuperType() != null) {
            writer.print("    super((");
            writer.print(Helper.getNonGenericType((String)model.getIfaceFQCN()));
            writer.println(")delegate);");
        }
        writer.print("    this.delegate = (");
        writer.print(Helper.getNonGenericType((String)model.getIfaceFQCN()));
        writer.println(")delegate;");
        for (TypeParamInfo.Class typeParam : typeParams) {
            writer.print("    this.__typeArg_");
            writer.print(typeParam.getIndex());
            writer.print(" = typeArg_");
            writer.print(typeParam.getIndex());
            writer.println(";");
        }
        writer.println("  }");
        writer.println();
        writer.println("  @Override ");
        writer.print("  public ");
        writer.print(type.getName());
        writer.println(" getDelegate() {");
        writer.println("    return delegate;");
        writer.println("  }");
        writer.println();
        if (model.isReadStream()) {
            this.genToObservable(model.getReadStreamArg(), writer);
        }
        if (model.isWriteStream()) {
            this.genToSubscriber(model.getWriteStreamArg(), writer);
        }
        ArrayList methods = new ArrayList();
        methods.addAll(model.getMethods());
        methods.addAll(model.getAnyJavaTypeMethods());
        int count = 0;
        for (MethodInfo method : methods) {
            TypeInfo returnType = method.getReturnType();
            if (!(returnType instanceof ParameterizedTypeInfo)) continue;
            ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)returnType;
            List typeArgs = parameterizedType.getArgs();
            HashMap<TypeInfo, CallSite> typeArgMap = new HashMap<TypeInfo, CallSite>();
            for (TypeInfo typeArg : typeArgs) {
                if (typeArg.getKind() != ClassKind.API || this.containsTypeVariableArgument(typeArg)) continue;
                String typeArgRef = "TYPE_ARG_" + count++;
                typeArgMap.put(typeArg, (CallSite)((Object)typeArgRef));
                this.genTypeArgDecl(typeArg, method, typeArgRef, writer);
            }
            this.methodTypeArgMap.put(method, typeArgMap);
        }
        if (!this.methodTypeArgMap.isEmpty()) {
            writer.println();
        }
        ArrayList<String> cacheDecls = new ArrayList<String>();
        for (MethodInfo method : methods) {
            this.genMethods(model, method, cacheDecls, true, writer);
        }
        for (ConstantInfo constant : model.getConstants()) {
            this.genConstant(model, constant, writer);
        }
        for (String cacheDecl : cacheDecls) {
            writer.print("  ");
            writer.print(cacheDecl);
            writer.println(";");
        }
    }

    protected abstract void genToObservable(TypeInfo var1, PrintWriter var2);

    protected abstract void genToSubscriber(TypeInfo var1, PrintWriter var2);

    protected abstract void genMethods(ClassModel var1, MethodInfo var2, List<String> var3, boolean var4, PrintWriter var5);

    private void genConstant(ClassModel model, ConstantInfo constant, PrintWriter writer) {
        Doc doc = constant.getDoc();
        if (doc != null) {
            writer.println("  /**");
            Token.toHtml((List)doc.getTokens(), (String)"   *", this::renderLinkToHtml, (String)"\n", (PrintWriter)writer);
            writer.println("   */");
        }
        writer.print(model.isConcrete() ? "  public static final" : "");
        writer.format(" %s %s = %s;\n", this.genTranslatedTypeName(constant.getType()), constant.getName(), this.genConvReturn(constant.getType(), null, model.getType().getName() + "." + constant.getName()));
    }

    protected void startMethodTemplate(String visibility, ClassTypeInfo type, MethodInfo method, String deprecated, PrintWriter writer) {
        Doc doc = method.getDoc();
        if (doc != null) {
            writer.println("  /**");
            Token.toHtml((List)doc.getTokens(), (String)"   *", this::renderLinkToHtml, (String)"\n", (PrintWriter)writer);
            for (ParamInfo param : method.getParams()) {
                writer.print("   * @param ");
                writer.print(param.getName());
                writer.print(" ");
                if (param.getDescription() != null) {
                    Token.toHtml((List)param.getDescription().getTokens(), (String)"", this::renderLinkToHtml, (String)"", (PrintWriter)writer);
                }
                writer.println();
            }
            if (!method.getReturnType().getName().equals("void")) {
                writer.print("   * @return ");
                if (method.getReturnDescription() != null) {
                    Token.toHtml((List)method.getReturnDescription().getTokens(), (String)"", this::renderLinkToHtml, (String)"", (PrintWriter)writer);
                }
                writer.println();
            }
            if (deprecated != null && !deprecated.isEmpty()) {
                writer.print("   * @deprecated ");
                writer.println(deprecated);
            }
            writer.println("   */");
        }
        if (method.isDeprecated() || deprecated != null && !deprecated.isEmpty()) {
            writer.println("  @Deprecated()");
        }
        writer.print("  ");
        writer.print(visibility);
        writer.print(" ");
        if (method.isStaticMethod()) {
            writer.print("static ");
        }
        if (!method.getTypeParams().isEmpty()) {
            writer.print(method.getTypeParams().stream().map(TypeParamInfo::getName).collect(Collectors.joining(", ", "<", ">")));
            writer.print(" ");
        }
        writer.print(this.genReturnTypeDecl(method.getReturnType()));
        writer.print(" ");
        writer.print(method.getName());
        writer.print("(");
        writer.print(method.getParams().stream().map(it -> this.genParamTypeDecl(it.getType()) + " " + it.getName()).collect(Collectors.joining(", ")));
        writer.print(")");
    }

    protected boolean isImported(TypeInfo type) {
        switch (type.getKind()) {
            case JSON_OBJECT: 
            case JSON_ARRAY: 
            case HANDLER: 
            case LIST: 
            case SET: 
            case BOXED_PRIMITIVE: 
            case STRING: 
            case VOID: 
            case FUNCTION: 
            case SUPPLIER: {
                return true;
            }
        }
        return false;
    }

    protected final String genTranslatedTypeName(TypeInfo type) {
        return this.genTypeName(this.translateType(type));
    }

    protected String genTypeName(TypeInfo type) {
        return type.getName();
    }

    protected TypeInfo translateType(TypeInfo type) {
        if (type.isParameterized()) {
            ParameterizedTypeInfo parameterized = (ParameterizedTypeInfo)type;
            TypeInfo raw = this.translateType((TypeInfo)parameterized.getRaw());
            ArrayList<TypeInfo> args = parameterized.getArgs();
            if (raw != parameterized.getRaw()) {
                args = new ArrayList<TypeInfo>(args);
                for (int i = 0; i < args.size(); ++i) {
                    args.set(i, this.translateType((TypeInfo)args.get(i)));
                }
                return new ParameterizedTypeInfo((ClassTypeInfo)raw, parameterized.isNullable(), args);
            }
            for (int i = 0; i < args.size(); ++i) {
                TypeInfo arg = this.translateType((TypeInfo)args.get(i));
                if (arg == args.get(i)) continue;
                if (args == parameterized.getArgs()) {
                    args = new ArrayList(parameterized.getArgs());
                }
                args.set(i, arg);
            }
            if (args != parameterized.getArgs()) {
                return new ParameterizedTypeInfo((ClassTypeInfo)raw, parameterized.isNullable(), args);
            }
        } else if (type.getKind() == ClassKind.API) {
            ApiTypeInfo api = (ApiTypeInfo)type;
            return new ApiTypeInfo(api.translateName(this.id), api.isConcrete(), api.getParams(), api.getHandlerArg(), api.getModule(), api.isNullable(), api.isProxyGen(), api.getDataObject());
        }
        return type;
    }

    protected final void genSimpleMethod(String visibility, ClassModel model, MethodInfo method, List<String> cacheDecls, boolean genBody, PrintWriter writer) {
        ClassTypeInfo type = model.getType();
        this.startMethodTemplate(visibility, type, method, "", writer);
        if (genBody) {
            writer.println(" { ");
            if (method.isFluent()) {
                writer.print("    ");
                writer.print(this.genInvokeDelegate(model, method));
                writer.println(";");
                if (method.getReturnType().isVariable()) {
                    writer.print("    return (");
                    writer.print(method.getReturnType().getName());
                    writer.println(") this;");
                } else {
                    writer.println("    return this;");
                }
            } else if (method.getReturnType().getName().equals("void")) {
                writer.print("    ");
                writer.print(this.genInvokeDelegate(model, method));
                writer.println(";");
            } else {
                if (method.isCacheReturn()) {
                    writer.print("    if (cached_");
                    writer.print(cacheDecls.size());
                    writer.println(" != null) {");
                    writer.print("      return cached_");
                    writer.print(cacheDecls.size());
                    writer.println(";");
                    writer.println("    }");
                }
                TypeInfo returnType = method.getReturnType();
                String cachedType = method.getReturnType().getKind() == ClassKind.PRIMITIVE ? ((PrimitiveTypeInfo)returnType).getBoxed().getName() : this.genReturnTypeDecl(returnType);
                writer.print("    ");
                writer.print(this.genReturnTypeDecl(returnType));
                writer.print(" ret = ");
                writer.print(this.genConvReturn(returnType, method, this.genInvokeDelegate(model, method)));
                writer.println(";");
                if (method.isCacheReturn()) {
                    writer.print("    cached_");
                    writer.print(cacheDecls.size());
                    writer.println(" = ret;");
                    cacheDecls.add("private" + (method.isStaticMethod() ? " static" : "") + " " + cachedType + " cached_" + cacheDecls.size());
                }
                writer.println("    return ret;");
            }
            writer.println("  }");
        } else {
            writer.println(";");
        }
        writer.println();
    }

    private void generateDoc(ClassModel model, PrintWriter writer) {
        ClassTypeInfo type = model.getType();
        Doc doc = model.getDoc();
        if (doc != null) {
            writer.println("/**");
            Token.toHtml((List)doc.getTokens(), (String)" *", this::renderLinkToHtml, (String)"\n", (PrintWriter)writer);
            writer.println(" *");
            writer.println(" * <p>");
            writer.print(" * NOTE: This class has been automatically generated from the {@link ");
            writer.print(type.getName());
            writer.println(" original} non RX-ified interface using Vert.x codegen.");
            writer.println(" */");
        }
    }

    protected void genImports(ClassModel model, PrintWriter writer) {
        writer.println("import java.util.Map;");
        writer.println("import java.util.Set;");
        writer.println("import java.util.List;");
        writer.println("import java.util.Iterator;");
        writer.println("import java.util.function.Function;");
        writer.println("import java.util.function.Supplier;");
        writer.println("import java.util.stream.Collectors;");
        writer.println("import io.vertx.core.Handler;");
        writer.println("import io.vertx.core.AsyncResult;");
        writer.println("import io.vertx.core.json.JsonObject;");
        writer.println("import io.vertx.core.json.JsonArray;");
        writer.println("import io.vertx.lang.rx.RxDelegate;");
        writer.println("import io.vertx.lang.rx.RxGen;");
        writer.println("import io.vertx.lang.rx.TypeArg;");
        writer.println("import io.vertx.lang.rx.MappingIterator;");
    }

    protected final String genInvokeDelegate(ClassModel model, MethodInfo method) {
        StringBuilder ret = method.isStaticMethod() ? new StringBuilder(Helper.getNonGenericType((String)model.getIfaceFQCN())) : new StringBuilder("delegate");
        ret.append(".").append(method.getName()).append("(");
        int index = 0;
        for (ParamInfo param : method.getParams()) {
            if (index > 0) {
                ret.append(", ");
            }
            TypeInfo type = param.getType();
            ret.append(this.genConvParam(type, method, param.getName()));
            ++index;
        }
        ret.append(")");
        return ret.toString();
    }

    private boolean isSameType(TypeInfo type, MethodInfo method) {
        ClassKind kind = type.getKind();
        if (type.isDataObjectHolder() || kind.basic || kind.json || kind == ClassKind.ENUM || kind == ClassKind.OTHER || kind == ClassKind.THROWABLE || kind == ClassKind.VOID) {
            return true;
        }
        if (kind == ClassKind.OBJECT) {
            if (type.isVariable()) {
                return !this.isReified((TypeVariableInfo)type, method);
            }
            return true;
        }
        if (type.isParameterized()) {
            ParameterizedTypeInfo parameterizedTypeInfo = (ParameterizedTypeInfo)type;
            if (kind == ClassKind.LIST || kind == ClassKind.SET) {
                return this.isSameType(parameterizedTypeInfo.getArg(0), method);
            }
            if (kind == ClassKind.MAP) {
                return this.isSameType(parameterizedTypeInfo.getArg(1), method);
            }
            if (kind == ClassKind.HANDLER) {
                return this.isSameType(parameterizedTypeInfo.getArg(0), method);
            }
            if (kind == ClassKind.FUNCTION) {
                return this.isSameType(parameterizedTypeInfo.getArg(0), method) && this.isSameType(parameterizedTypeInfo.getArg(1), method);
            }
            if (kind == ClassKind.SUPPLIER) {
                return this.isSameType(parameterizedTypeInfo.getArg(0), method);
            }
        }
        return false;
    }

    protected String genParamTypeDecl(TypeInfo type) {
        return this.genTranslatedTypeName(type);
    }

    protected String genReturnTypeDecl(TypeInfo type) {
        return this.genTranslatedTypeName(type);
    }

    protected String genConvParam(TypeInfo type, MethodInfo method, String expr) {
        ClassKind kind = type.getKind();
        if (this.isSameType(type, method)) {
            return expr;
        }
        if (kind == ClassKind.OBJECT) {
            String typeArg;
            if (type.isVariable() && (typeArg = this.genTypeArg((TypeVariableInfo)type, method)) != null) {
                return typeArg + ".<" + type.getName() + ">unwrap(" + expr + ")";
            }
            return expr;
        }
        if (kind == ClassKind.API) {
            return expr + ".getDelegate()";
        }
        if (kind == ClassKind.CLASS_TYPE) {
            return "io.vertx.lang." + this.id + ".Helper.unwrap(" + expr + ")";
        }
        if (type.isParameterized()) {
            ParameterizedTypeInfo parameterizedTypeInfo = (ParameterizedTypeInfo)type;
            if (kind == ClassKind.HANDLER) {
                TypeInfo eventType = parameterizedTypeInfo.getArg(0);
                return "io.vertx.lang." + this.id + ".Helper.convertHandler(" + expr + ", event -> " + this.genConvReturn(eventType, method, "event") + ")";
            }
            if (kind == ClassKind.FUNCTION) {
                TypeInfo argType = parameterizedTypeInfo.getArg(0);
                TypeInfo retType = parameterizedTypeInfo.getArg(1);
                String argName = this.genTypeName(argType);
                String retName = this.genTypeName(retType);
                return "new Function<" + argName + "," + retName + ">() {\n      public " + retName + " apply(" + argName + " arg) {\n        " + this.genParamTypeDecl(retType) + " ret = " + expr + ".apply(" + this.genConvReturn(argType, method, "arg") + ");\n        return " + this.genConvParam(retType, method, "ret") + ";\n      }\n    }";
            }
            if (kind == ClassKind.SUPPLIER) {
                TypeInfo retType = parameterizedTypeInfo.getArg(0);
                String retName = this.genTypeName(retType);
                return "new Supplier<" + retName + ">() {\n      public " + retName + " get() {\n        " + this.genParamTypeDecl(retType) + " ret = " + expr + ".get();\n        return " + this.genConvParam(retType, method, "ret") + ";\n      }\n    }";
            }
            if (kind == ClassKind.LIST || kind == ClassKind.SET) {
                return expr + ".stream().map(elt -> " + this.genConvParam(parameterizedTypeInfo.getArg(0), method, "elt") + ").collect(Collectors.to" + type.getRaw().getSimpleName() + "())";
            }
            if (kind == ClassKind.MAP) {
                return expr + ".entrySet().stream().collect(Collectors.toMap(e -> e.getKey(), e -> " + this.genConvParam(parameterizedTypeInfo.getArg(1), method, "e.getValue()") + "))";
            }
            if (kind == ClassKind.FUTURE) {
                ParameterizedTypeInfo futureType = (ParameterizedTypeInfo)type;
                return expr + ".map(val -> " + this.genConvParam(futureType.getArg(0), method, "val") + ")";
            }
        }
        return expr;
    }

    private boolean isReified(TypeVariableInfo typeVar, MethodInfo method) {
        if (typeVar.isClassParam()) {
            return true;
        }
        TypeArgExpression typeArg = method.resolveTypeArg(typeVar);
        return typeArg != null && typeArg.isClassType();
    }

    private String genTypeArg(TypeVariableInfo typeVar, MethodInfo method) {
        if (typeVar.isClassParam()) {
            return "__typeArg_" + typeVar.getParam().getIndex();
        }
        TypeArgExpression typeArg = method.resolveTypeArg(typeVar);
        if (typeArg != null) {
            if (typeArg.isClassType()) {
                return "TypeArg.of(" + typeArg.getParam().getName() + ")";
            }
            if (!method.isStaticMethod()) {
                return typeArg.getParam().getName() + ".__typeArg_" + typeArg.getIndex();
            }
        }
        return null;
    }

    private void genTypeArgDecl(TypeInfo typeArg, MethodInfo method, String typeArgRef, PrintWriter writer) {
        StringBuilder sb = new StringBuilder();
        this.genTypeArg(typeArg, method, 1, sb);
        writer.print("  private static final TypeArg<");
        writer.print(this.translateName(typeArg));
        writer.print("> ");
        writer.print(typeArgRef);
        writer.print(" = ");
        writer.print(sb);
        writer.println(";");
    }

    private String translateName(TypeInfo type) {
        if (type instanceof ParameterizedTypeInfo) {
            ParameterizedTypeInfo pti = (ParameterizedTypeInfo)type;
            ClassTypeInfo raw = pti.getRaw();
            List args = pti.getArgs();
            StringBuilder buf = new StringBuilder(raw.translateName(this.typeNameTranslator)).append('<');
            for (int i = 0; i < args.size(); ++i) {
                TypeInfo typeArgument = (TypeInfo)args.get(i);
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(this.translateName(typeArgument));
            }
            buf.append('>');
            return buf.toString();
        }
        if (type instanceof ClassTypeInfo) {
            ClassTypeInfo cti = (ClassTypeInfo)type;
            String name = cti.getName();
            if (type.getKind() == ClassKind.API) {
                ModuleInfo module = cti.getModule();
                return module == null ? name : this.typeNameTranslator.translate(module, name);
            }
            return name;
        }
        return type.getName();
    }

    private void genTypeArg(TypeInfo arg, MethodInfo method, int depth, StringBuilder sb) {
        ClassKind argKind = arg.getKind();
        if (argKind == ClassKind.API) {
            sb.append("new TypeArg<").append(this.translateName(arg)).append(">(o").append(depth).append(" -> ");
            sb.append(arg.getRaw().translateName(this.id)).append(".newInstance((").append(arg.getRaw()).append(")o").append(depth);
            if (arg instanceof ParameterizedTypeInfo) {
                ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)arg;
                List args = parameterizedType.getArgs();
                for (int i = 0; i < args.size(); ++i) {
                    sb.append(", ");
                    this.genTypeArg((TypeInfo)args.get(i), method, depth + 1, sb);
                }
            }
            sb.append(")");
            sb.append(", o").append(depth).append(" -> o").append(depth).append(".getDelegate())");
        } else {
            String resolved;
            String typeArg = "TypeArg.unknown()";
            if (argKind == ClassKind.OBJECT && arg.isVariable() && (resolved = this.genTypeArg((TypeVariableInfo)arg, method)) != null) {
                typeArg = resolved;
            }
            sb.append(typeArg);
        }
    }

    private String genTypeArg(TypeInfo arg, MethodInfo method) {
        String typeArgRef;
        Map<TypeInfo, String> typeArgMap = this.methodTypeArgMap.get(method);
        if (typeArgMap != null && (typeArgRef = typeArgMap.get(arg)) != null) {
            return typeArgRef;
        }
        StringBuilder sb = new StringBuilder();
        this.genTypeArg(arg, method, 0, sb);
        return sb.toString();
    }

    protected String genConvReturn(TypeInfo type, MethodInfo method, String expr) {
        ClassKind kind = type.getKind();
        if (kind == ClassKind.OBJECT) {
            String typeArg;
            if (type.isVariable() && (typeArg = this.genTypeArg((TypeVariableInfo)type, method)) != null) {
                return "(" + type.getName() + ")" + typeArg + ".wrap(" + expr + ")";
            }
            return "(" + type.getSimpleName() + ") " + expr;
        }
        if (this.isSameType(type, method)) {
            return expr;
        }
        if (kind == ClassKind.API) {
            StringBuilder tmp = new StringBuilder(type.getRaw().translateName(this.id));
            tmp.append(".newInstance((");
            tmp.append(type.getRaw());
            tmp.append(")");
            tmp.append(expr);
            if (type.isParameterized()) {
                ParameterizedTypeInfo parameterizedTypeInfo = (ParameterizedTypeInfo)type;
                for (TypeInfo arg : parameterizedTypeInfo.getArgs()) {
                    tmp.append(", ");
                    tmp.append(this.genTypeArg(arg, method));
                }
            }
            tmp.append(")");
            return tmp.toString();
        }
        if (type.isParameterized()) {
            ParameterizedTypeInfo parameterizedTypeInfo = (ParameterizedTypeInfo)type;
            if (kind == ClassKind.HANDLER) {
                TypeInfo abc = parameterizedTypeInfo.getArg(0);
                return "new Handler<" + this.genParamTypeDecl(abc) + ">() {\n      public void handle(" + this.genParamTypeDecl(abc) + " event) {\n          " + expr + ".handle(" + this.genConvParam(abc, method, "event") + ");\n      }\n    }";
            }
            if (kind == ClassKind.LIST || kind == ClassKind.SET) {
                return expr + ".stream().map(elt -> " + this.genConvReturn(parameterizedTypeInfo.getArg(0), method, "elt") + ").collect(Collectors.to" + type.getRaw().getSimpleName() + "())";
            }
            if (kind == ClassKind.MAP) {
                return expr + ".entrySet().stream().collect(Collectors.toMap(_e -> _e.getKey(), _e -> " + this.genConvReturn(parameterizedTypeInfo.getArg(1), method, "_e.getValue()") + "))";
            }
            if (kind == ClassKind.FUTURE) {
                ParameterizedTypeInfo futureType = (ParameterizedTypeInfo)type;
                return expr + ".map(val -> " + this.genConvReturn(futureType.getArg(0), method, "val") + ")";
            }
        }
        return expr;
    }

    protected final String genFutureMethodName(MethodInfo method) {
        return "rx" + Character.toUpperCase(method.getName().charAt(0)) + method.getName().substring(1);
    }

    private String genTypeParamsDecl(ClassTypeInfo type) {
        if (!type.getParams().isEmpty()) {
            return type.getParams().stream().map(TypeParamInfo::getName).collect(Collectors.joining(",", "<", ">"));
        }
        return "";
    }

    private void generateLicense(PrintWriter writer) {
        writer.println("/*");
        writer.println(" * Copyright 2014 Red Hat, Inc.");
        writer.println(" *");
        writer.println(" * Red Hat licenses this file to you under the Apache License, version 2.0");
        writer.println(" * (the \"License\"); you may not use this file except in compliance with the");
        writer.println(" * License.  You may obtain a copy of the License at:");
        writer.println(" *");
        writer.println(" * http://www.apache.org/licenses/LICENSE-2.0");
        writer.println(" *");
        writer.println(" * Unless required by applicable law or agreed to in writing, software");
        writer.println(" * distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT");
        writer.println(" * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the");
        writer.println(" * License for the specific language governing permissions and limitations");
        writer.println(" * under the License.");
        writer.println(" */");
        writer.println();
    }

    private String renderLinkToHtml(Tag.Link link) {
        ClassTypeInfo rawType = link.getTargetType().getRaw();
        if (rawType.getModule() != null) {
            String label = link.getLabel().trim();
            if (rawType.getKind() == ClassKind.API) {
                Element elt = link.getTargetElement();
                String eltKind = elt.getKind().name();
                String ret = "{@link " + rawType.translateName(this.id);
                if ("METHOD".equals(eltKind)) {
                    ret = ret + "#" + elt.getSimpleName().toString();
                }
                if (!label.isEmpty()) {
                    ret = ret + " " + label;
                }
                ret = ret + "}";
                return ret;
            }
        }
        return "{@link " + rawType.getName() + "}";
    }

    private boolean containsTypeVariableArgument(TypeInfo type) {
        if (type.isVariable()) {
            return true;
        }
        if (type.isParameterized()) {
            List typeArgs = ((ParameterizedTypeInfo)type).getArgs();
            for (TypeInfo typeArg : typeArgs) {
                if (typeArg.isVariable()) {
                    return true;
                }
                if (!typeArg.isParameterized() || !this.containsTypeVariableArgument(typeArg)) continue;
                return true;
            }
        }
        return false;
    }
}

