/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisSentinelConnectOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.RedisConnectException;
import io.vertx.redis.client.impl.RedisConnectionManager;
import io.vertx.redis.client.impl.RedisURI;
import io.vertx.redis.client.impl.SentinelTopology;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

class SharedSentinelTopology {
    private static final Logger LOG = LoggerFactory.getLogger(SharedSentinelTopology.class);
    private final Vertx vertx;
    private final Supplier<Future<RedisSentinelConnectOptions>> connectOptions;
    private final RedisConnectionManager connectionManager;
    private final AtomicReference<Future<SentinelTopology>> topology = new AtomicReference();

    SharedSentinelTopology(Vertx vertx, Supplier<Future<RedisSentinelConnectOptions>> connectOptions, RedisConnectionManager connectionManager) {
        this.vertx = vertx;
        this.connectOptions = connectOptions;
        this.connectionManager = connectionManager;
    }

    Future<SentinelTopology> get() {
        Promise promise;
        Future future;
        do {
            Future<SentinelTopology> topology;
            if ((topology = this.topology.get()) == null) continue;
            return topology;
        } while (!this.topology.compareAndSet(null, (Future<SentinelTopology>)(future = (promise = Promise.promise()).future())));
        LOG.debug((Object)"Obtaining sentinel topology");
        this.connectOptions.get().onSuccess(opts -> this.getTopology((RedisSentinelConnectOptions)opts, 0, ConcurrentHashMap.newKeySet(), (Completable<SentinelTopology>)promise)).onFailure(arg_0 -> ((Promise)promise).fail(arg_0));
        return future;
    }

    private void getTopology(RedisSentinelConnectOptions connectOptions, int index, Set<Throwable> failures, Completable<SentinelTopology> onGotTopology) {
        List<String> endpoints = connectOptions.getEndpoints();
        if (index >= endpoints.size()) {
            StringBuilder message = new StringBuilder("Cannot connect to any of the provided endpoints");
            for (Throwable failure : failures) {
                message.append("\n- ").append(failure);
            }
            onGotTopology.fail((Throwable)new RedisConnectException(message.toString()));
            this.scheduleInvalidation(connectOptions);
            return;
        }
        RedisURI uri = new RedisURI(endpoints.get(index));
        this.connectionManager.getConnection(uri.baseUri(), null).onFailure(err -> {
            failures.add((Throwable)err);
            this.getTopology(connectOptions, index + 1, failures, onGotTopology);
        }).onSuccess(conn -> this.getTopology((RedisConnection)conn, uri, connectOptions.getMasterName()).onComplete(result -> {
            conn.close().onFailure(arg_0 -> ((Logger)LOG).warn(arg_0));
            if (result.failed()) {
                failures.add(result.cause());
                this.getTopology(connectOptions, index + 1, failures, onGotTopology);
            } else {
                SentinelTopology topology = (SentinelTopology)result.result();
                onGotTopology.succeed((Object)topology);
                this.scheduleInvalidation(connectOptions);
            }
        }));
    }

    private Future<SentinelTopology> getTopology(RedisConnection conn, RedisURI uri, String masterName) {
        return conn.batch(List.of(Request.cmd(Command.SENTINEL).arg("SENTINELS").arg(masterName), Request.cmd(Command.SENTINEL).arg("GET-MASTER-ADDR-BY-NAME").arg(masterName), Request.cmd(Command.SENTINEL).arg("SLAVES").arg(masterName))).compose(replies -> {
            if (replies == null || replies.size() != 3) {
                return Future.failedFuture((String)"Could not obtain sentinel topology");
            }
            ArrayList<RedisURI> sentinels = new ArrayList<RedisURI>();
            sentinels.add(uri);
            String failure = SharedSentinelTopology.parseUris(uri, (Response)replies.get(0), sentinels, "SENTINELS " + masterName);
            if (failure != null) {
                return Future.failedFuture((String)failure);
            }
            Response masterResponse = (Response)replies.get(1);
            if (masterResponse == null) {
                return Future.failedFuture((String)("Failed to get SENTINEL GET-MASTER-ADDR-BY-NAME " + masterName));
            }
            String ip = masterResponse.get(0).toString();
            Integer port = masterResponse.get(1).toInteger();
            RedisURI master = new RedisURI(uri, (String)(ip.contains(":") ? "[" + ip + "]" : ip), port);
            ArrayList<RedisURI> replicas = new ArrayList<RedisURI>();
            failure = SharedSentinelTopology.parseUris(uri, (Response)replies.get(2), replicas, "REPLICAS " + masterName);
            if (failure != null) {
                return Future.failedFuture((String)failure);
            }
            return Future.succeededFuture((Object)new SentinelTopology((RedisURI[])sentinels.toArray(RedisURI[]::new), master, (RedisURI[])replicas.toArray(RedisURI[]::new)));
        });
    }

    private static String parseUris(RedisURI uri, Response hostsResponse, List<RedisURI> uris, String command) {
        if (hostsResponse == null) {
            return "Failed to get SENTINEL " + command;
        }
        for (int i = 0; i < hostsResponse.size(); ++i) {
            Response hostResponse = hostsResponse.get(i);
            if (hostResponse.size() % 2 != 0) {
                return "Corrupted response " + i + " from SENTINEL " + command;
            }
            String ip = null;
            int port = 6379;
            if (hostResponse.containsKey("ip")) {
                ip = hostResponse.get("ip").toString();
            }
            if (hostResponse.containsKey("port")) {
                port = hostResponse.get("port").toInteger();
            }
            if (ip == null) {
                return "No IP found in response " + i + " from SENTINEL " + command;
            }
            Object host = ip.contains(":") ? "[" + ip + "]" : ip;
            uris.add(new RedisURI(uri, (String)host, port));
        }
        return null;
    }

    void invalidate() {
        this.topology.set(null);
    }

    private void scheduleInvalidation(RedisSentinelConnectOptions connectOptions) {
        this.vertx.setTimer(connectOptions.getTopologyCacheTTL(), ignored -> this.invalidate());
    }
}

