/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisCluster;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.RequestGrouping;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.CommandImpl;
import io.vertx.redis.client.impl.RedisClusterClient;
import io.vertx.redis.client.impl.RedisClusterConnection;
import io.vertx.redis.client.impl.RequestImpl;
import io.vertx.redis.client.impl.ZModem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class RedisClusterImpl
implements RedisCluster {
    private static final Logger LOG = LoggerFactory.getLogger(RedisClusterImpl.class);
    private final Redis client;
    private final RedisConnection connection;

    public RedisClusterImpl(Redis client) {
        if (!(client instanceof RedisClusterClient)) {
            throw new IllegalArgumentException("Given Redis client is not a Redis cluster client: " + String.valueOf(client));
        }
        this.client = client;
        this.connection = null;
    }

    public RedisClusterImpl(RedisConnection connection) {
        if (!(connection instanceof RedisClusterConnection)) {
            throw new IllegalArgumentException("Given Redis connection is not a Redis cluster connection: " + String.valueOf(connection));
        }
        this.client = null;
        this.connection = connection;
    }

    @Override
    public Future<List<Response>> onAllNodes(Request request) {
        return this.onAllNodes(request, false);
    }

    @Override
    public Future<List<Response>> onAllMasterNodes(Request request) {
        return this.onAllNodes(request, true);
    }

    private Future<List<Response>> onAllNodes(Request request, boolean mastersOnly) {
        if (this.connection != null) {
            return this.onAllNodes(request, mastersOnly, (RedisClusterConnection)this.connection);
        }
        return this.client.connect().compose(conn -> this.onAllNodes(request, mastersOnly, (RedisClusterConnection)conn).andThen(ignored -> conn.close().onFailure(arg_0 -> ((Logger)LOG).warn(arg_0))));
    }

    private Future<List<Response>> onAllNodes(Request request, boolean mastersOnly, RedisClusterConnection conn) {
        return conn.sharedSlots.get().compose(slots -> {
            String[] endpoints = mastersOnly ? slots.masterEndpoints() : slots.endpoints();
            HashSet endpointsSet = new HashSet(endpoints.length);
            Collections.addAll(endpointsSet, endpoints);
            String[] uniqueEndpoints = endpointsSet.toArray(new String[0]);
            PromiseInternal promise = conn.vertx.promise();
            this.onAllNodes(uniqueEndpoints, 0, request, new ArrayList<Response>(uniqueEndpoints.length), conn, (Completable<List<Response>>)promise);
            return promise.future();
        });
    }

    private void onAllNodes(String[] endpoints, int index, Request request, List<Response> result, RedisClusterConnection conn, Completable<List<Response>> promise) {
        if (index >= endpoints.length) {
            promise.succeed(result);
            return;
        }
        conn.send(endpoints[index], 16, request, (Completable<Response>)((Completable)(res, err) -> {
            if (err == null) {
                result.add((Response)res);
                this.onAllNodes(endpoints, index + 1, request, result, conn, promise);
            } else {
                promise.fail(err);
            }
        }));
    }

    @Override
    public Future<RequestGrouping> groupByNodes(List<Request> requests) {
        if (this.connection != null) {
            return this.groupByNodes(requests, (RedisClusterConnection)this.connection);
        }
        return this.client.connect().compose(conn -> this.groupByNodes(requests, (RedisClusterConnection)conn).andThen(ignored -> conn.close().onFailure(arg_0 -> ((Logger)LOG).warn(arg_0))));
    }

    private Future<RequestGrouping> groupByNodes(List<Request> requests, RedisClusterConnection conn) {
        return conn.sharedSlots.get().compose(slots -> {
            HashMap<String, List> grouping = new HashMap<String, List>();
            List<Request> ambiguous = null;
            for (Request request : requests) {
                RequestImpl req = (RequestImpl)request;
                CommandImpl cmd = (CommandImpl)req.command();
                List<byte[]> keys = req.keys();
                if (cmd.needsGetKeys() || keys.isEmpty()) {
                    if (ambiguous == null) {
                        ambiguous = new ArrayList<Request>();
                    }
                    ambiguous.add(request);
                    continue;
                }
                if (keys.size() == 1) {
                    int slot = ZModem.generate(keys.get(0));
                    String endpoint = slots.endpointsForKey(slot)[0];
                    grouping.computeIfAbsent(endpoint, ignored -> new ArrayList()).add(request);
                    continue;
                }
                String endpoint = null;
                for (byte[] key : keys) {
                    int slot = ZModem.generate(key);
                    String endpointForSlot = slots.endpointsForKey(slot)[0];
                    if (endpoint == null) {
                        endpoint = endpointForSlot;
                        continue;
                    }
                    if (endpointForSlot.equals(endpoint)) continue;
                    return Future.failedFuture((String)conn.buildCrossslotFailureMsg(req));
                }
                grouping.computeIfAbsent(endpoint, ignored -> new ArrayList()).add(request);
            }
            return Future.succeededFuture((Object)new RequestGrouping(grouping.values(), ambiguous != null ? ambiguous : Collections.emptyList()));
        });
    }
}

