/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.core.json.JsonObject;
import io.vertx.redis.client.RedisClusterConnectOptions;
import io.vertx.redis.client.RedisClusterTransactions;
import io.vertx.redis.client.RedisReplicas;
import java.util.Map;

public class RedisClusterConnectOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, RedisClusterConnectOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "useReplicas": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUseReplicas(RedisReplicas.valueOf((String)member.getValue()));
                    break;
                }
                case "hashSlotCacheTTL": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setHashSlotCacheTTL(((Number)member.getValue()).longValue());
                    break;
                }
                case "clusterTransactions": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setClusterTransactions(RedisClusterTransactions.valueOf((String)member.getValue()));
                }
            }
        }
    }

    static void toJson(RedisClusterConnectOptions obj, JsonObject json) {
        RedisClusterConnectOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(RedisClusterConnectOptions obj, Map<String, Object> json) {
        if (obj.getUseReplicas() != null) {
            json.put("useReplicas", obj.getUseReplicas().name());
        }
        json.put("hashSlotCacheTTL", obj.getHashSlotCacheTTL());
        if (obj.getClusterTransactions() != null) {
            json.put("clusterTransactions", obj.getClusterTransactions().name());
        }
    }
}

