/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.Future;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.RedisRole;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.ResponseType;
import io.vertx.redis.client.impl.PooledRedisConnection;
import io.vertx.redis.client.impl.RedisSentinelConnection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

class SentinelFailover {
    private static final Logger LOG = LoggerFactory.getLogger(SentinelFailover.class);
    private static final int RETRIES = 3;
    private final String masterSetName;
    private final Function<RedisRole, Future<PooledRedisConnection>> connectionFactory;
    private final AtomicReference<PooledRedisConnection> sentinelConnection = new AtomicReference();
    private final Set<RedisSentinelConnection> masterConnections = ConcurrentHashMap.newKeySet();

    SentinelFailover(String masterSetName, Function<RedisRole, Future<PooledRedisConnection>> connectionFactory) {
        this.masterSetName = masterSetName;
        this.connectionFactory = connectionFactory;
    }

    void start() {
        this.start(3);
    }

    private void start(int retries) {
        this.connectionFactory.apply(RedisRole.SENTINEL).onFailure(t -> {
            if (retries == 0) {
                LOG.error((Object)("Failed to obtain a connection to Redis sentinel, automatic failover will not work: " + t));
            } else {
                this.start(retries - 1);
            }
        }).onSuccess(sentinel -> {
            PooledRedisConnection old = this.sentinelConnection.getAndSet((PooledRedisConnection)sentinel);
            if (old != null) {
                old.close().onFailure(err -> LOG.warn((Object)("Failed to close connection: " + err)));
            }
            sentinel.handler(msg -> {
                if (msg.type() == ResponseType.PUSH && "message".equalsIgnoreCase(msg.get(0).toString()) && msg.get(2).toString().startsWith(this.masterSetName + " ")) {
                    this.reconnectAll();
                }
            });
            sentinel.exceptionHandler(t -> {
                sentinel.close();
                this.start(3);
            });
            sentinel.send(Request.cmd(Command.SUBSCRIBE).arg("+switch-master")).onFailure(t -> {
                sentinel.close();
                if (retries == 0) {
                    LOG.error((Object)("Failed to subscribe +switch-master on Redis sentinel connection, reconnection to new master on failover will not work: " + t));
                } else {
                    this.start(retries - 1);
                }
            });
        });
    }

    private void reconnectAll() {
        for (RedisSentinelConnection connection : this.masterConnections) {
            connection.closeDelegate().recover(ignored -> Future.succeededFuture()).compose(ignored -> this.connectionFactory.apply(RedisRole.MASTER)).onSuccess(connection::reconnect).onFailure(t -> LOG.error((Object)("Failed to reconnect to master after failover: " + t)));
        }
    }

    void addConnection(RedisSentinelConnection sentinelConn) {
        this.masterConnections.add(sentinelConn);
    }

    void removeConnection(RedisSentinelConnection sentinelConn) {
        this.masterConnections.remove(sentinelConn);
    }

    void close() {
        PooledRedisConnection sentinelConnection = this.sentinelConnection.get();
        if (sentinelConnection != null) {
            sentinelConnection.close().onFailure(err -> LOG.warn((Object)("Failed to close connection: " + err)));
        }
    }
}

