/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.PooledRedisConnection;
import io.vertx.redis.client.impl.SentinelFailover;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class RedisSentinelConnection
implements RedisConnection {
    private final AtomicReference<PooledRedisConnection> connection;
    private final SentinelFailover failover;

    public RedisSentinelConnection(PooledRedisConnection connection, SentinelFailover failover) {
        this.connection = new AtomicReference<PooledRedisConnection>(connection);
        this.failover = failover;
        failover.addConnection(this);
    }

    void reconnect(PooledRedisConnection newConnection) {
        this.connection.set(newConnection);
    }

    @Override
    public RedisConnection exceptionHandler(Handler<Throwable> handler) {
        this.connection.get().exceptionHandler((Handler)handler);
        return this;
    }

    @Override
    public RedisConnection handler(Handler<Response> handler) {
        this.connection.get().handler((Handler)handler);
        return this;
    }

    @Override
    public RedisConnection pause() {
        this.connection.get().pause();
        return this;
    }

    @Override
    public RedisConnection resume() {
        this.connection.get().resume();
        return this;
    }

    @Override
    public RedisConnection fetch(long amount) {
        this.connection.get().fetch(amount);
        return this;
    }

    @Override
    public RedisConnection endHandler(@Nullable Handler<Void> endHandler) {
        this.connection.get().endHandler((Handler)endHandler);
        return this;
    }

    @Override
    public Future<@Nullable Response> send(Request command) {
        return this.connection.get().send(command);
    }

    @Override
    public Future<List<@Nullable Response>> batch(List<Request> commands) {
        return this.connection.get().batch(commands);
    }

    Future<Void> closeDelegate() {
        return this.connection.get().close();
    }

    @Override
    public Future<Void> close() {
        this.failover.removeConnection(this);
        return this.closeDelegate();
    }

    @Override
    public boolean pendingQueueFull() {
        return this.connection.get().pendingQueueFull();
    }
}

