/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl.types;

import io.vertx.redis.client.Response;
import io.vertx.redis.client.ResponseType;
import io.vertx.redis.client.impl.types.Multi;
import io.vertx.redis.client.impl.types.SimpleStringType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class MultiType
implements Multi {
    public static final MultiType EMPTY_MULTI = new MultiType(0, false);
    public static final MultiType EMPTY_MAP = new MultiType(0, true);
    private final Map<String, Response> map;
    private final Response[] multi;
    private final int size;
    private int count;
    private String key;

    public static MultiType create(long length, boolean asMap) {
        if (asMap) {
            return new MultiType((int)length * 2, true);
        }
        return new MultiType((int)length, false);
    }

    private MultiType(int size, boolean asMap) {
        if (asMap) {
            this.multi = null;
            this.map = new HashMap<String, Response>(size, 1.0f);
        } else {
            this.multi = new Response[size];
            this.map = null;
        }
        this.size = size;
        this.count = 0;
    }

    private MultiType(String key, Response value) {
        this.map = null;
        this.multi = new Response[]{SimpleStringType.create(key), value};
        this.size = 2;
    }

    @Override
    public ResponseType type() {
        return ResponseType.MULTI;
    }

    @Override
    public void add(Response reply) {
        block6: {
            block7: {
                if (this.map == null) break block6;
                if (this.count % 2 != 0) break block7;
                if (reply == null || reply.type() == null) {
                    throw new IllegalArgumentException("Map key is NULL or untyped");
                }
                switch (reply.type()) {
                    case BULK: 
                    case SIMPLE: {
                        this.key = reply.toString();
                        break block6;
                    }
                    default: {
                        throw new IllegalArgumentException("Map key is not BULK or SIMPLE");
                    }
                }
            }
            if (this.key != null) {
                this.map.put(this.key, reply);
            }
            this.key = null;
        }
        if (this.multi != null) {
            this.multi[this.count] = reply;
        }
        ++this.count;
    }

    @Override
    public boolean complete() {
        return this.count == this.size;
    }

    @Override
    public Response get(int index) {
        if (this.multi != null) {
            return this.multi[index];
        }
        throw new RuntimeException("Multi is a Map");
    }

    @Override
    public Response get(String key) {
        if (this.map != null) {
            return this.map.get(key);
        }
        if (this.multi != null && this.multi.length % 2 == 0) {
            for (int i = 0; i < this.multi.length; i += 2) {
                if (!key.equals(this.multi[i].toString())) continue;
                return this.multi[i + 1];
            }
            return null;
        }
        throw new RuntimeException("Number of key is not even can't handle as Map");
    }

    @Override
    public boolean containsKey(String key) {
        if (this.map != null) {
            return this.map.containsKey(key);
        }
        if (this.multi != null && this.multi.length % 2 == 0) {
            for (int i = 0; i < this.multi.length; i += 2) {
                if (!key.equals(this.multi[i].toString())) continue;
                return true;
            }
            return false;
        }
        throw new RuntimeException("Number of key is not even can't handle as Map");
    }

    @Override
    public Set<String> getKeys() {
        if (this.map != null) {
            return this.map.keySet();
        }
        if (this.multi != null && this.multi.length % 2 == 0) {
            HashSet<String> keys = new HashSet<String>();
            for (int i = 0; i < this.multi.length; i += 2) {
                switch (this.multi[i].type()) {
                    case BULK: 
                    case SIMPLE: {
                        keys.add(this.multi[i].toString());
                    }
                }
            }
            return keys;
        }
        throw new RuntimeException("Number of key is not even can't handle as Map");
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String toString() {
        boolean more;
        StringBuilder sb = new StringBuilder();
        if (this.multi != null) {
            sb.append('[');
            more = false;
            for (Response r : this.multi) {
                if (more) {
                    sb.append(", ");
                }
                if (r == null) {
                    sb.append("null");
                } else {
                    sb.append(r.toString());
                }
                more = true;
            }
            sb.append(']');
        }
        if (this.map != null) {
            sb.append('{');
            more = false;
            for (Map.Entry entry : this.map.entrySet()) {
                if (more) {
                    sb.append(", ");
                }
                sb.append((String)entry.getKey());
                sb.append(": ");
                sb.append(((Response)entry.getValue()).toString());
                more = true;
            }
            sb.append('}');
        }
        return sb.toString();
    }

    @Override
    public Iterator<Response> iterator() {
        if (this.multi != null) {
            return new Iterator<Response>(){
                private int idx = 0;

                @Override
                public boolean hasNext() {
                    return this.idx < MultiType.this.size;
                }

                @Override
                public Response next() {
                    return MultiType.this.multi[this.idx++];
                }
            };
        }
        if (this.map != null) {
            return new Iterator<Response>(){
                private final Iterator<Map.Entry<String, Response>> it;
                {
                    this.it = MultiType.this.map.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public Response next() {
                    Map.Entry<String, Response> kv = this.it.next();
                    return new MultiType(kv.getKey(), kv.getValue());
                }
            };
        }
        throw new UnsupportedOperationException("Cannot iterator over NULL");
    }
}

