/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.redis.client.Command;
import io.vertx.redis.client.impl.RequestImpl;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class KeyExtractor {
    static final byte[] STREAMS_UPPER_CASE = "STREAMS".getBytes(StandardCharsets.UTF_8);
    static final byte[] STREAMS_LOWER_CASE = "streams".getBytes(StandardCharsets.UTF_8);
    static final byte[] KEYS_UPPER_CASE = "KEYS".getBytes(StandardCharsets.UTF_8);
    static final byte[] KEYS_LOWER_CASE = "keys".getBytes(StandardCharsets.UTF_8);
    static final byte[] STORE_UPPER_CASE = "STORE".getBytes(StandardCharsets.UTF_8);
    static final byte[] STORE_LOWER_CASE = "store".getBytes(StandardCharsets.UTF_8);
    static final byte[] STOREDIST_UPPER_CASE = "STOREDIST".getBytes(StandardCharsets.UTF_8);
    static final byte[] STOREDIST_LOWER_CASE = "storedist".getBytes(StandardCharsets.UTF_8);
    private static final byte ZERO = 48;
    private static final byte HYPHEN = 45;
    private static final byte DOLLAR = 36;

    KeyExtractor() {
    }

    static byte[][] extractMovableKeys(RequestImpl req) {
        int keysStartIndex;
        int keyCount;
        List<byte[]> args = Collections.unmodifiableList(req.getArgs());
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        if (req.command().equals(Command.EVAL) || req.command().equals(Command.EVALSHA)) {
            keyCount = Integer.parseInt(new String(args.get(1)));
            keysStartIndex = 2;
            keys.addAll(args.subList(2, 2 + keyCount));
        }
        if (req.command().equals(Command.GEORADIUS) || req.command().equals(Command.GEORADIUS_RO) || req.command().equals(Command.GEORADIUSBYMEMBER) || req.command().equals(Command.GEORADIUSBYMEMBER_RO)) {
            keys.add(args.get(0));
            if (!KeyExtractor.addKeyAfterKeywordIfPresent(args, keys, STORE_LOWER_CASE)) {
                KeyExtractor.addKeyAfterKeywordIfPresent(args, keys, STORE_UPPER_CASE);
            }
            if (!KeyExtractor.addKeyAfterKeywordIfPresent(args, keys, STOREDIST_LOWER_CASE)) {
                KeyExtractor.addKeyAfterKeywordIfPresent(args, keys, STOREDIST_UPPER_CASE);
            }
        }
        if (req.command().equals(Command.SORT)) {
            keys.add(args.get(0));
            if (!KeyExtractor.addKeyAfterKeywordIfPresent(args, keys, STORE_LOWER_CASE)) {
                KeyExtractor.addKeyAfterKeywordIfPresent(args, keys, STORE_UPPER_CASE);
            }
        }
        if (req.command().equals(Command.MIGRATE)) {
            int keysKeywordIndex = KeyExtractor.getIndexOfArgContainsKeyword(args, KEYS_UPPER_CASE);
            if (keysKeywordIndex == -1) {
                keysKeywordIndex = KeyExtractor.getIndexOfArgContainsKeyword(args, KEYS_LOWER_CASE);
            }
            if (keysKeywordIndex > -1) {
                keys.addAll(args.subList(keysKeywordIndex + 1, args.size()));
            } else {
                keys.add(args.get(2));
            }
        }
        if (req.command().equals(Command.XREAD) || req.command().equals(Command.XREADGROUP)) {
            int streamsKeywordIndex = KeyExtractor.getIndexOfArgContainsKeyword(args, STREAMS_UPPER_CASE);
            if (streamsKeywordIndex == -1) {
                streamsKeywordIndex = KeyExtractor.getIndexOfArgContainsKeyword(args, STREAMS_LOWER_CASE);
            }
            List<byte[]> argsAfterStreamsKeyword = args.subList(streamsKeywordIndex + 1, args.size());
            for (byte[] arg : argsAfterStreamsKeyword) {
                if (!(KeyExtractor.isArgEqualsSign(arg, (byte)36) || KeyExtractor.isArgEqualsSign(arg, (byte)48) || KeyExtractor.isArgContainsSign(arg, (byte)45))) {
                    keys.add(arg);
                    continue;
                }
                if (!KeyExtractor.isArgContainsSign(arg, (byte)45)) continue;
                String mayId = new String(arg, StandardCharsets.UTF_8);
                String[] millisAndSequence = mayId.split("-");
                try {
                    Long.parseLong(millisAndSequence[0]);
                    Long.parseLong(millisAndSequence[1]);
                }
                catch (NumberFormatException e) {
                    keys.add(arg);
                }
            }
        }
        if (req.command().equals(Command.ZINTERSTORE) || req.command().equals(Command.ZUNIONSTORE)) {
            keyCount = Integer.parseInt(new String(args.get(1)));
            keys.add(args.get(0));
            keysStartIndex = 2;
            keys.addAll(args.subList(2, 2 + keyCount));
        }
        return (byte[][])keys.toArray((T[])new byte[keys.size()][]);
    }

    private static boolean addKeyAfterKeywordIfPresent(List<byte[]> args, List<byte[]> keys, byte[] keyword) {
        int keywordIndex = KeyExtractor.getIndexOfArgContainsKeyword(args, keyword);
        if (keywordIndex > -1) {
            keys.add(args.get(keywordIndex + 1));
            return true;
        }
        return false;
    }

    private static int getIndexOfArgContainsKeyword(List<byte[]> args, byte[] keyword) {
        int keywordIndex = -1;
        for (int i = 0; i < args.size(); ++i) {
            if (!Arrays.equals(args.get(i), keyword)) continue;
            keywordIndex = i;
            break;
        }
        return keywordIndex;
    }

    private static boolean isArgContainsSign(byte[] arg, byte sign) {
        for (byte argByte : arg) {
            if (argByte != sign) continue;
            return true;
        }
        return false;
    }

    private static boolean isArgEqualsSign(byte[] arg, byte sign) {
        return arg.length == 1 && arg[0] == sign;
    }
}

