/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.SocketChannel;
import io.vertx.pgclient.impl.codec.Bind;
import io.vertx.pgclient.impl.codec.CloseConnectionCommandCodec;
import io.vertx.pgclient.impl.codec.ClosePortalCommandCodec;
import io.vertx.pgclient.impl.codec.ClosePortalMessage;
import io.vertx.pgclient.impl.codec.ClosePreparedStatementMessage;
import io.vertx.pgclient.impl.codec.CloseStatementCommandCodec;
import io.vertx.pgclient.impl.codec.DataType;
import io.vertx.pgclient.impl.codec.DataTypeCodec;
import io.vertx.pgclient.impl.codec.DataTypeEstimator;
import io.vertx.pgclient.impl.codec.Describe;
import io.vertx.pgclient.impl.codec.ExecuteMessage;
import io.vertx.pgclient.impl.codec.ExtendedQueryCommandCodec;
import io.vertx.pgclient.impl.codec.InitCommandCodec;
import io.vertx.pgclient.impl.codec.ParseMessage;
import io.vertx.pgclient.impl.codec.PasswordMessage;
import io.vertx.pgclient.impl.codec.PgCodec;
import io.vertx.pgclient.impl.codec.PgColumnDesc;
import io.vertx.pgclient.impl.codec.PgCommandCodec;
import io.vertx.pgclient.impl.codec.PrepareStatementCommandCodec;
import io.vertx.pgclient.impl.codec.Query;
import io.vertx.pgclient.impl.codec.ScramClientFinalMessage;
import io.vertx.pgclient.impl.codec.ScramClientInitialMessage;
import io.vertx.pgclient.impl.codec.SimpleQueryCodec;
import io.vertx.pgclient.impl.codec.StartupMessage;
import io.vertx.pgclient.impl.codec.SyncMessage;
import io.vertx.pgclient.impl.codec.TerminateMessage;
import io.vertx.pgclient.impl.util.Util;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.HexSequence;
import io.vertx.sqlclient.internal.command.CloseConnectionCommand;
import io.vertx.sqlclient.internal.command.CloseCursorCommand;
import io.vertx.sqlclient.internal.command.CloseStatementCommand;
import io.vertx.sqlclient.internal.command.CommandBase;
import io.vertx.sqlclient.internal.command.ExtendedQueryCommand;
import io.vertx.sqlclient.internal.command.InitCommand;
import io.vertx.sqlclient.internal.command.PrepareStatementCommand;
import io.vertx.sqlclient.internal.command.SimpleQueryCommand;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;

final class PgEncoder
extends ChannelOutboundHandlerAdapter {
    private static final byte PASSWORD_MESSAGE = 112;
    private static final byte QUERY = 81;
    private static final byte TERMINATE = 88;
    private static final byte PARSE = 80;
    private static final byte BIND = 66;
    private static final byte DESCRIBE = 68;
    private static final byte EXECUTE = 69;
    private static final byte CLOSE = 67;
    private static final byte SYNC = 83;
    private final PgCodec codec;
    final boolean useLayer7Proxy;
    private ChannelHandlerContext ctx;
    private final HexSequence psSeq = new HexSequence();
    boolean closeSent;
    private ArrayList<Object> pendingMessages = new ArrayList();
    private int capacityEstimate = 0;

    PgEncoder(boolean useLayer7Proxy, PgCodec codec) {
        this.useLayer7Proxy = useLayer7Proxy;
        this.codec = codec;
    }

    private void enqueueMessage(Object msg, int estimate) {
        this.pendingMessages.add(msg);
        this.capacityEstimate += estimate;
    }

    private void enqueueMessage(Object msg, Object p1, int estimate) {
        this.pendingMessages.add(msg);
        this.pendingMessages.add(p1);
        this.capacityEstimate += estimate;
    }

    private void enqueueMessage(Object msg, Object p1, Object p2, int estimate) {
        this.pendingMessages.add(msg);
        this.pendingMessages.add(p1);
        this.pendingMessages.add(p2);
        this.capacityEstimate += estimate;
    }

    private void enqueueMessage(Object msg, Object p1, Object p2, Object p3, int estimate) {
        this.pendingMessages.add(msg);
        this.pendingMessages.add(p1);
        this.pendingMessages.add(p2);
        this.pendingMessages.add(p3);
        this.capacityEstimate += estimate;
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        if (!this.closeSent) {
            CloseConnectionCommand cmd = CloseConnectionCommand.INSTANCE;
            PgCommandCodec<?, ?> codec = this.wrap((CommandBase<?>)cmd);
            codec.encode(this);
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.pendingMessages.clear();
        this.capacityEstimate = 0;
    }

    void write(CommandBase<?> cmd) {
        PgCommandCodec<?, ?> cmdCodec = this.wrap(cmd);
        if (this.codec.add(cmdCodec)) {
            cmdCodec.encode(this);
        }
    }

    private PgCommandCodec<?, ?> wrap(CommandBase<?> cmd) {
        if (cmd instanceof InitCommand) {
            return new InitCommandCodec((InitCommand)cmd);
        }
        if (cmd instanceof SimpleQueryCommand) {
            return new SimpleQueryCodec((SimpleQueryCommand)cmd);
        }
        if (cmd instanceof ExtendedQueryCommand) {
            return new ExtendedQueryCommandCodec((ExtendedQueryCommand)cmd);
        }
        if (cmd instanceof PrepareStatementCommand) {
            return new PrepareStatementCommandCodec((PrepareStatementCommand)cmd);
        }
        if (cmd instanceof CloseConnectionCommand) {
            return CloseConnectionCommandCodec.INSTANCE;
        }
        if (cmd instanceof CloseCursorCommand) {
            return new ClosePortalCommandCodec((CloseCursorCommand)cmd);
        }
        if (cmd instanceof CloseStatementCommand) {
            return new CloseStatementCommandCodec((CloseStatementCommand)cmd);
        }
        throw new AssertionError();
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof CommandBase) {
            CommandBase cmd = (CommandBase)msg;
            this.write(cmd);
        } else {
            super.write(ctx, msg, promise);
        }
    }

    public void flush(ChannelHandlerContext ctx) {
        this.flush();
    }

    private ByteBuf renderPendingMessages() {
        if (this.pendingMessages.isEmpty()) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf out = this.ctx.alloc().ioBuffer(this.capacityEstimate);
        int index = 0;
        int size = this.pendingMessages.size();
        while (index < size) {
            String portal;
            Object msg;
            if ((msg = this.pendingMessages.get(index++)).getClass() == SyncMessage.class) {
                PgEncoder.renderSync(out);
                continue;
            }
            if (msg.getClass() == TerminateMessage.class) {
                PgEncoder.renderTerminate(out);
                continue;
            }
            if (msg.getClass() == ClosePortalMessage.class) {
                portal = (String)this.pendingMessages.get(index++);
                PgEncoder.renderClosePortal(portal, out);
                continue;
            }
            if (msg.getClass() == ClosePreparedStatementMessage.class) {
                byte[] statementName = (byte[])this.pendingMessages.get(index++);
                PgEncoder.renderClosePreparedStatement(statementName, out);
                continue;
            }
            if (msg.getClass() == StartupMessage.class) {
                PgEncoder.renderStartupMessage((StartupMessage)msg, out);
                continue;
            }
            if (msg.getClass() == PasswordMessage.class) {
                PgEncoder.renderPasswordMessage((PasswordMessage)msg, out);
                continue;
            }
            if (msg.getClass() == ScramClientInitialMessage.class) {
                PgEncoder.renderScramInitialMessage((ScramClientInitialMessage)msg, out);
                continue;
            }
            if (msg.getClass() == ScramClientFinalMessage.class) {
                PgEncoder.renderScramFinalMessage((ScramClientFinalMessage)msg, out);
                continue;
            }
            if (msg.getClass() == Query.class) {
                PgEncoder.renderQueryMessage((Query)msg, out);
                continue;
            }
            if (msg.getClass() == Describe.class) {
                PgEncoder.renderDescribe((Describe)msg, out);
                continue;
            }
            if (msg.getClass() == ParseMessage.class) {
                String sql = (String)this.pendingMessages.get(index++);
                byte[] statement = (byte[])this.pendingMessages.get(index++);
                DataType[] parameterTypes = (DataType[])this.pendingMessages.get(index++);
                PgEncoder.renderParse(sql, statement, parameterTypes, out);
                continue;
            }
            if (msg.getClass() == ExecuteMessage.class) {
                portal = (String)this.pendingMessages.get(index++);
                int rowCount = (Integer)this.pendingMessages.get(index++);
                PgEncoder.renderExecute(portal, rowCount, out);
                continue;
            }
            if (msg.getClass() == Bind.class) {
                portal = (String)this.pendingMessages.get(index++);
                Tuple paramValues = (Tuple)this.pendingMessages.get(index++);
                PgEncoder.renderBind((Bind)msg, portal, paramValues, out);
                continue;
            }
            throw new AssertionError();
        }
        this.pendingMessages.clear();
        this.capacityEstimate = 0;
        return out;
    }

    private static void renderQueryMessage(Query query, ByteBuf out) {
        int pos = out.writerIndex();
        out.writeByte(81);
        out.writeInt(0);
        Util.writeCStringUTF8(out, query.sql);
        out.setInt(pos + 1, out.writerIndex() - pos - 1);
    }

    private static int estimateQueryMessage(Query query) {
        return 5 + DataTypeEstimator.estimateCStringUTF8(query.sql);
    }

    private static void renderPasswordMessage(PasswordMessage msg, ByteBuf out) {
        int pos = out.writerIndex();
        out.writeByte(112);
        out.writeInt(0);
        Util.writeCStringUTF8(out, msg.hash);
        out.setInt(pos + 1, out.writerIndex() - pos - 1);
    }

    private static int estimatePasswordMessage(PasswordMessage msg) {
        return 5 + DataTypeEstimator.estimateCStringUTF8(msg.hash);
    }

    private static void renderStartupMessage(StartupMessage msg, ByteBuf out) {
        int pos = out.writerIndex();
        out.writeInt(0);
        out.writeShort(3);
        out.writeShort(0);
        Util.writeCString(out, StartupMessage.BUFF_USER);
        Util.writeCStringUTF8(out, msg.username);
        Util.writeCString(out, StartupMessage.BUFF_DATABASE);
        Util.writeCStringUTF8(out, msg.database);
        for (Map.Entry<String, String> property : msg.properties.entrySet()) {
            Util.writeCString(out, property.getKey(), StandardCharsets.UTF_8);
            Util.writeCString(out, property.getValue(), StandardCharsets.UTF_8);
        }
        out.writeByte(0);
        out.setInt(pos, out.writerIndex() - pos);
    }

    private static int estimateStartupMessage(StartupMessage msg) {
        int length = 13 + DataTypeEstimator.estimateCStringUTF8(msg.username) + 9 + DataTypeEstimator.estimateCStringUTF8(msg.database);
        for (Map.Entry<String, String> property : msg.properties.entrySet()) {
            length += DataTypeEstimator.estimateCStringUTF8(property.getKey());
            length += DataTypeEstimator.estimateCStringUTF8(property.getValue());
        }
        return ++length;
    }

    private static void renderScramInitialMessage(ScramClientInitialMessage msg, ByteBuf out) {
        out.writeByte(112);
        int totalLengthPosition = out.writerIndex();
        out.writeInt(0);
        Util.writeCStringUTF8(out, msg.mechanism);
        int msgPosition = out.writerIndex();
        out.writeInt(0);
        out.writeCharSequence((CharSequence)msg.message, StandardCharsets.UTF_8);
        out.setInt(msgPosition, out.writerIndex() - msgPosition - 4);
        out.setInt(totalLengthPosition, out.writerIndex() - totalLengthPosition);
    }

    private static int estimateScramInitialMessage(ScramClientInitialMessage msg) {
        return 5 + DataTypeEstimator.estimateCStringUTF8(msg.mechanism) + 4 + DataTypeEstimator.estimateUTF8(msg.message);
    }

    private static void renderScramFinalMessage(ScramClientFinalMessage msg, ByteBuf out) {
        out.writeByte(112);
        int totalLengthPosition = out.writerIndex();
        out.writeInt(0);
        out.writeCharSequence((CharSequence)msg.message, StandardCharsets.UTF_8);
        out.setInt(totalLengthPosition, out.writerIndex() - totalLengthPosition);
    }

    private static int estimateScramFinalMessage(ScramClientFinalMessage msg) {
        return 5 + DataTypeEstimator.estimateUTF8(msg.message);
    }

    private static void renderClosePreparedStatement(byte[] statementName, ByteBuf out) {
        int pos = out.writerIndex();
        out.writeByte(67);
        out.writeInt(0);
        out.writeByte(83);
        out.writeBytes(statementName);
        out.setInt(pos + 1, out.writerIndex() - pos - 1);
    }

    private static int estimateClosePreparedStatement(byte[] statementName) {
        return 6 + DataTypeEstimator.estimateByteArray(statementName);
    }

    private static void renderTerminate(ByteBuf out) {
        out.writeByte(88);
        out.writeInt(4);
    }

    private static int estimateTerminate() {
        return 5;
    }

    private static void renderSync(ByteBuf out) {
        out.writeByte(83);
        out.writeInt(4);
    }

    private static int estimateSync() {
        return 5;
    }

    private static void renderExecute(String portal, int rowCount, ByteBuf out) {
        int pos = out.writerIndex();
        out.writeByte(69);
        out.writeInt(0);
        if (portal != null) {
            out.writeCharSequence((CharSequence)portal, StandardCharsets.UTF_8);
        }
        out.writeByte(0);
        out.writeInt(rowCount);
        out.setInt(pos + 1, out.writerIndex() - pos - 1);
    }

    private static int estimateExecute(String portal, int rowCount) {
        return 5 + (portal != null ? DataTypeEstimator.estimateUTF8(portal) : 0) + 1 + 4;
    }

    private static void renderDescribe(Describe describe, ByteBuf out) {
        int pos = out.writerIndex();
        out.writeByte(68);
        out.writeInt(0);
        if (describe.statement.length > 1) {
            out.writeByte(83);
            out.writeBytes(describe.statement);
        } else if (describe.portal != null) {
            out.writeByte(80);
            Util.writeCStringUTF8(out, describe.portal);
        } else {
            out.writeByte(83);
            Util.writeCStringUTF8(out, "");
        }
        out.setInt(pos + 1, out.writerIndex() - pos - 1);
    }

    private static int estimateDescribe(Describe describe) {
        int length = 5;
        length = describe.statement.length > 1 ? (length += 1 + DataTypeEstimator.estimateByteArray(describe.statement)) : (describe.portal != null ? (length += 1 + DataTypeEstimator.estimateCStringUTF8(describe.portal)) : (length += 1 + DataTypeEstimator.estimateCStringUTF8("")));
        return length;
    }

    private static void renderParse(String sql, byte[] statement, DataType[] parameterTypes, ByteBuf out) {
        int pos = out.writerIndex();
        out.writeByte(80);
        out.writeInt(0);
        out.writeBytes(statement);
        Util.writeCStringUTF8(out, sql);
        if (parameterTypes == null) {
            out.writeShort(0);
        } else {
            out.writeShort(parameterTypes.length);
            for (DataType parameterType : parameterTypes) {
                out.writeInt(parameterType.id);
            }
        }
        out.setInt(pos + 1, out.writerIndex() - pos - 1);
    }

    private static int estimateParse(String sql, byte[] statement, DataType[] parameterTypes) {
        return 5 + DataTypeEstimator.estimateByteArray(statement) + DataTypeEstimator.estimateCStringUTF8(sql) + 2 + (parameterTypes == null ? 0 : parameterTypes.length * 4);
    }

    private static void renderBind(Bind bind, String portal, Tuple paramValues, ByteBuf out) {
        int c;
        int pos = out.writerIndex();
        out.writeByte(66);
        out.writeInt(0);
        if (portal != null) {
            out.writeCharSequence((CharSequence)portal, StandardCharsets.UTF_8);
        }
        out.writeByte(0);
        out.writeBytes(bind.statement);
        int paramLen = paramValues.size();
        out.writeShort(paramLen);
        for (c = 0; c < paramLen; ++c) {
            out.writeShort(bind.paramTypes[c].supportsBinary ? 1 : 0);
        }
        out.writeShort(paramLen);
        for (c = 0; c < paramLen; ++c) {
            Object param = paramValues.getValue(c);
            if (param == null) {
                out.writeInt(-1);
                continue;
            }
            DataType dataType = bind.paramTypes[c];
            if (dataType.supportsBinary) {
                int idx = out.writerIndex();
                out.writeInt(0);
                DataTypeCodec.encodeBinary(dataType, param, out);
                out.setInt(idx, out.writerIndex() - idx - 4);
                continue;
            }
            DataTypeCodec.encodeText(dataType, param, out);
        }
        if (bind.resultColumns.length > 0) {
            out.writeShort(bind.resultColumns.length);
            for (PgColumnDesc resultColumn : bind.resultColumns) {
                out.writeShort(resultColumn.dataType.supportsBinary ? 1 : 0);
            }
        } else {
            out.writeShort(1);
            out.writeShort(1);
        }
        out.setInt(pos + 1, out.writerIndex() - pos - 1);
    }

    private static int estimateBind(Bind bind, String portal, Tuple paramValues) {
        int paramLen = paramValues.size();
        int length = 5 + (portal != null ? DataTypeEstimator.estimateUTF8(portal) : 0) + 1 + DataTypeEstimator.estimateByteArray(bind.statement) + 2 + paramLen * 2 + 2;
        for (int c = 0; c < paramLen; ++c) {
            Object param = paramValues.getValue(c);
            if (param == null) {
                length += 4;
                continue;
            }
            DataType dataType = bind.paramTypes[c];
            length += 4;
            if (dataType.supportsBinary) {
                int estimator = dataType.lengthEstimator;
                if (dataType.array) {
                    Object[] array;
                    length += 20;
                    for (Object elt : array = (Object[])param) {
                        length += 4;
                        if (elt == null) continue;
                        length += DataTypeEstimator.estimate(estimator, elt);
                    }
                    continue;
                }
                length += DataTypeEstimator.estimate(estimator, param);
                continue;
            }
            length += DataTypeEstimator.estimate(dataType.lengthEstimator, param);
        }
        length = bind.resultColumns.length > 0 ? (length += 2 + bind.resultColumns.length * 2) : (length += 4);
        return length;
    }

    private static void renderClosePortal(String portal, ByteBuf out) {
        int pos = out.writerIndex();
        out.writeByte(67);
        out.writeInt(0);
        out.writeByte(80);
        Util.writeCStringUTF8(out, portal);
        out.setInt(pos + 1, out.writerIndex() - pos - 1);
    }

    private static int estimateClosePortal(String portal) {
        return 6 + DataTypeEstimator.estimateCStringUTF8(portal);
    }

    void close() {
        ByteBuf buff = this.renderPendingMessages();
        this.ctx.writeAndFlush((Object)buff).addListener(v -> {
            Channel ch = this.channelHandlerContext().channel();
            if (ch instanceof SocketChannel) {
                SocketChannel channel = (SocketChannel)ch;
                channel.shutdownOutput();
            }
        });
    }

    void flush() {
        ByteBuf buff = this.renderPendingMessages();
        if (buff == Unpooled.EMPTY_BUFFER) {
            this.ctx.flush();
        } else {
            this.ctx.writeAndFlush((Object)buff, this.ctx.voidPromise());
        }
    }

    void writeTerminate() {
        this.enqueueMessage(TerminateMessage.INSTANCE, PgEncoder.estimateTerminate());
    }

    void writeSync() {
        this.enqueueMessage(SyncMessage.INSTANCE, PgEncoder.estimateSync());
    }

    void writeClosePortal(String portal) {
        this.enqueueMessage(ClosePortalMessage.INSTANCE, portal, PgEncoder.estimateClosePortal(portal));
    }

    void writeClosePreparedStatement(byte[] statementName) {
        this.enqueueMessage(ClosePreparedStatementMessage.INSTANCE, statementName, PgEncoder.estimateClosePreparedStatement(statementName));
    }

    void writeStartupMessage(StartupMessage msg) {
        this.enqueueMessage(msg, PgEncoder.estimateStartupMessage(msg));
    }

    void writePasswordMessage(PasswordMessage msg) {
        this.enqueueMessage(msg, PgEncoder.estimatePasswordMessage(msg));
    }

    void writeScramClientInitialMessage(ScramClientInitialMessage msg) {
        this.enqueueMessage(msg, PgEncoder.estimateScramInitialMessage(msg));
    }

    void writeScramClientFinalMessage(ScramClientFinalMessage msg) {
        this.enqueueMessage(msg, PgEncoder.estimateScramFinalMessage(msg));
    }

    void writeQuery(Query query) {
        this.enqueueMessage(query, PgEncoder.estimateQueryMessage(query));
    }

    void writeDescribe(Describe describe) {
        this.enqueueMessage(describe, PgEncoder.estimateDescribe(describe));
    }

    void writeParse(String sql, byte[] statement, DataType[] parameterTypes) {
        this.enqueueMessage(ParseMessage.INSTANCE, sql, statement, parameterTypes, PgEncoder.estimateParse(sql, statement, parameterTypes));
    }

    void writeExecute(String portal, int rowCount) {
        this.enqueueMessage(ExecuteMessage.INSTANCE, portal, rowCount, PgEncoder.estimateExecute(portal, rowCount));
    }

    void writeBind(Bind bind, String portal, Tuple paramValues) {
        this.enqueueMessage(bind, portal, paramValues, PgEncoder.estimateBind(bind, portal, paramValues));
    }

    byte[] nextStatementName() {
        return this.psSeq.next();
    }

    public ChannelHandlerContext channelHandlerContext() {
        return this.ctx;
    }
}

