/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.codec;

import io.vertx.core.json.Json;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.internal.TupleInternal;
import java.util.Arrays;
import java.util.stream.Collectors;

interface ParamExtractor<T> {
    public static String extractUnknownType(TupleInternal tuple, int pos) {
        Object value = tuple.getValue(pos);
        if (value instanceof Object[]) {
            String[] strings = tuple.getArrayOfStrings(pos);
            return Arrays.stream(strings).collect(Collectors.joining(",", "{", "}"));
        }
        return tuple.getString(pos);
    }

    public T get(TupleInternal var1, int var2);

    private static String encodeJsonToString(Object value) {
        if (value == Tuple.JSON_NULL) {
            return "null";
        }
        return Json.encode((Object)value);
    }

    public static Object prepareUnknown(Object value) {
        return String.valueOf(value);
    }

    public static Object prepareJson(Object value) {
        return ParamExtractor.encodeJsonToString(value);
    }

    public static Object prepareNumeric(Object value) {
        if (!1.$assertionsDisabled && !(value instanceof Number)) {
            throw new AssertionError();
        }
        return value.toString();
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

