/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.codec;

import io.netty.util.CharsetUtil;
import io.vertx.core.buffer.Buffer;
import io.vertx.pgclient.data.Cidr;
import io.vertx.pgclient.data.Inet;
import io.vertx.pgclient.data.Path;
import io.vertx.pgclient.data.Polygon;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.charset.Charset;

class DataTypeEstimator {
    static final int UNSUPPORTED = 0;
    private static final int UTF8 = -1;
    static final int NUMERIC = -2;
    static final int NUMERIC_ARRAY = -7;
    static final int BUFFER = -3;
    static final int UNKNOWN = -6;
    static final int BOOL = 1;
    static final int INT2 = 2;
    static final int INT4 = 4;
    static final int INT8 = 8;
    static final int FLOAT4 = 4;
    static final int FLOAT8 = 8;
    static final int CHAR = -1;
    static final int VARCHAR = -1;
    static final int BPCHAR = -1;
    static final int TEXT = -1;
    static final int NAME = -1;
    static final int DATE = 4;
    static final int TIME = 8;
    static final int TIMETZ = 12;
    static final int TIMESTAMP = 8;
    static final int TIMESTAMPTZ = 8;
    static final int INTERVAL = 16;
    static final int BYTEA = -3;
    static final int INET = -10;
    static final int CIDR = -9;
    static final int UUID = 16;
    static final int JSON = -1;
    static final int JSONB = -8;
    static final int MONEY = 8;
    static final int POINT = 16;
    static final int LINE = 24;
    static final int LSEG = 32;
    static final int BOX = 32;
    static final int CIRCLE = 24;
    static final int POLYGON = -4;
    static final int PATH = -5;
    private static final float AVG_BYTES_PER_CHAR_UTF8 = CharsetUtil.encoder((Charset)CharsetUtil.UTF_8).averageBytesPerChar();

    DataTypeEstimator() {
    }

    static int estimateUTF8(String s) {
        return (int)((float)s.length() * AVG_BYTES_PER_CHAR_UTF8);
    }

    static int estimateByteArray(byte[] b) {
        return b.length;
    }

    static int estimateCStringUTF8(String s) {
        return DataTypeEstimator.estimateUTF8(s) + 1;
    }

    private static int estimateUnknown(String value) {
        return DataTypeEstimator.estimateUTF8(value);
    }

    private static int estimateJSONB(String value) {
        return 1 + DataTypeEstimator.estimateUTF8(value);
    }

    private static int estimateNumeric(String value) {
        return DataTypeEstimator.estimateUTF8(value);
    }

    private static int estimateInetOrCidr(Cidr value) {
        return DataTypeEstimator.estimateInetOrCidr(value.getAddress());
    }

    private static int estimateInetOrCidr(Inet value) {
        return DataTypeEstimator.estimateInetOrCidr(value.getAddress());
    }

    private static int estimateInetOrCidr(InetAddress address) {
        int len;
        if (address instanceof Inet6Address) {
            Inet6Address inet6Address = (Inet6Address)address;
            len = inet6Address.getAddress().length;
        } else if (address instanceof Inet4Address) {
            Inet4Address inet4Address = (Inet4Address)address;
            len = inet4Address.getAddress().length;
        } else {
            len = 0;
        }
        return 4 + len;
    }

    private static int estimateNumericArray(Object[] value) {
        int length = 1;
        for (Object elt : value) {
            length += elt == null ? 4 : DataTypeEstimator.estimateNumeric((String)elt);
        }
        return length += value.length;
    }

    private static int estimateBuffer(Buffer b) {
        return b.length();
    }

    private static int estimatePolygon(Polygon p) {
        return 4 + p.getPoints().size() * 16;
    }

    private static int estimatePath(Path p) {
        return 5 + p.getPoints().size() * 16;
    }

    static int estimate(int estimator, Object o) {
        if (estimator > 0) {
            return estimator;
        }
        switch (estimator) {
            case -9: {
                return DataTypeEstimator.estimateInetOrCidr((Cidr)o);
            }
            case -10: {
                return DataTypeEstimator.estimateInetOrCidr((Inet)o);
            }
            case -8: {
                return DataTypeEstimator.estimateJSONB((String)o);
            }
            case -6: {
                return DataTypeEstimator.estimateUnknown((String)o);
            }
            case -2: {
                return DataTypeEstimator.estimateNumeric((String)o);
            }
            case -7: {
                return DataTypeEstimator.estimateNumericArray((Object[])o);
            }
            case -1: {
                return DataTypeEstimator.estimateUTF8((String)o);
            }
            case -3: {
                return DataTypeEstimator.estimateBuffer((Buffer)o);
            }
            case -4: {
                return DataTypeEstimator.estimatePolygon((Polygon)o);
            }
            case -5: {
                return DataTypeEstimator.estimatePath((Path)o);
            }
        }
        throw new UnsupportedOperationException();
    }
}

