/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl;

import io.vertx.core.Completable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.PgNotice;
import io.vertx.pgclient.PgNotification;
import io.vertx.pgclient.impl.PgConnectionFactory;
import io.vertx.pgclient.impl.PgSocketConnection;
import io.vertx.pgclient.impl.codec.NoticeResponse;
import io.vertx.pgclient.impl.codec.TxFailedEvent;
import io.vertx.pgclient.spi.PgDriver;
import io.vertx.sqlclient.impl.Notification;
import io.vertx.sqlclient.impl.SocketConnectionBase;
import io.vertx.sqlclient.internal.Connection;
import io.vertx.sqlclient.internal.SqlConnectionBase;
import io.vertx.sqlclient.spi.ConnectionFactory;
import io.vertx.sqlclient.spi.Driver;

public class PgConnectionImpl
extends SqlConnectionBase<PgConnectionImpl>
implements PgConnection {
    private volatile Handler<PgNotification> notificationHandler;
    private volatile Handler<PgNotice> noticeHandler;

    public static Future<PgConnection> connect(ContextInternal context, PgConnectOptions options) {
        PgConnectionFactory client;
        try {
            client = new PgConnectionFactory(context.owner());
        }
        catch (Exception e) {
            return context.failedFuture((Throwable)e);
        }
        return PgConnectionImpl.prepareForClose((ContextInternal)context, client.connect((Context)context, options)).map(PgConnection::cast);
    }

    public PgConnectionImpl(PgConnectionFactory factory, ContextInternal context, Connection conn) {
        super(context, (ConnectionFactory)factory, conn, (Driver)PgDriver.INSTANCE);
    }

    @Override
    public PgConnection notificationHandler(Handler<PgNotification> handler) {
        this.notificationHandler = handler;
        return this;
    }

    public void handleEvent(Object event) {
        if (event instanceof Notification) {
            Handler<PgNotification> handler = this.notificationHandler;
            if (handler != null) {
                Notification notification = (Notification)event;
                handler.handle((Object)new PgNotification().setChannel(notification.getChannel()).setProcessId(notification.getProcessId()).setPayload(notification.getPayload()));
            }
        } else if (event instanceof NoticeResponse) {
            Handler<PgNotice> handler = this.noticeHandler;
            NoticeResponse noticeEvent = (NoticeResponse)event;
            PgNotice notice = new PgNotice().setSeverity(noticeEvent.getSeverity()).setCode(noticeEvent.getCode()).setMessage(noticeEvent.getMessage()).setDetail(noticeEvent.getDetail()).setHint(noticeEvent.getHint()).setPosition(noticeEvent.getPosition()).setInternalPosition(noticeEvent.getInternalPosition()).setInternalQuery(noticeEvent.getInternalQuery()).setWhere(noticeEvent.getWhere()).setFile(noticeEvent.getFile()).setLine(noticeEvent.getLine()).setRoutine(noticeEvent.getRoutine()).setSchema(noticeEvent.getSchema()).setTable(noticeEvent.getTable()).setColumn(noticeEvent.getColumn()).setDataType(noticeEvent.getDataType()).setConstraint(noticeEvent.getConstraint());
            if (handler != null) {
                handler.handle((Object)notice);
            } else {
                notice.log(SocketConnectionBase.logger);
            }
        } else if (event instanceof TxFailedEvent && this.tx != null) {
            this.tx.fail();
        }
    }

    @Override
    public PgConnection noticeHandler(Handler<PgNotice> handler) {
        this.noticeHandler = handler;
        return this;
    }

    @Override
    public int processId() {
        return this.conn.getProcessId();
    }

    @Override
    public int secretKey() {
        return this.conn.getSecretKey();
    }

    @Override
    public Future<Void> cancelRequest() {
        PromiseInternal promise = this.context.owner().getOrCreateContext().promise();
        this.context.emit((Object)promise, p -> {
            PgSocketConnection unwrap = (PgSocketConnection)this.conn.unwrap();
            ((PgConnectionFactory)this.factory).cancelRequest(unwrap.connectOptions(), this.processId(), this.secretKey()).onComplete((Completable)p);
        });
        return promise.future();
    }
}

