/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.pgclient.PgConnectOptionsConverter;
import io.vertx.pgclient.SslMode;
import io.vertx.pgclient.impl.PgConnectionUriParser;
import io.vertx.sqlclient.SqlConnectOptions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;

@DataObject
@JsonGen(publicConverter=false)
public class PgConnectOptions
extends SqlConnectOptions {
    public static final String DEFAULT_HOST = "localhost";
    public static int DEFAULT_PORT = 5432;
    public static final String DEFAULT_DATABASE = "db";
    public static final String DEFAULT_USER = "user";
    public static final String DEFAULT_PASSWORD = "pass";
    public static final int DEFAULT_PIPELINING_LIMIT = 256;
    public static final SslMode DEFAULT_SSLMODE = SslMode.DISABLE;
    public static final boolean DEFAULT_USE_LAYER_7_PROXY = false;
    public static final Map<String, String> DEFAULT_PROPERTIES;
    private int pipeliningLimit = 256;
    private SslMode sslMode = DEFAULT_SSLMODE;
    private boolean useLayer7Proxy = false;

    public static PgConnectOptions wrap(SqlConnectOptions options) {
        if (options instanceof PgConnectOptions) {
            return (PgConnectOptions)options;
        }
        return new PgConnectOptions(options);
    }

    public static PgConnectOptions fromUri(String connectionUri) throws IllegalArgumentException {
        JsonObject parsedConfiguration = PgConnectionUriParser.parse(connectionUri);
        return new PgConnectOptions(parsedConfiguration);
    }

    public static PgConnectOptions fromEnv() {
        PgConnectOptions pgConnectOptions = new PgConnectOptions();
        if (System.getenv("PGHOSTADDR") == null) {
            if (System.getenv("PGHOST") != null) {
                pgConnectOptions.setHost(System.getenv("PGHOST"));
            }
        } else {
            pgConnectOptions.setHost(System.getenv("PGHOSTADDR"));
        }
        if (System.getenv("PGPORT") != null) {
            try {
                pgConnectOptions.setPort(Integer.parseInt(System.getenv("PGPORT")));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (System.getenv("PGDATABASE") != null) {
            pgConnectOptions.setDatabase(System.getenv("PGDATABASE"));
        }
        if (System.getenv("PGUSER") != null) {
            pgConnectOptions.setUser(System.getenv("PGUSER"));
        }
        if (System.getenv("PGPASSWORD") != null) {
            pgConnectOptions.setPassword(System.getenv("PGPASSWORD"));
        }
        if (System.getenv("PGSSLMODE") != null) {
            pgConnectOptions.setSslMode(SslMode.of(System.getenv("PGSSLMODE")));
        }
        return pgConnectOptions;
    }

    public PgConnectOptions() {
    }

    public PgConnectOptions(JsonObject json) {
        super(json);
        PgConnectOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public PgConnectOptions(SqlConnectOptions other) {
        super(other);
        if (other instanceof PgConnectOptions) {
            PgConnectOptions opts = (PgConnectOptions)other;
            this.pipeliningLimit = opts.pipeliningLimit;
            this.sslMode = opts.sslMode;
        }
    }

    public PgConnectOptions(PgConnectOptions other) {
        super((SqlConnectOptions)other);
        this.pipeliningLimit = other.pipeliningLimit;
        this.sslMode = other.sslMode;
    }

    public PgConnectOptions setHost(String host) {
        return (PgConnectOptions)super.setHost(host);
    }

    public PgConnectOptions setPort(int port) {
        return (PgConnectOptions)super.setPort(port);
    }

    public PgConnectOptions setUser(String user) {
        return (PgConnectOptions)super.setUser(user);
    }

    public PgConnectOptions setPassword(String password) {
        return (PgConnectOptions)super.setPassword(password);
    }

    public PgConnectOptions setDatabase(String database) {
        return (PgConnectOptions)super.setDatabase(database);
    }

    public int getPipeliningLimit() {
        return this.pipeliningLimit;
    }

    public PgConnectOptions setPipeliningLimit(int pipeliningLimit) {
        if (pipeliningLimit < 1) {
            throw new IllegalArgumentException();
        }
        this.pipeliningLimit = pipeliningLimit;
        return this;
    }

    public PgConnectOptions setCachePreparedStatements(boolean cachePreparedStatements) {
        return (PgConnectOptions)super.setCachePreparedStatements(cachePreparedStatements);
    }

    public PgConnectOptions setPreparedStatementCacheMaxSize(int preparedStatementCacheMaxSize) {
        return (PgConnectOptions)super.setPreparedStatementCacheMaxSize(preparedStatementCacheMaxSize);
    }

    @GenIgnore
    public PgConnectOptions setPreparedStatementCacheSqlFilter(Predicate<String> predicate) {
        return (PgConnectOptions)super.setPreparedStatementCacheSqlFilter(predicate);
    }

    public PgConnectOptions setPreparedStatementCacheSqlLimit(int preparedStatementCacheSqlLimit) {
        return (PgConnectOptions)super.setPreparedStatementCacheSqlLimit(preparedStatementCacheSqlLimit);
    }

    public PgConnectOptions setProperties(Map<String, String> properties) {
        return (PgConnectOptions)super.setProperties(properties);
    }

    @GenIgnore
    public PgConnectOptions addProperty(String key, String value) {
        return (PgConnectOptions)super.addProperty(key, value);
    }

    public SslMode getSslMode() {
        return this.sslMode;
    }

    public PgConnectOptions setSslMode(SslMode sslmode) {
        this.sslMode = sslmode;
        return this;
    }

    public boolean getUseLayer7Proxy() {
        return this.useLayer7Proxy;
    }

    public PgConnectOptions setUseLayer7Proxy(boolean useLayer7Proxy) {
        this.useLayer7Proxy = useLayer7Proxy;
        return this;
    }

    public PgConnectOptions setReconnectAttempts(int attempts) {
        return (PgConnectOptions)super.setReconnectAttempts(attempts);
    }

    public PgConnectOptions setReconnectInterval(long interval) {
        return (PgConnectOptions)super.setReconnectInterval(interval);
    }

    public PgConnectOptions setTracingPolicy(TracingPolicy tracingPolicy) {
        return (PgConnectOptions)super.setTracingPolicy(tracingPolicy);
    }

    public PgConnectOptions setSslOptions(ClientSSLOptions sslOptions) {
        return (PgConnectOptions)super.setSslOptions(sslOptions);
    }

    protected void init() {
        super.init();
        this.setHost(DEFAULT_HOST);
        this.setPort(DEFAULT_PORT);
        this.setUser(DEFAULT_USER);
        this.setPassword(DEFAULT_PASSWORD);
        this.setDatabase(DEFAULT_DATABASE);
        this.setMetricsName("");
        this.setProperties(new HashMap<String, String>(DEFAULT_PROPERTIES));
    }

    public JsonObject toJson() {
        JsonObject json = super.toJson();
        PgConnectOptionsConverter.toJson(this, json);
        return json;
    }

    @GenIgnore
    public SocketAddress getSocketAddress() {
        if (!this.isUsingDomainSocket()) {
            return super.getSocketAddress();
        }
        return SocketAddress.domainSocketAddress((String)(this.getHost() + "/.s.PGSQL." + this.getPort()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PgConnectOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PgConnectOptions that = (PgConnectOptions)((Object)o);
        if (this.pipeliningLimit != that.pipeliningLimit) {
            return false;
        }
        return this.sslMode == that.sslMode;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.pipeliningLimit;
        result = 31 * result + this.sslMode.hashCode();
        return result;
    }

    public boolean isUsingDomainSocket() {
        return this.getHost().startsWith("/");
    }

    public PgConnectOptions merge(JsonObject other) {
        JsonObject json = this.toJson();
        json.mergeIn(other);
        return new PgConnectOptions(json);
    }

    static {
        HashMap<String, String> defaultProperties = new HashMap<String, String>();
        defaultProperties.put("application_name", "vertx-pg-client");
        defaultProperties.put("client_encoding", "utf8");
        defaultProperties.put("DateStyle", "ISO");
        defaultProperties.put("extra_float_digits", "2");
        DEFAULT_PROPERTIES = Collections.unmodifiableMap(defaultProperties);
    }
}

