/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.auth.scram;

import com.ongres.scram.client.ScramClient;
import com.ongres.scram.common.StringPreparation;
import com.ongres.scram.common.exception.ScramInvalidServerSignatureException;
import com.ongres.scram.common.exception.ScramParseException;
import com.ongres.scram.common.exception.ScramServerErrorException;
import com.ongres.scram.common.util.TlsServerEndpoint;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SslHandler;
import io.vertx.pgclient.impl.auth.scram.ScramSession;
import io.vertx.pgclient.impl.codec.ScramClientInitialMessage;
import io.vertx.pgclient.impl.util.Util;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class ScramSessionImpl
implements ScramSession {
    private final String username;
    private final char[] password;
    private ScramClient scramClient;

    public ScramSessionImpl(String username, char[] password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public ScramClientInitialMessage createInitialSaslMessage(ByteBuf in, ChannelHandlerContext ctx) {
        ArrayList<String> mechanisms = new ArrayList<String>();
        while (0 != in.getByte(in.readerIndex())) {
            String mechanism = Util.readCStringUTF8(in);
            mechanisms.add(mechanism);
        }
        if (mechanisms.isEmpty()) {
            throw new UnsupportedOperationException("SASL Authentication : the server returned no mechanism");
        }
        byte[] channelBindingData = this.extractChannelBindingData(ctx);
        this.scramClient = ScramClient.builder().advertisedMechanisms(mechanisms).username(this.username).password(this.password).stringPreparation(StringPreparation.POSTGRESQL_PREPARATION).channelBinding("tls-server-end-point", channelBindingData).build();
        return new ScramClientInitialMessage(this.scramClient.clientFirstMessage().toString(), this.scramClient.getScramMechanism().getName());
    }

    @Override
    public String receiveServerFirstMessage(ByteBuf in) {
        String serverFirstMessage = in.readCharSequence(in.readableBytes(), StandardCharsets.UTF_8).toString();
        try {
            this.scramClient.serverFirstMessage(serverFirstMessage);
        }
        catch (ScramParseException e) {
            throw new UnsupportedOperationException(e);
        }
        return this.scramClient.clientFinalMessage().toString();
    }

    @Override
    public void checkServerFinalMessage(ByteBuf in) {
        String serverFinalMessage = in.readCharSequence(in.readableBytes(), StandardCharsets.UTF_8).toString();
        try {
            this.scramClient.serverFinalMessage(serverFinalMessage);
        }
        catch (ScramInvalidServerSignatureException | ScramParseException | ScramServerErrorException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private byte[] extractChannelBindingData(ChannelHandlerContext ctx) {
        SSLSession sslSession;
        SslHandler sslHandler = (SslHandler)ctx.channel().pipeline().get(SslHandler.class);
        if (sslHandler != null && (sslSession = sslHandler.engine().getSession()) != null && sslSession.isValid()) {
            try {
                Certificate peerCert;
                Certificate[] certificates = sslSession.getPeerCertificates();
                if (certificates != null && certificates.length > 0 && (peerCert = certificates[0]) instanceof X509Certificate) {
                    X509Certificate cert = (X509Certificate)peerCert;
                    return TlsServerEndpoint.getChannelBindingData((X509Certificate)cert);
                }
            }
            catch (CertificateEncodingException | SSLException exception) {
                // empty catch block
            }
        }
        return new byte[0];
    }
}

